/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.item.IDatapackAbility;
import endorh.lazulib.common.LogUtil;
import endorh.lazulib.common.ObfuscationReflectionUtil;
import endorh.lazulib.text.TextUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IEffectAbility
extends IDatapackAbility {
    public boolean testConditions(LootContext var1);

    public void applyEffect(ServerPlayer var1);

    public void reapplyEffect(ServerPlayer var1);

    public void undoEffect(ServerPlayer var1);

    public float getConsumption();

    public static class EffectAbility
    implements IEffectAbility {
        private static final String REFLECTION_ERROR_MESSAGE = "Aerobatic Elytra Effect Abilities (if provided by datapacks) may not apply correctly";
        private static final Logger LOGGER = LogManager.getLogger();
        private static final ObfuscationReflectionUtil.SoftField<MobEffectInstance, Integer> EffectInstance$duration = ObfuscationReflectionUtil.getSoftField(MobEffectInstance.class, (String)"f_19503_", (String)"duration", arg_0 -> ((Logger)LOGGER).error(arg_0), (String)"Aerobatic Elytra Effect Abilities (if provided by datapacks) may not apply correctly");
        private static final ObfuscationReflectionUtil.SoftField<MobEffectInstance, MobEffectInstance> EffectInstance$hiddenEffects = ObfuscationReflectionUtil.getSoftField(MobEffectInstance.class, (String)"f_19510_", (String)"hiddenEffects", arg_0 -> ((Logger)LOGGER).error(arg_0), (String)"Aerobatic Elytra Effect Abilities (if provided by datapacks) may not apply correctly");
        public final String jsonName;
        public final ChatFormatting color;
        public final float defValue;
        public final float consumption;
        public final Map<MobEffect, Integer> effects;
        public final Predicate<LootContext> condition;
        protected String translationKey;
        protected ResourceLocation registryName = null;

        public EffectAbility(String jsonName, ChatFormatting color, float defValue, Map<MobEffect, Integer> effects, Predicate<LootContext> condition, float consumption) {
            this.jsonName = Objects.requireNonNull(jsonName);
            this.color = color != null ? color : ChatFormatting.GRAY;
            this.defValue = defValue;
            this.effects = effects != null ? effects : new HashMap();
            this.condition = condition != null ? condition : c -> true;
            this.consumption = consumption;
        }

        @Override
        public boolean testConditions(LootContext context) {
            return this.condition.test(context);
        }

        @Override
        public void reapplyEffect(ServerPlayer player) {
            this.applyEffect(player);
        }

        @Override
        public void applyEffect(ServerPlayer player) {
            for (MobEffect effect : this.effects.keySet()) {
                MobEffectInstance instance;
                MobEffectInstance active = player.m_21124_(effect);
                Integer level = this.effects.get(effect);
                if (active != null) {
                    if (level <= active.m_19564_()) {
                        if (active.m_19557_() > 0x3FFFFFFF) {
                            EffectInstance$duration.set((Object)active, (Object)Integer.MAX_VALUE);
                        }
                        return;
                    }
                    instance = new MobEffectInstance(effect, 0, level.intValue(), true, false, false);
                    player.m_7292_(instance);
                    EffectInstance$duration.set((Object)active, (Object)Integer.MAX_VALUE);
                    continue;
                }
                instance = new MobEffectInstance(effect, Integer.MAX_VALUE, level.intValue(), true, false, false);
                player.m_7292_(instance);
            }
        }

        @Override
        public void undoEffect(ServerPlayer player) {
            Map potionMap = player.m_21221_();
            block0: for (MobEffect effect : this.effects.keySet()) {
                MobEffectInstance instance = (MobEffectInstance)potionMap.get(effect);
                if (instance.m_19564_() == this.effects.get(effect).intValue() && instance.m_19557_() > 0x3FFFFFFF && instance.m_19571_() && !instance.m_19572_()) {
                    EffectInstance$duration.set((Object)instance, (Object)1);
                    continue;
                }
                for (int i = 255; i >= 0; --i) {
                    MobEffectInstance prev = instance;
                    if ((instance = (MobEffectInstance)EffectInstance$hiddenEffects.get((Object)prev)) == null) continue block0;
                    if (instance.m_19564_() != this.effects.get(effect).intValue() || instance.m_19557_() <= 0x3FFFFFFF || !instance.m_19571_() || instance.m_19572_()) continue;
                    EffectInstance$hiddenEffects.set((Object)prev, (Object)((MobEffectInstance)EffectInstance$hiddenEffects.get((Object)instance)));
                    continue block0;
                }
                LogUtil.errorOnce((Logger)LOGGER, (String)"Aborted infinite (?) recursion in effect linked array\nSomeone messed up potions");
            }
        }

        @Override
        public float getConsumption() {
            return this.consumption;
        }

        @Override
        public String getName() {
            return this.jsonName;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public MutableComponent getDisplayName() {
            if (this.registryName == null) {
                throw new IllegalStateException("Cannot get display name of unregistered IEffectAbility");
            }
            if (this.translationKey == null) {
                this.translationKey = "aerobaticelytra.effect-abilities." + this.fullName().replace(':', '.');
            }
            return I18n.m_118936_((String)this.translationKey) ? TextUtil.ttc((String)this.translationKey, (Object[])new Object[0]) : TextUtil.stc((String)this.jsonName);
        }

        @Override
        public IAbility.DisplayType getDisplayType() {
            return IAbility.DisplayType.BOOL;
        }

        @Override
        public float getDefault() {
            return this.defValue;
        }

        public String toString() {
            return this.jsonName;
        }

        public static class Deserializer
        implements JsonDeserializer<EffectAbility> {
            public static final String EFFECT_ABILITY_TYPE = "aerobaticelytra:effect";

            public EffectAbility deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Aerobatic elytra effect abilities must be JSON objects");
                }
                JsonObject obj = json.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                if (!type.equals(EFFECT_ABILITY_TYPE)) {
                    throw new JsonParseException("Unknown aerobatic elytra effect ability: '" + type + "'. Only known value is 'aerobaticelytra:effect'");
                }
                String jsonName = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                String colorName = GsonHelper.m_13851_((JsonObject)obj, (String)"color", (String)"GRAY");
                ChatFormatting color = ChatFormatting.m_126657_((String)colorName);
                if (color == null || !color.m_126664_()) {
                    throw new JsonParseException("Invalid aerobatic elytra effect ability: '" + colorName + "'");
                }
                float defValue = GsonHelper.m_13820_((JsonObject)obj, (String)"default", (float)0.0f);
                JsonObject effectsObj = GsonHelper.m_13841_((JsonObject)obj, (String)"effects", (JsonObject)new JsonObject());
                HashMap<MobEffect, Integer> effects = new HashMap<MobEffect, Integer>();
                for (Map.Entry entry : effectsObj.entrySet()) {
                    MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((String)entry.getKey()));
                    JsonObject effectData = ((JsonElement)entry.getValue()).getAsJsonObject();
                    effects.put(effect, GsonHelper.m_13824_((JsonObject)effectData, (String)"amplifier", (int)1) - 1);
                }
                JsonArray conditionsArr = GsonHelper.m_13832_((JsonObject)obj, (String)"conditions", (JsonArray)new JsonArray());
                Predicate<LootContext> condition = Arrays.stream((LootItemCondition[])context.deserialize((JsonElement)conditionsArr, LootItemCondition[].class)).reduce(Predicate::and).orElse((LootItemCondition)((Predicate<LootContext>)c -> true));
                float consumption = GsonHelper.m_13820_((JsonObject)obj, (String)"consumption", (float)0.0f);
                return new EffectAbility(jsonName, color, defValue, effects, condition, consumption);
            }
        }
    }
}

