/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.item;

import com.google.common.base.CaseFormat;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.text.TextUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public interface IAbility {
    public String getName();

    @Nullable
    default public ResourceLocation getRegistryKey() {
        return AerobaticElytraRegistries.getAbilityKey(this);
    }

    default public String fullName() {
        ResourceLocation key = Objects.requireNonNull(this.getRegistryKey(), "Unregistered ability " + this);
        return key.m_135827_().replace('`', '_') + ":" + this.getName();
    }

    default public void write(FriendlyByteBuf buf) {
        buf.m_130085_(Objects.requireNonNull(this.getRegistryKey(), "Unregistered ability " + this));
    }

    public static IAbility read(FriendlyByteBuf buf) {
        return AerobaticElytraRegistries.getAbility(buf.m_130281_());
    }

    public MutableComponent getDisplayName();

    public DisplayType getDisplayType();

    public float getDefault();

    @Nullable
    default public ChatFormatting getColor() {
        return null;
    }

    public static IAbility fromName(String name) {
        return AerobaticElytraRegistries.getAbilityByName(name);
    }

    public static boolean isDefined(String jsonName) {
        return AerobaticElytraRegistries.hasAbilityName(jsonName);
    }

    public static abstract class DisplayType {
        public boolean bool;
        public static final DisplayType DEFAULT = DisplayType.formatValue("%.1f");
        public static DisplayType HIDE = new DisplayType(){

            @Override
            public Optional<MutableComponent> format(IAbility ability, float value) {
                return Optional.empty();
            }
        };
        public static final DisplayType INTEGER = DisplayType.formatValue((Float v) -> String.format("%d", Math.round(v.floatValue())));
        public static final DisplayType INTEGER_NON_ZERO = DisplayType.filter(v -> v.floatValue() != 0.0f, INTEGER, HIDE);
        public static final DisplayType INTEGER_SUM = DisplayType.formatValue((Float v) -> String.format("%+d", Math.round(v.floatValue())));
        public static final DisplayType INTEGER_SUM_NON_ZERO = DisplayType.filter(v -> v.floatValue() != 0.0f, INTEGER_SUM, HIDE);
        public static final DisplayType NAME_ONLY_ALWAYS = new DisplayType(){

            @Override
            public Optional<MutableComponent> format(IAbility ability, float value) {
                return Optional.of(ability.getDisplayName());
            }
        };
        public static final DisplayType NON_ZERO = DisplayType.filter(v -> v.floatValue() != 0.0f, DEFAULT, HIDE);
        public static final DisplayType SUM = DisplayType.formatValue("%+.1f");
        public static final DisplayType SUM_NON_ZERO = DisplayType.filter(v -> v.floatValue() != 0.0f, SUM, HIDE);
        public static final DisplayType SCALE = DisplayType.formatValue("\u00d7%.1f");
        public static final DisplayType SCALE_NON_ONE = DisplayType.filter(v -> v.floatValue() != 1.0f, SCALE, HIDE);
        public static final DisplayType BOOL = DisplayType.filter(v -> v.floatValue() != 0.0f, NAME_ONLY_ALWAYS, HIDE, true);
        public static final DisplayType SCALE_BOOL = DisplayType.filter(v -> v.floatValue() == 1.0f || v.floatValue() == 0.0f, BOOL, SCALE, true);

        public DisplayType() {
            this(false);
        }

        public DisplayType(boolean bool) {
            this.bool = bool;
        }

        public abstract Optional<MutableComponent> format(IAbility var1, float var2);

        public boolean isBool() {
            return this.bool;
        }

        public static DisplayType formatValue(String format) {
            return DisplayType.formatValue((Float v) -> String.format(format, v));
        }

        public static DisplayType formatValue(Function<Float, String> formatter) {
            return DisplayType.formatValue(v -> TextUtil.stc((String)((String)formatter.apply((Float)v))), ChatFormatting.DARK_AQUA);
        }

        public static DisplayType formatValue(final Function<Float, Component> formatter, final ChatFormatting format) {
            return new DisplayType(){

                @Override
                public Optional<MutableComponent> format(IAbility ability, float value) {
                    return Optional.of(ability.getDisplayName().m_130946_(": ").m_7220_((Component)((Component)formatter.apply(Float.valueOf(value))).m_6879_().m_130940_(format)));
                }
            };
        }

        public static DisplayType filter(Predicate<Float> predicate, DisplayType ifTrue, DisplayType ifFalse) {
            return DisplayType.filter(predicate, ifTrue, ifFalse, false);
        }

        public static DisplayType filter(final Predicate<Float> predicate, final DisplayType ifTrue, final DisplayType ifFalse, boolean bool) {
            return new DisplayType(bool){

                @Override
                public Optional<MutableComponent> format(IAbility ability, float value) {
                    return predicate.test(Float.valueOf(value)) ? ifTrue.format(ability, value) : ifFalse.format(ability, value);
                }
            };
        }
    }

    public static enum Ability implements IAbility
    {
        FUEL(ChatFormatting.RED, 0.0f, DisplayType.DEFAULT),
        MAX_FUEL(ChatFormatting.LIGHT_PURPLE, 0.0f, DisplayType.DEFAULT),
        SPEED(ChatFormatting.GREEN, 1.0f, DisplayType.SCALE),
        LIFT(ChatFormatting.YELLOW, 0.0f, DisplayType.NON_ZERO),
        AQUATIC(ChatFormatting.BLUE, 1.0f, DisplayType.SCALE_BOOL),
        TRAIL(ChatFormatting.DARK_PURPLE, 1.0f, DisplayType.SCALE),
        ROCKETLESS(ChatFormatting.GRAY, 0.0f, DisplayType.BOOL);

        private final String jsonName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        private final String translationKey = "aerobaticelytra.abilities." + this.name().toLowerCase();
        private final ChatFormatting color;
        private final float defaultValue;
        private final DisplayType displayType;

        private Ability(ChatFormatting color, float defaultValue, DisplayType type) {
            this.color = color;
            this.defaultValue = defaultValue;
            this.displayType = type;
        }

        @Override
        public String getName() {
            return this.jsonName;
        }

        @Override
        public MutableComponent getDisplayName() {
            return TextUtil.ttc((String)this.translationKey, (Object[])new Object[0]);
        }

        @Override
        public DisplayType getDisplayType() {
            return this.displayType;
        }

        @Override
        public ChatFormatting getColor() {
            return this.color;
        }

        @Override
        public float getDefault() {
            return this.defaultValue;
        }
    }
}

