/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.item;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.lazulib.common.ColorUtil;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class ElytraDyement {
    protected static ElytraDyement dyement = new ElytraDyement();
    public Map<WingSide, WingDyement> sides = new HashMap<WingSide, WingDyement>();
    public boolean hasWingDyement;
    public int defaultColor;
    public static CauldronInteraction CLEAR_AEROBATIC_ELYTRA_DYE = (state, level, pos, player, hand, stack) -> {
        dyement.read(stack);
        if (dyement.isClear()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            dyement.clear();
            dyement.write(stack);
            player.m_36220_(Stats.f_12945_);
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public ElytraDyement() {
        this(AerobaticElytraItem.DEFAULT_COLOR);
    }

    public ElytraDyement(int defaultColor) {
        this.defaultColor = defaultColor;
        for (WingSide side : WingSide.values()) {
            this.sides.put(side, new WingDyement(this));
        }
    }

    public void read(ItemStack elytra) {
        this.read(elytra, this.defaultColor, true);
    }

    public void read(ItemStack elytra, boolean readWings) {
        this.read(elytra, this.defaultColor, readWings);
    }

    public void read(ItemStack elytra, int defaultColor) {
        this.read(elytra, defaultColor, true);
    }

    public void read(ItemStack elytra, int defaultColor, boolean readWings) {
        block4: {
            boolean bl = this.hasWingDyement = elytra.m_41737_("WingInfo") != null;
            if (!readWings) break block4;
            if (this.hasWingDyement) {
                for (WingSide side : this.sides.keySet()) {
                    this.sides.get((Object)side).read(elytra, side, defaultColor);
                }
            } else {
                this.sides.get((Object)WingSide.LEFT).read(elytra, WingSide.LEFT, defaultColor);
                for (WingSide side : WingSide.values()) {
                    if (side == WingSide.LEFT) continue;
                    this.sides.get((Object)side).read(elytra, side, defaultColor);
                }
            }
        }
    }

    public boolean isClear() {
        return this.sides.values().stream().noneMatch(d -> d.hasColor || d.hasPattern);
    }

    public WingDyement getFirst() {
        return this.sides.get((Object)WingSide.LEFT);
    }

    public void setColor(int color) {
        this.getFirst().setColor(color);
        this.hasWingDyement = false;
    }

    public void setPattern(DyeColor base, List<Pair<BannerPattern, DyeColor>> bannerData) {
        this.setPattern(base, bannerData, true);
    }

    public void setPattern(DyeColor base, List<Pair<BannerPattern, DyeColor>> bannerData, boolean addBase) {
        this.getFirst().setPattern(base, bannerData, addBase);
        this.hasWingDyement = false;
    }

    public void clear() {
        this.sides.values().forEach(WingDyement::clear);
        this.hasWingDyement = false;
    }

    public void setWing(WingSide side, WingDyement dye) {
        ElytraDyement parent = dye.parent;
        if (parent != null && parent != this) {
            parent.setWing(side, dye.copy());
        }
        dye.parent = this;
        this.sides.put(side, dye);
        this.hasWingDyement = true;
    }

    public WingDyement getWing(WingSide side) {
        if (!this.hasWingDyement) {
            this.sides.get((Object)side).copy(this.getFirst());
        }
        return this.sides.get((Object)side);
    }

    public void write(ItemStack stack) {
        if (this.hasWingDyement) {
            stack.m_41749_("BlockEntityTag");
            for (WingSide side : WingSide.values()) {
                this.sides.get((Object)side).write(stack, side);
            }
        } else {
            stack.m_41749_("WingInfo");
            this.getFirst().write(stack, null);
        }
    }

    public static void hideDyedFlag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int flags = tag.m_128451_("HideFlags");
        tag.m_128405_("HideFlags", flags |= ItemStack.TooltipPart.DYE.m_41809_());
    }

    @SubscribeEvent
    public static void registerCauldronInteractions(FMLCommonSetupEvent event) {
        CauldronInteraction.f_175607_.put(AerobaticElytraItems.AEROBATIC_ELYTRA, CLEAR_AEROBATIC_ELYTRA_DYE);
        CauldronInteraction.f_175607_.put(AerobaticElytraItems.AEROBATIC_ELYTRA_WING, CLEAR_AEROBATIC_ELYTRA_DYE);
    }

    public static ItemStack clearDyes(ItemStack elytra) {
        ItemStack result = elytra.m_41777_();
        dyement.read(result);
        dyement.clear();
        dyement.write(result);
        return result;
    }

    public static enum WingSide {
        LEFT("left", "aerobaticelytra.sides.left"),
        RIGHT("right", "aerobaticelytra.sides.right");

        public final String tag;
        public final String key;

        private WingSide(String tag, String key) {
            this.tag = tag;
            this.key = key;
        }

        public MutableComponent getTranslation() {
            return TextUtil.ttc((String)this.key, (Object[])new Object[0]);
        }
    }

    public static class WingDyement {
        protected ElytraDyement parent;
        public boolean hasColor;
        public boolean hasPattern;
        public int color;
        public DyeColor basePatternColor = null;
        public List<Pair<BannerPattern, DyeColor>> patternColorData;

        public WingDyement() {
            this.parent = null;
        }

        public WingDyement(ElytraDyement dyement) {
            this.parent = dyement;
        }

        public void setColor(int color) {
            this.hasPattern = false;
            this.hasColor = true;
            this.color = color;
            if (this.parent != null) {
                this.parent.hasWingDyement = true;
            }
        }

        public void setPattern(DyeColor base, List<Pair<BannerPattern, DyeColor>> patternData) {
            this.setPattern(base, patternData, true);
        }

        public void setPattern(DyeColor base, List<Pair<BannerPattern, DyeColor>> patternData, boolean addBase) {
            if (addBase) {
                patternData = new ArrayList<Pair<BannerPattern, DyeColor>>(patternData);
                patternData.add(0, (Pair<BannerPattern, DyeColor>)Pair.of((Object)((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(BannerPatterns.f_222726_)), (Object)base));
            }
            this.hasPattern = true;
            this.basePatternColor = base;
            this.patternColorData = patternData;
            this.color = ColorUtil.getTextureDiffuseColor((DyeColor)base);
            if (this.parent != null) {
                this.parent.hasWingDyement = true;
            }
        }

        public void clear() {
            this.hasColor = false;
            this.hasPattern = false;
            int n = this.color = this.parent != null ? this.parent.defaultColor : AerobaticElytraItem.DEFAULT_COLOR;
            if (this.parent != null) {
                this.parent.hasWingDyement = this.parent.isClear();
            }
        }

        public void read(ItemStack elytra, WingSide side, int defaultColor) {
            CompoundTag data;
            CompoundTag wingInfo = elytra.m_41737_("WingInfo");
            if (wingInfo == null) {
                data = elytra.m_41737_("BlockEntityTag");
                if (data == null) {
                    this.hasPattern = false;
                    this.patternColorData = null;
                    CompoundTag display = elytra.m_41737_("display");
                    if (display == null) {
                        this.hasColor = false;
                        this.color = defaultColor;
                    } else if (display.m_128441_("color")) {
                        this.hasColor = true;
                        this.color = display.m_128451_("color");
                    } else {
                        this.hasColor = false;
                        this.color = defaultColor;
                    }
                    return;
                }
            } else {
                data = wingInfo.m_128469_(side.tag);
            }
            if (data.m_128441_("Base")) {
                this.hasColor = false;
                this.hasPattern = true;
                this.basePatternColor = DyeColor.m_41053_((int)data.m_128451_("Base"));
                this.color = ColorUtil.getTextureDiffuseColor((DyeColor)this.basePatternColor);
                this.patternColorData = WingDyement.getPatternColorData(this.basePatternColor, data.m_128437_("Patterns", 10).m_6426_());
            } else {
                this.hasPattern = false;
                this.patternColorData = null;
                if (data.m_128441_("color")) {
                    this.hasColor = true;
                    this.color = data.m_128451_("color");
                } else if (data.m_128441_("display")) {
                    CompoundTag display = data.m_128469_("display");
                    if (display.m_128441_("color")) {
                        this.hasColor = true;
                        this.color = display.m_128451_("color");
                    } else {
                        this.hasColor = false;
                        this.color = defaultColor;
                    }
                } else {
                    this.hasColor = false;
                    this.color = defaultColor;
                }
            }
        }

        public static List<Pair<BannerPattern, DyeColor>> getPatternColorData(DyeColor color, @Nullable ListTag nbtList) {
            ArrayList<Pair<BannerPattern, DyeColor>> list = new ArrayList<Pair<BannerPattern, DyeColor>>();
            list.add(Pair.of((Object)((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(BannerPatterns.f_222726_)), (Object)color));
            if (nbtList != null) {
                for (int i = 0; i < nbtList.size(); ++i) {
                    CompoundTag elem = nbtList.m_128728_(i);
                    Holder holder = BannerPattern.m_222700_((String)elem.m_128461_("Pattern"));
                    if (holder == null) continue;
                    int j = elem.m_128451_("Color");
                    list.add((Pair<BannerPattern, DyeColor>)Pair.of((Object)((BannerPattern)holder.m_203334_()), (Object)DyeColor.m_41053_((int)j)));
                }
            }
            return list;
        }

        public void copy(WingDyement wingDyement) {
            this.hasColor = wingDyement.hasColor;
            this.hasPattern = wingDyement.hasPattern;
            this.color = wingDyement.color;
            this.basePatternColor = wingDyement.basePatternColor;
            this.patternColorData = wingDyement.patternColorData;
        }

        public WingDyement copy() {
            WingDyement wing = new WingDyement();
            wing.copy(this);
            return wing;
        }

        public void write(ItemStack stack, @Nullable WingSide side) {
            if (this.hasPattern) {
                CompoundTag nbt;
                if (side != null) {
                    nbt = stack.m_41698_("WingInfo");
                    nbt.m_128365_(side.tag, (Tag)new CompoundTag());
                    nbt = nbt.m_128469_(side.tag);
                } else {
                    nbt = stack.m_41698_("BlockEntityTag");
                }
                nbt.m_128405_("Base", this.basePatternColor.m_41060_());
                ListTag list = new ListTag();
                for (int i = 1; i < this.patternColorData.size(); ++i) {
                    BannerPattern pattern = (BannerPattern)this.patternColorData.get(i).getFirst();
                    DyeColor color = (DyeColor)this.patternColorData.get(i).getSecond();
                    CompoundTag item2 = new CompoundTag();
                    item2.m_128359_("Pattern", pattern.m_58579_());
                    item2.m_128405_("Color", color.m_41060_());
                    list.add((Object)item2);
                }
                nbt.m_128365_("Patterns", (Tag)list);
            } else if (this.hasColor) {
                CompoundTag nbt;
                if (side != null) {
                    nbt = stack.m_41698_("WingInfo");
                    nbt.m_128365_(side.tag, (Tag)new CompoundTag());
                    nbt = nbt.m_128469_(side.tag);
                    nbt.m_128473_("Base");
                    nbt.m_128473_("Patterns");
                } else {
                    stack.m_41749_("BlockEntityTag");
                    nbt = stack.m_41698_("display");
                }
                nbt.m_128405_("color", this.color);
            } else {
                stack.m_41749_("BlockEntityTag");
                CompoundTag display = stack.m_41737_("display");
                if (display != null) {
                    display.m_128473_("color");
                }
                if (side != null) {
                    CompoundTag nbt = stack.m_41737_("WingInfo");
                    if (nbt != null) {
                        nbt.m_128473_(side.tag);
                        if (nbt.m_128456_()) {
                            stack.m_41749_("WingInfo");
                        }
                    }
                } else {
                    stack.m_41749_("WingInfo");
                }
            }
            ElytraDyement.hideDyedFlag(stack);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WingDyement that = (WingDyement)o;
            return this.hasColor == that.hasColor && this.hasPattern == that.hasPattern && this.color == that.color && this.basePatternColor == that.basePatternColor && Objects.equals(this.patternColorData, that.patternColorData);
        }

        public int hashCode() {
            return Objects.hash(this.hasColor, this.hasPattern, this.color, this.basePatternColor, this.patternColorData);
        }
    }
}

