/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.item;

import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.block.AerobaticBlocks;
import endorh.aerobaticelytra.common.block.BrokenLeavesBlock;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.lazulib.math.Vec3f;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AerobaticElytraWingItem
extends Item
implements DyeableLeatherItem {
    public static final String NAME = "aerobatic_elytra_wing";

    public AerobaticElytraWingItem() {
        this(new Item.Properties());
    }

    public AerobaticElytraWingItem(Item.Properties builder) {
        super(builder);
    }

    public static ItemStack createDebugWing() {
        ItemStack stack = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA_WING, 1);
        stack.m_41714_((Component)Component.m_237113_((String)"Debug Wing"));
        return stack;
    }

    public static boolean canUseDebugWing(Player player) {
        return player.m_7500_();
    }

    public static boolean hasDebugWing(Player player) {
        return AerobaticElytraWingItem.canUseDebugWing(player) && (AerobaticElytraWingItem.isDebugWing(player.m_21120_(InteractionHand.MAIN_HAND)) || AerobaticElytraWingItem.isDebugWing(player.m_21120_(InteractionHand.OFF_HAND)));
    }

    public static boolean hasOffhandDebugWing(Player player) {
        return AerobaticElytraWingItem.canUseDebugWing(player) && AerobaticElytraWingItem.isDebugWing(player.m_21120_(InteractionHand.OFF_HAND));
    }

    public static boolean isDebugWing(ItemStack stack) {
        return stack.m_41720_() == AerobaticElytraItems.AEROBATIC_ELYTRA_WING && "Debug Wing".equals(stack.m_41786_().getString());
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (AerobaticElytraWingItem.isDebugWing(stack) && player != null && AerobaticElytraWingItem.canUseDebugWing(player)) {
            BlockPos next;
            BlockPos pos = context.m_8083_();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (state.m_204336_(BlockTags.f_13035_)) {
                BrokenLeavesBlock.breakLeaves(world, pos);
            } else if (block == AerobaticBlocks.BROKEN_LEAVES && context.m_43721_() && world.m_8055_(next = pos.m_121996_(context.m_43719_().m_122436_())).m_204336_(BlockTags.f_13035_)) {
                BrokenLeavesBlock.breakLeaves(world, next);
                BlockPos down = next.m_7495_();
                if (world.m_8055_(down).m_204336_(BlockTags.f_13035_)) {
                    BrokenLeavesBlock.breakLeaves(world, down);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return super.m_6225_(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        if (data.isFlying() && AerobaticElytraWingItem.hasDebugWing(player)) {
            if (player.m_6144_()) {
                data.setTiltPitch(0.0f);
                data.setTiltRoll(0.0f);
                data.setTiltYaw(0.0f);
            } else {
                VectorBase base = data.getRotationBase();
                Vec3f ax = Vec3f.forAxis((Direction.Axis)Direction.Axis.X);
                base.mirror(ax);
                Vec3f motionVec = new Vec3f(player.m_20184_());
                motionVec.reflect(ax);
                player.m_20256_(motionVec.toVector3d());
                data.setLastBounceTime(System.currentTimeMillis());
                data.getPreBounceBase().set(data.getCameraBase());
                data.getPosBounceBase().set(base);
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return super.m_5812_(stack) && ClientConfig.style.visibility.enchantment_glint_visibility.test() || AerobaticElytraWingItem.isDebugWing(stack);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        MutableComponent name = super.m_7626_(stack).m_6879_();
        return "Debug Wing".equals(name.getString()) ? name.m_130940_(ChatFormatting.OBFUSCATED).m_130940_(ChatFormatting.LIGHT_PURPLE) : name.m_130940_(ChatFormatting.BLUE);
    }

    public int getMaxDamage(ItemStack stack) {
        if (AerobaticElytraItems.AEROBATIC_ELYTRA != null) {
            return AerobaticElytraItems.AEROBATIC_ELYTRA.getMaxDamage(stack);
        }
        return super.getMaxDamage(stack);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag display = stack.m_41737_("display");
        if (display != null) {
            return display.m_128425_("color", 99) ? display.m_128451_("color") : AerobaticElytraItem.DEFAULT_COLOR;
        }
        display = stack.m_41737_("BlockEntityTag");
        if (display != null) {
            return DyeColor.m_41053_((int)display.m_128451_("Base")).m_41071_();
        }
        return AerobaticElytraItem.DEFAULT_COLOR;
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        return super.m_41113_(stack) || tag != null;
    }

    public void m_41123_(@NotNull ItemStack stack) {
        super.m_41123_(stack);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            stack.m_41749_("BlockEntityTag");
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (!AerobaticElytraWingItem.isDebugWing(stack)) {
            tooltip.addAll(this.getTooltipInfo(stack, flag));
            if (!stack.m_41785_().isEmpty()) {
                tooltip.add((Component)TextUtil.stc((String)""));
            }
        } else {
            tooltip.add((Component)TextUtil.ttc((String)"item.aerobaticelytra.aerobatic_elytra_wing.debug_wing.tooltip", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    public AerobaticElytraItem getElytraItem() {
        return AerobaticElytraItems.AEROBATIC_ELYTRA;
    }

    public List<Component> getTooltipInfo(ItemStack stack, TooltipFlag flag) {
        return this.getTooltipInfo(stack, flag, "");
    }

    public List<Component> getTooltipInfo(ItemStack stack, TooltipFlag flag, String indent) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        AerobaticElytraItem aerobaticElytra = this.getElytraItem();
        aerobaticElytra.addFuelTooltipInfo(tooltip, stack, flag, indent);
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        spec.addAbilityTooltipInfo(tooltip, indent);
        aerobaticElytra.addDyementTooltipInfo(stack, flag, indent, tooltip);
        IElytraSpec.TrailData.addTooltipInfo(tooltip, spec.getTrailData(), ElytraDyement.WingSide.LEFT, indent);
        return tooltip;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag shareTag = new CompoundTag();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            shareTag.m_128365_("tag", (Tag)tag);
        }
        ElytraSpecCapability.getElytraSpec(stack).ifPresent(spec -> shareTag.m_128365_("cap", (Tag)ElytraSpecCapability.asNBT(spec)));
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            stack.m_41751_(nbt.m_128441_("tag") ? nbt.m_128469_("tag") : null);
            if (nbt.m_128441_("cap")) {
                ElytraSpecCapability.getElytraSpecOrDefault(stack).copy(ElytraSpecCapability.fromNBT(nbt.m_128469_("cap")));
            }
        } else {
            stack.m_41751_(null);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            return ElytraSpecCapability.createProvider();
        }
        return ElytraSpecCapability.createProvider(ElytraSpecCapability.fromNBT(nbt.m_128469_("Parent")));
    }
}

