/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.item;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.recipe.CreativeTabAbilitySetRecipe;
import endorh.aerobaticelytra.common.recipe.RepairRecipe;
import endorh.lazulib.common.ColorUtil;
import endorh.lazulib.common.ForgeUtil;
import endorh.lazulib.nbt.NBTPath;
import endorh.lazulib.text.TextUtil;
import endorh.lazulib.text.TooltipUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AerobaticElytraItem
extends ElytraItem
implements Equipable,
DyeableLeatherItem {
    public static final String NAME = "aerobatic_elytra";
    public static int DEFAULT_COLOR = 9412270;
    protected final ElytraDyement dyement = new ElytraDyement();

    public AerobaticElytraItem() {
        this(new Item.Properties());
    }

    public AerobaticElytraItem(Item.Properties builder) {
        super(builder.m_41503_(1296).m_41497_(Rarity.RARE));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public void fillItemGroup(String groupLabel, NonNullList<ItemStack> items) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        List<Recipe> abilitySets = world.m_7465_().m_44051_().stream().filter(recipe -> recipe instanceof CreativeTabAbilitySetRecipe).toList();
        for (CreativeTabAbilitySetRecipe creativeTabAbilitySetRecipe : abilitySets) {
            if (!groupLabel.equals(creativeTabAbilitySetRecipe.group) && !groupLabel.equals("search")) continue;
            items.add((Object)creativeTabAbilitySetRecipe.stack);
        }
    }

    public int getDamage(ItemStack stack) {
        return Math.min(super.getDamage(stack), this.getMaxDamage(stack) - 1);
    }

    public int getMaxDamage(ItemStack stack) {
        return Config.item.durability;
    }

    public boolean m_41465_() {
        return !Config.item.undamageable;
    }

    public boolean shouldFuelReplaceDurability(ItemStack stack) {
        return this.shouldFuelReplaceDurability(stack, ElytraSpecCapability.getElytraSpecOrDefault(stack));
    }

    public boolean shouldFuelReplaceDurability(ItemStack stack, IElytraSpec spec) {
        return (ClientConfig.style.visibility.fuel_display == ClientConfig.FuelDisplay.DURABILITY_BAR || ClientConfig.style.visibility.fuel_display == ClientConfig.FuelDisplay.DURABILITY_BAR_IF_LOWER && spec.getAbility(IAbility.Ability.FUEL) / spec.getAbility(IAbility.Ability.MAX_FUEL) < 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()) && ClientConfig.style.visibility.fuel_visibility.test();
    }

    public boolean shouldFuelRenderOverRockets(ItemStack stack) {
        return ClientConfig.style.visibility.fuel_display == ClientConfig.FuelDisplay.ROCKETS;
    }

    public float getFuelFraction(ItemStack stack) {
        return this.getFuelFraction(stack, ElytraSpecCapability.getElytraSpecOrDefault(stack));
    }

    public float getFuelFraction(ItemStack stack, IElytraSpec spec) {
        return spec.getAbility(IAbility.Ability.MAX_FUEL) == 0.0f ? 0.0f : spec.getAbility(IAbility.Ability.FUEL) / spec.getAbility(IAbility.Ability.MAX_FUEL);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        if (this.shouldFuelReplaceDurability(stack, spec)) {
            return spec.getAbility(IAbility.Ability.MAX_FUEL) == 0.0f || spec.getAbility(IAbility.Ability.FUEL) < spec.getAbility(IAbility.Ability.MAX_FUEL);
        }
        return super.m_142522_(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        if (this.shouldFuelReplaceDurability(stack, spec)) {
            return Math.round(this.getFuelFraction(stack, spec) * 13.0f);
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        if (this.shouldFuelReplaceDurability(stack)) {
            return Mth.m_14169_((float)Mth.m_14179_((float)(1.0f - this.getFuelFraction(stack)), (float)0.58f, (float)0.7f), (float)0.8f, (float)1.0f);
        }
        return super.m_142159_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.addAll(this.getTooltipInfo(stack, flag));
        if (!stack.m_41785_().isEmpty()) {
            tooltip.add((Component)TextUtil.stc((String)""));
        }
    }

    public List<Component> getTooltipInfo(ItemStack stack, TooltipFlag flag) {
        return this.getTooltipInfo(stack, flag, "");
    }

    public List<Component> getTooltipInfo(ItemStack stack, TooltipFlag flag, String indent) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.addFuelTooltipInfo(tooltip, stack, flag, indent);
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        spec.addAbilityTooltipInfo(tooltip, indent);
        this.addDyementTooltipInfo(stack, flag, indent, tooltip);
        IElytraSpec.TrailData.addTooltipInfo(tooltip, spec.getTrailData(), indent);
        return tooltip;
    }

    public void addFuelTooltipInfo(List<Component> tooltip, ItemStack stack, TooltipFlag flag, String indent) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)"aerobaticelytra.item.fuel", (Object[])new Object[]{TextUtil.stc((String)String.format("%.1f", Float.valueOf(spec.getAbility(IAbility.Ability.FUEL)))).m_130940_(ChatFormatting.AQUA), String.format("%.1f", Float.valueOf(spec.getAbility(IAbility.Ability.MAX_FUEL)))}).m_130940_(ChatFormatting.GRAY)));
        if (!flag.m_7050_()) {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)"item.durability", (Object[])new Object[]{TextUtil.stc((String)String.format("%d", this.getMaxDamage(stack) - this.getDamage(stack))).m_130940_(ChatFormatting.GOLD), String.format("%d", this.getMaxDamage(stack))}).m_130940_(ChatFormatting.GRAY)));
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return TextUtil.ttc((String)this.m_5671_(stack), (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_AQUA);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return super.m_5812_(stack) && ClientConfig.style.visibility.enchantment_glint_visibility.test();
    }

    public boolean hasModelEffect(@NotNull ItemStack stack) {
        return super.m_5812_(stack);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return RepairRecipe.getRepairRecipes().stream().anyMatch(r -> r.ingredient.test(repair));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        EquipmentSlot equipmentSlotType = Mob.m_147233_((ItemStack)itemStack);
        ItemStack equippedStack = player.m_6844_(equipmentSlotType);
        if (equippedStack.m_41619_()) {
            player.m_8061_(equipmentSlotType, itemStack.m_41777_());
            itemStack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public boolean canElytraFly(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional<IFlightData> dat = FlightDataCapability.getFlightData(player);
            if (dat.isEmpty()) {
                return false;
            }
            IFlightData fd = dat.get();
            if (!fd.getFlightMode().is(FlightModeTags.ELYTRA)) {
                return false;
            }
            if (player.m_7500_()) {
                return true;
            }
        }
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean elytraFlightTick(@NotNull ItemStack stack, LivingEntity entity, int flightTicks) {
        IAerobaticData data;
        if (!entity.m_9236_().f_46443_ && (flightTicks + 1) % 20 == 0 && !Config.item.undamageable) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        if (entity instanceof Player && (data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)entity)).isFlying() && !((Player)entity).m_7500_()) {
            float rel_prop = Math.abs(data.getPropulsionStrength()) / Math.max(Math.abs(Config.aerobatic.propulsion.range_tick.getFloatMax()), Math.abs(Config.aerobatic.propulsion.range_tick.getFloatMin()));
            float fuel_usage = rel_prop * Config.fuel.usage_linear_tick + rel_prop * rel_prop * Config.fuel.usage_quad_tick + Mth.m_14116_((float)rel_prop) * Config.fuel.usage_sqrt_tick;
            if (data.isBoosted()) {
                fuel_usage *= Config.fuel.usage_boost_multiplier;
            }
            IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
            spec.setAbility(IAbility.Ability.FUEL, Math.max(0.0f, Math.min(spec.getAbility(IAbility.Ability.MAX_FUEL), spec.getAbility(IAbility.Ability.FUEL) - fuel_usage)));
        }
        return true;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag shareTag = new CompoundTag();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            shareTag.m_128365_("tag", (Tag)tag);
        }
        ElytraSpecCapability.getElytraSpec(stack).ifPresent(spec -> shareTag.m_128365_("cap", (Tag)ElytraSpecCapability.asNBT(spec)));
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            stack.m_41751_(nbt.m_128441_("tag") ? nbt.m_128469_("tag") : null);
            if (nbt.m_128441_("cap")) {
                ElytraSpecCapability.getElytraSpecOrDefault(stack).copy(ElytraSpecCapability.fromNBT(nbt.m_128469_("cap")));
            }
        } else {
            stack.m_41751_(null);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            return ElytraSpecCapability.createProvider();
        }
        return ElytraSpecCapability.createProvider(ElytraSpecCapability.fromNBT(nbt.m_128469_("Parent")));
    }

    public boolean shouldRenderAerobaticElytraLayer(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldRenderAerobaticElytraRockets(ItemStack stack, LivingEntity entity) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        return spec.getAbility(IAbility.Ability.ROCKETLESS) == 0.0f;
    }

    public boolean shouldRenderAerobaticElytraBackRockets(ItemStack stack, LivingEntity entity) {
        return this.shouldRenderAerobaticElytraRockets(stack, entity);
    }

    public int m_41121_(@NotNull ItemStack stack) {
        this.dyement.read(stack, DEFAULT_COLOR);
        if (this.dyement.hasWingDyement) {
            return ColorUtil.mix((int[])new int[]{this.dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).color, this.dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.RIGHT).color});
        }
        return this.dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).color;
    }

    public ResourceLocation getTextureLocation(BannerPattern pattern) {
        return new ResourceLocation("aerobaticelytra", "entity/aerobatic_elytra/" + BuiltInRegistries.f_256878_.m_7854_((Object)pattern).map(k -> k.m_135782_().m_135815_()).orElse("missing"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Material getBannerMaterial(BannerPattern pattern) {
        return AerobaticElytra.BANNER_TEXTURE_MANAGER.getBannerMaterial(pattern);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addDyementTooltipInfo(ItemStack stack, TooltipFlag flag, String indent, List<Component> tooltip) {
        this.dyement.read(stack, DEFAULT_COLOR);
        if (this.dyement.hasWingDyement) {
            for (ElytraDyement.WingSide side : ElytraDyement.WingSide.values()) {
                ElytraDyement.WingDyement wingDye = this.dyement.getWing(side);
                if (wingDye.hasPattern) {
                    this.addBannerTooltipInfo(tooltip, wingDye, "aerobaticelytra.side." + side.tag, indent);
                    continue;
                }
                this.addColorTooltipInfo(tooltip, "aerobaticelytra.side.color." + side.tag, wingDye, flag, indent);
            }
        } else {
            ElytraDyement.WingDyement wingDye = this.dyement.getFirst();
            if (wingDye.hasPattern) {
                this.addBannerTooltipInfo(tooltip, wingDye, null, indent);
            } else {
                this.addColorTooltipInfo(tooltip, "item.color", wingDye, flag, indent);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addColorTooltipInfo(List<Component> tooltip, String key, ElytraDyement.WingDyement wing, TooltipFlag flag, String indent) {
        if (wing.hasColor) {
            Color color = new Color(wing.color);
            MutableComponent colorName = flag.m_7050_() ? TextUtil.stc((String)String.format("#%6h", color)).m_130940_(ChatFormatting.GRAY) : ColorUtil.closestDyeColor((Color)color).map(dyeColor -> TextUtil.ttc((String)("color.minecraft." + dyeColor.m_41065_()), (Object[])new Object[0])).orElseGet(() -> TextUtil.ttc((String)"item.minecraft.firework_star.custom_color", (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)key, (Object[])new Object[]{TextUtil.stc((String)"\u2248").m_7220_((Component)colorName).m_130940_(ColorUtil.discardBlack((ChatFormatting)ColorUtil.closestTextColor((Color)color).orElse(ChatFormatting.GRAY)))})).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)key, (Object[])new Object[]{TextUtil.ttc((String)"gui.none", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)})).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void addBannerTooltipInfo(List<Component> tooltip, ElytraDyement.WingDyement wing, String key, String indent) {
        MutableComponent sideParenthesis;
        List<Pair<BannerPattern, DyeColor>> layers = wing.patternColorData;
        MutableComponent mutableComponent = sideParenthesis = key != null ? TextUtil.stc((String)" (").m_7220_((Component)TextUtil.ttc((String)key, (Object[])new Object[0])).m_130946_(")") : TextUtil.stc((String)"");
        if (layers.size() == 1) {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)("block.minecraft." + wing.basePatternColor.m_41065_() + "_banner"), (Object[])new Object[0])).m_7220_((Component)sideParenthesis).m_130940_(ChatFormatting.GRAY));
        } else if (Screen.m_96638_()) {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)("block.minecraft." + wing.basePatternColor.m_41065_() + "_banner"), (Object[])new Object[0])).m_7220_((Component)sideParenthesis).m_130946_(": ").m_7220_((Component)TooltipUtil.shiftToExpand()).m_130940_(ChatFormatting.GRAY));
            String extraIndent = indent + "  ";
            for (int i = 1; i < wing.patternColorData.size(); ++i) {
                BannerPattern pattern = (BannerPattern)wing.patternColorData.get(i).getFirst();
                DyeColor color = (DyeColor)wing.patternColorData.get(i).getSecond();
                tooltip.add((Component)TextUtil.stc((String)extraIndent).m_7220_((Component)TextUtil.ttc((String)("block.minecraft.banner." + BuiltInRegistries.f_256878_.m_7854_((Object)pattern).map(k -> k.m_135782_().m_135815_()).orElse("missing") + "." + color.m_41065_()), (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)("block.minecraft." + wing.basePatternColor.m_41065_() + "_banner"), (Object[])new Object[0]).m_7220_((Component)sideParenthesis).m_130946_(": ").m_7220_((Component)TooltipUtil.shiftToExpand())).m_130940_(ChatFormatting.GRAY));
        }
    }

    public AerobaticElytraWingItem getWingItem(ItemStack elytra, ElytraDyement.WingSide side) {
        return AerobaticElytraItems.AEROBATIC_ELYTRA_WING;
    }

    public ItemStack getWing(ItemStack elytra, ElytraDyement.WingSide side) {
        CompoundTag elytraCaps = ForgeUtil.getSerializedCaps((ItemStack)elytra);
        ItemStack wing = new ItemStack((ItemLike)this.getWingItem(elytra, side), 1, elytraCaps.m_6426_());
        new NBTPath("Parent.aerobaticelytra:spec.Trail").delete((Tag)elytraCaps);
        this.dyement.read(elytra);
        this.dyement.getWing(side).write(wing, null);
        CompoundTag elytraTag = elytra.m_41784_().m_6426_();
        elytraTag.m_128473_("BlockEntityTag");
        elytraTag.m_128473_("WingInfo");
        CompoundTag wingTag = wing.m_41784_();
        wingTag.m_128365_("SplitElytra", (Tag)elytraTag);
        wingTag.m_128365_("SplitElytraCaps", (Tag)elytraCaps);
        if (elytraTag.m_128425_("Enchantments", 9)) {
            wingTag.m_128365_("Enchantments", (Tag)elytraTag.m_128437_("Enchantments", 10));
        }
        ElytraSpecCapability.getElytraSpecOrDefault(wing).getTrailData().keep(side);
        return wing;
    }
}

