/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight.mode;

import endorh.aerobaticelytra.client.render.model.IElytraPose;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface IFlightMode {
    public boolean shouldCycle();

    public boolean is(ResourceLocation var1);

    default public boolean canBeUsedBy(Player player) {
        return true;
    }

    default public int getRegistryOrder() {
        return 0;
    }

    public BiPredicate<Player, Vec3> getFlightHandler();

    @Nullable
    default public BiConsumer<Player, Vec3> getNonFlightHandler() {
        return null;
    }

    @Nullable
    default public Consumer<Player> getRemoteFlightHandler() {
        return null;
    }

    @Nullable
    default public Consumer<Player> getRemoteNonFlightHandler() {
        return null;
    }

    public ResourceLocation getToastIconLocation();

    public int getToastIconU();

    public int getToastIconV();

    default public boolean canChangeTo(IFlightMode other) {
        return true;
    }

    default public IFlightMode next() {
        return this.next(IFlightMode::shouldCycle, 1);
    }

    default public IFlightMode prev() {
        return this.next(IFlightMode::shouldCycle, -1);
    }

    default public IFlightMode next(Predicate<IFlightMode> predicate) {
        return this.next(predicate, 1);
    }

    default public IFlightMode next(Predicate<IFlightMode> predicate, int step) {
        int l = AerobaticElytraRegistries.FLIGHT_MODE_LIST.size();
        int o = AerobaticElytraRegistries.FLIGHT_MODE_LIST.indexOf(this);
        for (int i = 0; i < l; ++i) {
            IFlightMode mode = AerobaticElytraRegistries.FLIGHT_MODE_LIST.get((o + (i + 1) * step + l) % l);
            if (!predicate.test(mode)) continue;
            return mode;
        }
        return this;
    }

    default public void write(FriendlyByteBuf buf) {
        buf.m_130085_(Objects.requireNonNull(AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.getKey((Object)this), "Unregistered flight mode " + this));
    }

    public static IFlightMode read(FriendlyByteBuf buf) {
        ResourceLocation regName = buf.m_130281_();
        if (!AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.containsKey(regName)) {
            throw new IllegalArgumentException("Invalid FlightMode registry name in packet: '" + regName + "'");
        }
        return (IFlightMode)AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.getValue(regName);
    }

    @Nullable
    default public IElytraPose getElytraPose(Player player) {
        return null;
    }
}

