/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight.mode;

import endorh.aerobaticelytra.client.AerobaticElytraResources;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import endorh.aerobaticelytra.common.flight.ElytraFlight;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public enum FlightModes implements IFlightMode
{
    ELYTRA_FLIGHT(() -> Config.aerobatic.modes.enable_normal_elytra_mode, -4000, 100, 0, ElytraFlight::onElytraTravel, null, null, null, FlightModeTags.ELYTRA),
    AEROBATIC_FLIGHT(() -> true, -3000, 132, 0, AerobaticFlight::onAerobaticTravel, AerobaticFlight::onOtherModeTravel, AerobaticFlight::onRemoteFlightTravel, AerobaticFlight::onRemoteOtherModeTravel, FlightModeTags.ELYTRA, FlightModeTags.AEROBATIC);

    private final Supplier<Boolean> shouldCycle;
    private final int order;
    private final int u;
    private final int v;
    private final Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    private final BiPredicate<Player, Vec3> flightHandler;
    private final BiConsumer<Player, Vec3> nonFlightHandler;
    private final Consumer<Player> remoteFlightHandler;
    private final Consumer<Player> remoteNonFlightHandler;

    private FlightModes(Supplier<Boolean> shouldCycle, int order, int u, @Nullable int v, @Nullable BiPredicate<Player, Vec3> flightHandler, @Nullable BiConsumer<Player, Vec3> nonFlightHandler, Consumer<Player> remoteFlightHandler, Consumer<Player> remoteNonFlightHandler, ResourceLocation ... tags) {
        this.shouldCycle = shouldCycle;
        this.order = order;
        this.flightHandler = flightHandler;
        this.nonFlightHandler = nonFlightHandler;
        this.remoteFlightHandler = remoteFlightHandler;
        this.remoteNonFlightHandler = remoteNonFlightHandler;
        this.u = u;
        this.v = v;
        Collections.addAll(this.tags, tags);
    }

    @Override
    public boolean shouldCycle() {
        return this.shouldCycle.get();
    }

    @Override
    public boolean is(ResourceLocation tag) {
        return this.tags.contains(tag);
    }

    @Override
    public int getRegistryOrder() {
        return this.order;
    }

    @Override
    public BiPredicate<Player, Vec3> getFlightHandler() {
        return this.flightHandler;
    }

    @Override
    @Nullable
    public BiConsumer<Player, Vec3> getNonFlightHandler() {
        return this.nonFlightHandler;
    }

    @Override
    @Nullable
    public Consumer<Player> getRemoteFlightHandler() {
        return this.remoteFlightHandler;
    }

    @Override
    @Nullable
    public Consumer<Player> getRemoteNonFlightHandler() {
        return this.remoteNonFlightHandler;
    }

    @Override
    public ResourceLocation getToastIconLocation() {
        return AerobaticElytraResources.FLIGHT_GUI_ICONS_LOCATION;
    }

    @Override
    public int getToastIconU() {
        return this.u;
    }

    @Override
    public int getToastIconV() {
        return this.v;
    }

    @Override
    public boolean canChangeTo(IFlightMode other) {
        return Config.aerobatic.modes.allow_midair_change;
    }
}

