/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.network.WeatherPackets;
import endorh.lazulib.math.Vec3f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class WeatherData {
    protected static final Queue<ChunkUpdateTask> CHUNK_UPDATE_TASKS = new ConcurrentLinkedQueue<ChunkUpdateTask>();
    public static final Map<Level, Map<Pair<Long, Long>, WeatherRegion>> weatherRegions = Collections.synchronizedMap(new HashMap());
    public static final Map<WeatherRegion, WindRegion> windRegions = Collections.synchronizedMap(new HashMap());
    public static final PacketDistributor<WeatherRegion> TRACKING_WEATHER_REGION = new PacketDistributor((dist, regionSupplier) -> arg_0 -> WeatherData.lambda$static$1((Supplier)regionSupplier, arg_0), NetworkDirection.PLAY_TO_CLIENT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        Level world;
        WeatherRegion.handleChunkTasks();
        if (event.side.isServer() && weatherRegions.containsKey(world = event.level)) {
            Map<Pair<Long, Long>, WeatherRegion> worldRegions;
            Map<Pair<Long, Long>, WeatherRegion> map = worldRegions = weatherRegions.get(world);
            synchronized (map) {
                for (WeatherRegion region : worldRegions.values()) {
                    region.tick();
                }
            }
        }
    }

    public static float getBiomePrecipitationStrength(Player player) {
        return switch (((Biome)player.m_9236_().m_204166_(player.m_20183_()).m_203334_()).m_264600_(player.m_20183_())) {
            default -> throw new IncompatibleClassChangeError();
            case Biome.Precipitation.NONE -> 0.0f;
            case Biome.Precipitation.SNOW -> 1.2f;
            case Biome.Precipitation.RAIN -> 1.0f;
        };
    }

    public static Vec3f getWindVector(Player player) {
        return Vec3f.average((Collection)WindRegion.of(player).stream().map(WindRegion::getWind).collect(Collectors.toSet()));
    }

    public static Vec3f getAngularWindVector(Player player) {
        return Vec3f.average((Collection)WindRegion.of(player).stream().map(WindRegion::getAngularWind).collect(Collectors.toSet()));
    }

    private static /* synthetic */ void lambda$static$1(Supplier regionSupplier, Packet p) {
        ((WeatherRegion)regionSupplier.get()).affectedPlayers().forEach(pl -> pl.f_8906_.f_9742_.m_129512_(p));
    }

    @Mod.EventBusSubscriber(modid="aerobaticelytra")
    public static class WeatherRegion {
        public static final int DIAMETER_SHIFT = 8;
        public static final long RADIUS = 128L;
        public static final long DIAMETER = 256L;
        public static final long BORDER = 32L;
        public static final int TEMP_TICKET_TICKS = 80;
        public final long x;
        public final long z;
        public final double centerX;
        public final double centerZ;
        public final Level world;
        private int tempTicket = 0;
        private final long[] chunks = new long[]{0L, 0L, 0L, 0L};

        private WeatherRegion(Level world, long x, long z) {
            this.world = world;
            this.x = x;
            this.z = z;
            this.centerX = (x << 8) + 128L;
            this.centerZ = (z << 8) + 128L;
        }

        public static long scale(double c) {
            return (long)c >> 8;
        }

        public static int mod(long c) {
            return (int)(c - (WeatherRegion.scale(c) << 8));
        }

        public static Set<WeatherRegion> of(Player player) {
            return WeatherRegion.of(player.m_9236_(), player.m_20185_(), player.m_20189_());
        }

        public static Set<WeatherRegion> of(Level world, double x, double z) {
            long dX = WeatherRegion.scale(x);
            long dZ = WeatherRegion.scale(z);
            double rX = x - (double)(dX << 8);
            double rZ = z - (double)(dZ << 8);
            HashSet<WeatherRegion> adj = new HashSet<WeatherRegion>();
            adj.add(WeatherRegion.of(world, dX, dZ));
            if (rX < 32.0) {
                adj.add(WeatherRegion.of(world, dX - 1L, dZ));
                if (rZ < 32.0) {
                    adj.add(WeatherRegion.of(world, dX, dZ - 1L));
                    adj.add(WeatherRegion.of(world, dX - 1L, dZ - 1L));
                } else if (256.0 - rZ < 32.0) {
                    adj.add(WeatherRegion.of(world, dX, dZ + 1L));
                    adj.add(WeatherRegion.of(world, dX - 1L, dZ + 1L));
                }
            } else if (256.0 - rX < 32.0) {
                adj.add(WeatherRegion.of(world, dX + 1L, dZ));
                if (rZ < 32.0) {
                    adj.add(WeatherRegion.of(world, dX, dZ - 1L));
                    adj.add(WeatherRegion.of(world, dX + 1L, dZ - 1L));
                } else if (256.0 - rZ < 32.0) {
                    adj.add(WeatherRegion.of(world, dX, dZ + 1L));
                    adj.add(WeatherRegion.of(world, dX + 1L, dZ + 1L));
                }
            } else if (rZ < 32.0) {
                adj.add(WeatherRegion.of(world, dX, dZ - 1L));
            } else if (256.0 - rZ < 32.0) {
                adj.add(WeatherRegion.of(world, dX, dZ + 1L));
            }
            return adj;
        }

        public static WeatherRegion of(Level world, long x, long z) {
            Pair xz = Pair.of((Object)x, (Object)z);
            if (weatherRegions.containsKey(world)) {
                if (weatherRegions.get(world).containsKey(xz)) {
                    return weatherRegions.get(world).get(xz);
                }
                WeatherRegion reg = new WeatherRegion(world, x, z);
                reg.tempTicket = 80;
                weatherRegions.get(world).put((Pair<Long, Long>)xz, reg);
                return reg;
            }
            weatherRegions.put(world, Collections.synchronizedMap(new HashMap()));
            WeatherRegion reg = new WeatherRegion(world, x, z);
            reg.tempTicket = 80;
            weatherRegions.get(world).put((Pair<Long, Long>)xz, reg);
            return reg;
        }

        public static WeatherRegion of(ChunkUpdateTask task) {
            long x = WeatherRegion.scale(task.x);
            long z = WeatherRegion.scale(task.z);
            Pair xz = Pair.of((Object)x, (Object)z);
            if (weatherRegions.containsKey(task.world)) {
                Map<Pair<Long, Long>, WeatherRegion> worldRegions = weatherRegions.get(task.world);
                if (worldRegions.containsKey(xz)) {
                    return worldRegions.get(xz);
                }
                WeatherRegion reg = new WeatherRegion(task.world, x, z);
                worldRegions.put((Pair<Long, Long>)xz, reg);
                return reg;
            }
            weatherRegions.put(task.world, Collections.synchronizedMap(new HashMap()));
            WeatherRegion reg = new WeatherRegion(task.world, x, z);
            weatherRegions.get(task.world).put((Pair<Long, Long>)xz, reg);
            return reg;
        }

        public static void handleChunkTasks() {
            ChunkUpdateTask task = CHUNK_UPDATE_TASKS.poll();
            while (task != null) {
                WeatherRegion.onChunkTask(task);
                task = CHUNK_UPDATE_TASKS.poll();
            }
        }

        public static void onChunkTask(ChunkUpdateTask task) {
            WeatherRegion.of(task).chunkUpdate(task);
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            if (!(event.getLevel() instanceof Level)) {
                return;
            }
            CHUNK_UPDATE_TASKS.add(ChunkUpdateTask.load(event.getChunk()));
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            if (!(event.getLevel() instanceof Level)) {
                return;
            }
            CHUNK_UPDATE_TASKS.add(ChunkUpdateTask.unload(event.getChunk()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onWorldUnload(LevelEvent.Unload event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof Level)) {
                return;
            }
            Level world = (Level)levelAccessor;
            if (weatherRegions.containsKey(world)) {
                Map<Pair<Long, Long>, WeatherRegion> worldRegions = weatherRegions.get(world);
                weatherRegions.remove(world);
                Map<Pair<Long, Long>, WeatherRegion> map = worldRegions;
                synchronized (map) {
                    for (WeatherRegion region : worldRegions.values()) {
                        windRegions.remove(region);
                    }
                }
            }
        }

        private void chunkUpdate(ChunkUpdateTask task) {
            this.tempTicket = 0;
            int rX = (int)((long)task.x - (WeatherRegion.scale(task.x) << 8));
            int rZ = (int)((long)task.z - (WeatherRegion.scale(task.z) << 8));
            int i = (rX >> 4 << 4) + (rZ >> 4);
            int p = i >> 6;
            int r = i & 0x3F;
            if (task.unload) {
                int n = p;
                this.chunks[n] = this.chunks[n] & (1L << r ^ 0xFFFFFFFFFFFFFFFFL);
                if ((this.chunks[0] | this.chunks[1] | this.chunks[2] | this.chunks[3]) == 0L) {
                    this.unload();
                }
            } else {
                int n = p;
                this.chunks[n] = this.chunks[n] | 1L << r;
            }
        }

        private void unload() {
            weatherRegions.get(this.world).remove(Pair.of((Object)this.x, (Object)this.z));
            windRegions.remove(this);
            if (weatherRegions.get(this.world).isEmpty()) {
                weatherRegions.remove(this.world);
            }
        }

        public boolean contains(Player player) {
            if (player.m_9236_() != this.world) {
                return false;
            }
            return this.containsNoWorldCheck(player);
        }

        public boolean containsNoWorldCheck(Player player) {
            return this.contains(player.m_20185_(), player.m_20189_());
        }

        public boolean affects(Player player) {
            if (this.world != player.m_9236_()) {
                return false;
            }
            return this.affectsNoWorldCheck(player);
        }

        public boolean affectsNoWorldCheck(Player player) {
            return EntitySelector.f_20408_.test(player) && Math.abs(player.m_20185_() - this.centerX) < 160.0 && Math.abs(player.m_20189_() - this.centerZ) < 160.0;
        }

        public boolean contains(double x, double z) {
            return this.contains(WeatherRegion.scale(x), WeatherRegion.scale(z));
        }

        public boolean contains(long x, long z) {
            return x == this.x && z == this.z;
        }

        public Set<? extends Player> affectedPlayers() {
            return this.world.m_6907_().stream().filter(this::affectsNoWorldCheck).collect(Collectors.toSet());
        }

        public void tick() {
            WindRegion.of(this).tick();
            if (this.tempTicket != 0) {
                --this.tempTicket;
                if (this.tempTicket == 0 && (this.chunks[0] | this.chunks[1] | this.chunks[2] | this.chunks[3]) == 0L) {
                    this.unload();
                }
            }
        }

        public String toString() {
            int chunkCount = Long.bitCount(this.chunks[0]) + Long.bitCount(this.chunks[1]) + Long.bitCount(this.chunks[2]) + Long.bitCount(this.chunks[3]);
            return String.format("<Region: \u27e8%+4d, %+4d\u27e9\u2192\u27e8%+6d, %+6d\u27e9, %s>", this.x, this.z, (long)this.centerX, (long)this.centerZ, (chunkCount > 0 ? String.format("chunks: %3d, ", chunkCount) : "") + (this.tempTicket > 0 ? String.format("temp: %3d, ", this.tempTicket) : "") + String.format("affects: %2d", this.affectedPlayers().size()));
        }
    }

    public static class WindRegion {
        protected static final Random RANDOM = new Random();
        public final WeatherRegion region;
        public final Vec3f wind = (Vec3f)Vec3f.ZERO.get();
        public final Vec3f angularWind = (Vec3f)Vec3f.ZERO.get();
        private static final Vec3f angularWindDelta = (Vec3f)Vec3f.ZERO.get();
        private static final Vec3f orthogonal = (Vec3f)Vec3f.ZERO.get();
        private static final Vec3f last = (Vec3f)Vec3f.ZERO.get();

        private WindRegion(WeatherRegion region) {
            this.region = region;
        }

        public static Set<WindRegion> of(Player player) {
            return WindRegion.of(player.m_9236_(), player.m_20185_(), player.m_20189_());
        }

        public static Set<WindRegion> of(Level world, double x, double z) {
            return WeatherRegion.of(world, x, z).stream().map(WindRegion::of).collect(Collectors.toSet());
        }

        public static WindRegion of(Level world, long x, long z) {
            return WindRegion.of(WeatherRegion.of(world, x, z));
        }

        public static WindRegion of(WeatherRegion region) {
            if (windRegions.containsKey(region)) {
                return windRegions.get(region);
            }
            WindRegion node = new WindRegion(region);
            windRegions.put(region, node);
            return node;
        }

        public Vec3f getWind() {
            return this.wind;
        }

        public Vec3f getAngularWind() {
            return this.angularWind;
        }

        protected void tick() {
            if (!Config.weather.enabled) {
                return;
            }
            float rain2 = this.region.world.m_46722_(1.0f);
            float storm2 = this.region.world.m_46661_(1.0f);
            if (rain2 > 0.0f || !this.wind.isZero(1.0E-5)) {
                float wind_randomness = Config.weather.rain.wind_randomness_tick * rain2 * Config.weather.rain.wind_strength_tick + Config.weather.storm.wind_randomness_tick * storm2 * Config.weather.storm.wind_strength_tick;
                if (wind_randomness > 0.0f) {
                    float strength = rain2 * Config.weather.rain.wind_strength_tick + storm2 * Config.weather.storm.wind_strength_tick;
                    float delta = rain2 * Config.weather.rain.wind_randomness_tick + storm2 * Config.weather.storm.wind_randomness_tick;
                    last.set(this.wind);
                    if (this.wind.isZero(1.0E-5)) {
                        this.wind.set(1.0f, 0.0f, 0.0f);
                    }
                    this.wind.unitary();
                    this.wind.mul(strength * (RANDOM.nextFloat() * 0.4f + 0.8f));
                    orthogonal.setOrthogonalUnitary(this.wind);
                    this.wind.rotateAlongVecDegrees(orthogonal, (RANDOM.nextFloat() - 0.5f) * 2.0f * delta);
                    this.wind.lerp(last, 0.6f);
                    angularWindDelta.setRandom(Config.weather.rain.wind_randomness_tick * rain2 * Config.weather.rain.wind_angular_strength_tick + Config.weather.storm.wind_randomness_tick * storm2 * Config.weather.storm.wind_angular_strength_tick);
                    this.angularWind.add(angularWindDelta);
                    this.angularWind.clamp(rain2 * Config.weather.rain.wind_angular_strength_tick + storm2 * Config.weather.storm.wind_angular_strength_tick);
                }
                new WeatherPackets.SWindNodePacket(this).sendTracking();
            }
        }

        public void update(WeatherPackets.SWindNodePacket packet) {
            this.wind.set(packet.wind);
            this.angularWind.set(packet.angularWind);
        }

        public String toString() {
            return String.format("<WeatherNode at %s: %s, %s>", this.region, this.wind, this.angularWind);
        }
    }

    protected static class ChunkUpdateTask {
        protected final Level world;
        protected final int x;
        protected final int z;
        protected final boolean unload;

        private ChunkUpdateTask(ChunkAccess chunk, boolean unload) {
            this.world = (Level)chunk.getWorldForge();
            this.x = chunk.m_7697_().m_45604_();
            this.z = chunk.m_7697_().m_45605_();
            this.unload = unload;
        }

        protected static ChunkUpdateTask load(ChunkAccess chunk) {
            return new ChunkUpdateTask(chunk, false);
        }

        protected static ChunkUpdateTask unload(ChunkAccess chunk) {
            return new ChunkUpdateTask(chunk, true);
        }
    }
}

