/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.lazulib.math.Vec3d;
import endorh.lazulib.math.Vec3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VectorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Vec3f tempVec = (Vec3f)Vec3f.ZERO.get();
    private static final VectorBase temp = new VectorBase();
    public final Vec3f look = (Vec3f)Vec3f.ZERO.get();
    public final Vec3f roll = (Vec3f)Vec3f.ZERO.get();
    public final Vec3f normal = (Vec3f)Vec3f.ZERO.get();
    public boolean valid = true;

    public void init(IAerobaticData data) {
        this.update(data.getRotationYaw(), data.getRotationPitch(), data.getRotationRoll());
        this.valid = true;
    }

    public void update(float yawDeg, float pitchDeg, float rollDeg) {
        this.look.set(yawDeg, pitchDeg, true);
        this.roll.set(yawDeg + 90.0f, 0.0f, true);
        this.roll.rotateAlongOrtVecDegrees(this.look, rollDeg);
        this.normal.set(this.roll);
        this.normal.cross(this.look);
    }

    public float[] toSpherical(float prevYaw) {
        float newRoll;
        float newYaw;
        float newPitch = this.look.getPitch();
        if (Math.abs(newPitch) <= 89.9f) {
            newYaw = this.look.getYaw();
            tempVec.set(newYaw + 90.0f, 0.0f, true);
            newRoll = tempVec.angleUnitaryDegrees(this.roll, this.look);
        } else {
            newYaw = newPitch > 0.0f ? this.normal.getYaw() : (this.normal.getYaw() + 180.0f) % 360.0f;
            newRoll = 0.0f;
        }
        newYaw += (float)Mth.m_14143_((float)(prevYaw / 360.0f)) * 360.0f;
        if (newYaw - prevYaw > 180.0f) {
            newYaw -= 360.0f;
        }
        if (newYaw - prevYaw <= -180.0f) {
            newYaw += 360.0f;
        }
        if (Float.isNaN(newYaw) || Float.isNaN(newPitch) || Float.isNaN(newRoll)) {
            LOGGER.error("Error translating spherical coordinates");
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return new float[]{newYaw, newPitch, newRoll};
    }

    public void interpolate(float t, VectorBase pre, VectorBase pos, VectorBase target) {
        this.set(pre);
        Vec3f axis = this.look.copy();
        axis.cross(pos.look);
        if (axis.isZero()) {
            axis.set(this.normal);
        } else {
            axis.unitary();
        }
        float lookAngle = this.look.angleUnitary(pos.look, axis);
        tempVec.set(this.roll);
        tempVec.rotateAlongVec(axis, lookAngle);
        tempVec.unitary();
        float rollAngle = tempVec.angleUnitary(pos.roll, pos.look);
        if (rollAngle > (float)Math.PI) {
            rollAngle -= (float)Math.PI * 2;
        }
        this.look.rotateAlongOrtVec(axis, lookAngle * t);
        this.normal.rotateAlongVec(axis, lookAngle * t);
        this.roll.rotateAlongVec(axis, lookAngle * t);
        this.roll.rotateAlongOrtVec(this.look, rollAngle * t);
        this.normal.rotateAlongOrtVec(this.look, rollAngle * t);
        this.rotate(pos.angles(target));
        this.look.unitary();
        this.roll.unitary();
        this.normal.unitary();
    }

    public float[] angles(VectorBase other) {
        temp.set(this);
        float pitch = VectorBase.temp.look.angleProjectedDegrees(other.look, VectorBase.temp.roll);
        VectorBase.temp.look.rotateAlongOrtVecDegrees(VectorBase.temp.roll, pitch);
        VectorBase.temp.normal.rotateAlongOrtVecDegrees(VectorBase.temp.roll, pitch);
        float yaw = VectorBase.temp.look.angleProjectedDegrees(other.look, VectorBase.temp.normal);
        VectorBase.temp.look.rotateAlongOrtVecDegrees(VectorBase.temp.normal, yaw);
        VectorBase.temp.roll.rotateAlongOrtVecDegrees(VectorBase.temp.normal, yaw);
        float roll = VectorBase.temp.roll.angleProjectedDegrees(other.roll, VectorBase.temp.look);
        return new float[]{pitch, yaw, roll};
    }

    public void rotate(float[] angles) {
        this.rotate(angles[0], angles[1], angles[2]);
    }

    public void rotate(float pitch, float yaw, float roll) {
        this.look.rotateAlongOrtVecDegrees(this.roll, pitch);
        this.normal.rotateAlongOrtVecDegrees(this.roll, pitch);
        this.look.rotateAlongOrtVecDegrees(this.normal, yaw);
        this.roll.rotateAlongOrtVecDegrees(this.normal, yaw);
        this.roll.rotateAlongOrtVecDegrees(this.look, roll);
        this.normal.rotateAlongOrtVecDegrees(this.look, roll);
        this.look.unitary();
        this.normal.unitary();
        this.roll.unitary();
    }

    public void mirror(Vec3f axis) {
        Vec3f ax = axis.copy();
        float angle = ax.angleUnitary(this.look);
        float mul = -2.0f;
        if (angle > 1.5707964f) {
            angle = (float)Math.PI - angle;
            mul = 2.0f;
        }
        if (angle < 0.001f) {
            ax = this.normal;
        } else {
            ax.cross(this.look);
            ax.unitary();
        }
        angle = (float)Math.PI + mul * angle;
        this.look.rotateAlongVec(ax, angle);
        this.roll.rotateAlongVec(ax, angle);
        this.normal.rotateAlongVec(ax, angle);
    }

    public void tilt(float yaw, float pitch, float rollDeg) {
        this.look.rotateAlongOrtVecDegrees(this.normal, yaw);
        this.roll.rotateAlongOrtVecDegrees(this.normal, yaw);
        this.look.rotateAlongOrtVecDegrees(this.roll, -pitch);
        this.normal.rotateAlongOrtVecDegrees(this.roll, -pitch);
        this.roll.rotateAlongOrtVecDegrees(this.look, rollDeg);
        this.normal.rotateAlongOrtVecDegrees(this.look, rollDeg);
    }

    public void offset(Vec3d leftRocket, Vec3d rightRocket, Vec3d leftCenterRocket, Vec3d rightCenterRocket) {
        this.look.mul(1.6f);
        this.normal.mul(0.4f);
        this.roll.mul(0.7f);
        leftRocket.add(this.look);
        leftRocket.add(this.normal);
        rightRocket.set(leftRocket);
        leftCenterRocket.set(leftRocket);
        rightCenterRocket.set(rightRocket);
        leftRocket.sub(this.roll);
        rightRocket.add(this.roll);
        this.roll.mul(0.14285715f);
        leftCenterRocket.sub(this.roll);
        rightCenterRocket.add(this.roll);
        this.look.unitary();
        this.normal.unitary();
        this.roll.unitary();
    }

    public void applyLookAround(float lookYaw, float lookPitch) {
        this.look.rotateAlongOrtVecDegrees(this.normal, lookYaw);
        this.roll.rotateAlongOrtVecDegrees(this.normal, lookYaw);
        this.look.rotateAlongOrtVecDegrees(this.roll, -lookPitch);
        this.normal.rotateAlongOrtVecDegrees(this.roll, -lookPitch);
        this.look.unitary();
        this.normal.unitary();
        this.roll.unitary();
    }

    public float[] distance(VectorBase base) {
        float roll;
        float yaw;
        float pitch;
        Vec3f compare = base.look.copy();
        Vec3f axis = this.roll.copy();
        axis.mul(axis.dot(compare));
        compare.sub(axis);
        if (compare.isZero()) {
            pitch = 0.0f;
        } else {
            compare.unitary();
            pitch = this.look.angleUnitaryDegrees(compare);
        }
        compare.set(base.look);
        axis.set(this.normal);
        axis.mul(axis.dot(compare));
        compare.sub(axis);
        if (compare.isZero()) {
            yaw = 0.0f;
        } else {
            compare.unitary();
            yaw = this.look.angleUnitaryDegrees(compare);
        }
        compare.set(base.roll);
        axis.set(this.look);
        axis.mul(axis.dot(compare));
        compare.sub(axis);
        if (compare.isZero()) {
            roll = 0.0f;
        } else {
            compare.unitary();
            roll = this.roll.angleUnitaryDegrees(compare);
        }
        return new float[]{yaw, pitch, roll};
    }

    public void set(VectorBase base) {
        this.look.set(base.look);
        this.roll.set(base.roll);
        this.normal.set(base.normal);
    }

    public void write(FriendlyByteBuf buf) {
        this.look.write(buf);
        this.roll.write(buf);
        this.normal.write(buf);
    }

    public static VectorBase read(FriendlyByteBuf buf) {
        VectorBase base = new VectorBase();
        base.look.set(Vec3f.read((FriendlyByteBuf)buf));
        base.roll.set(Vec3f.read((FriendlyByteBuf)buf));
        base.normal.set(Vec3f.read((FriendlyByteBuf)buf));
        return base;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Look", (Tag)this.look.toNBT());
        nbt.m_128365_("Roll", (Tag)this.roll.toNBT());
        nbt.m_128365_("Normal", (Tag)this.normal.toNBT());
        return nbt;
    }

    public static VectorBase fromNBT(CompoundTag nbt) {
        VectorBase base = new VectorBase();
        base.readNBT(nbt);
        return base;
    }

    public void readNBT(CompoundTag nbt) {
        this.look.readNBT(nbt.m_128469_("Look"));
        this.roll.readNBT(nbt.m_128469_("Roll"));
        this.normal.readNBT(nbt.m_128469_("Normal"));
    }

    public String toString() {
        return String.format("[ %s\n  %s\n  %s ]", this.look, this.roll, this.normal);
    }
}

