/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.common.LogUtil;
import endorh.lazulib.common.ObfuscationReflectionUtil;
import endorh.lazulib.events.PlayerTravelEvent;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class TravelHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final AttributeModifier SLOW_FALLING = (AttributeModifier)ObfuscationReflectionUtil.getStaticFieldValueOrLog(LivingEntity.class, (String)"SLOW_FALLING", (String)"SLOW_FALLING", arg_0 -> ((Logger)LOGGER).error(arg_0), (String)"Slow falling effect may not interact properly with aerobatic elytras");
    public static final ObfuscationReflectionUtil.SoftField<ServerGamePacketListenerImpl, Integer> ServerGamePacketListener$aboveGroundTickCount = ObfuscationReflectionUtil.getSoftField(ServerGamePacketListenerImpl.class, (String)"f_9737_", (String)"floatingTickCount", (Consumer)LogUtil.oneTimeLogger(arg_0 -> ((Logger)LOGGER).error(arg_0)), (String)"Some flight modes may kick players for flying", (String)"A flight mode tried to prevent a player from being kicked for flying, but reflection failed.");

    @SubscribeEvent
    public static void onPlayerEntityTravelEvent(PlayerTravelEvent event) {
        Player player = event.player;
        FlightDataCapability.getFlightData(player).ifPresent(fd -> {
            IFlightMode mode = fd.getFlightMode();
            boolean cancel = mode.getFlightHandler().test(player, event.travelVector);
            for (IFlightMode m : AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY) {
                BiConsumer<Player, Vec3> handler;
                if (mode == m || (handler = m.getNonFlightHandler()) == null) continue;
                handler.accept(player, event.travelVector);
            }
            event.setCanceled(cancel);
        });
    }

    @SubscribeEvent
    public static void onRemotePlayerEntityTravelEvent(PlayerTravelEvent.RemotePlayerTravelEvent event) {
        Player player = event.player;
        FlightDataCapability.getFlightData(player).ifPresent(fd -> {
            IFlightMode mode = fd.getFlightMode();
            Consumer<Player> flightHandler = mode.getRemoteFlightHandler();
            if (flightHandler != null) {
                flightHandler.accept(player);
            }
            for (IFlightMode m : AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY) {
                Consumer<Player> handler;
                if (mode == m || (handler = m.getRemoteNonFlightHandler()) == null) continue;
                handler.accept(player);
            }
        });
    }

    public static double travelGravity(Player player) {
        boolean flag;
        double grav = 0.08;
        AttributeInstance gravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        boolean bl = flag = player.m_20184_().f_82480_ <= 0.0;
        if (SLOW_FALLING != null) {
            assert (gravity != null);
            if (flag && player.m_21023_(MobEffects.f_19591_)) {
                if (!gravity.m_22109_(SLOW_FALLING)) {
                    gravity.m_22118_(SLOW_FALLING);
                }
                player.f_19789_ = 0.0f;
            } else if (gravity.m_22109_(SLOW_FALLING)) {
                gravity.m_22130_(SLOW_FALLING);
            }
            grav = gravity.m_22135_();
        } else if (flag && player.m_21023_(MobEffects.f_19591_)) {
            grav = 0.01f;
            player.f_19789_ = 0.0f;
        }
        return grav;
    }

    public static boolean resetFloatingTickCount(ServerPlayer player) {
        return ServerGamePacketListener$aboveGroundTickCount.set((Object)player.f_8906_, (Object)0);
    }
}

