/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.flight.TravelHandler;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.lazulib.math.Vec3f;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ElytraFlight {
    public static boolean onElytraTravel(Player player, Vec3 travelVector) {
        double hSpeedNew;
        double reaction;
        float collisionStrength;
        if (!player.m_21255_() || player.m_150110_().f_35935_ || !FlightDataCapability.getFlightDataOrDefault(player).getFlightMode().is(FlightModeTags.ELYTRA)) {
            return false;
        }
        ItemStack elytra = AerobaticElytraLogic.getAerobaticElytra((LivingEntity)player);
        if (elytra.m_41619_()) {
            return false;
        }
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        if ((elytra.m_41773_() >= elytra.m_41776_() - 1 || !(spec.getAbility(IAbility.Ability.FUEL) > 0.0f)) && !player.m_7500_() || player.m_20077_() || player.m_20069_()) {
            return false;
        }
        double prevX = player.m_20185_();
        double prevY = player.m_20186_();
        double prevZ = player.m_20189_();
        double grav = TravelHandler.travelGravity(player);
        Vec3 delta = player.m_20184_();
        double hSpeedPrev = new Vec3f(delta).hNorm();
        if (delta.f_82480_ > -0.5) {
            player.f_19789_ = 1.0f;
        }
        Vec3 look = player.m_20154_();
        float pitchRad = player.m_146909_() * (float)Math.PI / 180.0f;
        double look_h_norm = look.m_165924_();
        double delta_h_norm = delta.m_165924_();
        double look_norm = look.m_82553_();
        float pitchCos = Mth.m_14089_((float)pitchRad);
        pitchCos = pitchCos * pitchCos * Math.min(1.0f, (float)look_norm / 0.4f);
        delta = player.m_20184_().m_82520_(0.0, grav * (-1.0 + (double)pitchCos * 0.75), 0.0);
        if (delta.f_82480_ < 0.0 && look_h_norm > 0.0) {
            double y_friction = delta.f_82480_ * -0.1 * (double)pitchCos;
            delta = delta.m_82520_(look.f_82479_ * y_friction / look_h_norm, y_friction, look.f_82481_ * y_friction / look_h_norm);
        }
        if (pitchRad < 0.0f && look_h_norm > 0.0) {
            double y_acc = delta_h_norm * (double)(-Mth.m_14031_((float)pitchRad)) * 0.04;
            delta = delta.m_82520_(-look.f_82479_ * y_acc / look_h_norm, y_acc * 3.2, -look.f_82481_ * y_acc / look_h_norm);
        }
        if (look_h_norm > 0.0) {
            delta = delta.m_82520_((look.f_82479_ / look_h_norm * delta_h_norm - delta.f_82479_) * 0.1, 0.0, (look.f_82481_ / look_h_norm * delta_h_norm - delta.f_82481_) * 0.1);
        }
        player.m_20256_(delta.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
        player.m_6478_(MoverType.SELF, player.m_20184_());
        if (player.f_19862_ && !player.m_9236_().f_46443_ && (collisionStrength = (float)((reaction = hSpeedPrev - (hSpeedNew = (double)new Vec3f(player.m_20184_()).hNorm())) * 10.0 - 3.0)) > 0.0f) {
            player.m_5496_(collisionStrength > 4.0f ? SoundEvents.f_12319_ : SoundEvents.f_12276_, 1.0f, 1.0f);
            player.m_6469_(player.m_269291_().m_269515_(), collisionStrength);
        }
        if (player.m_20096_() && player.m_21515_()) {
            player.m_36321_();
        }
        player.m_267651_(player instanceof FlyingAnimal);
        player.m_36378_(player.m_20185_() - prevX, player.m_20186_() - prevY, player.m_20189_() - prevZ);
        return true;
    }
}

