/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.client.sound.AerobaticElytraSound;
import endorh.aerobaticelytra.client.sound.AerobaticSounds;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.event.AerobaticElytraFinishFlightEvent;
import endorh.aerobaticelytra.common.event.AerobaticElytraStartFlightEvent;
import endorh.aerobaticelytra.common.event.AerobaticElytraTickEvent;
import endorh.aerobaticelytra.common.flight.AerobaticCollision;
import endorh.aerobaticelytra.common.flight.FlightStats;
import endorh.aerobaticelytra.common.flight.TravelHandler;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.aerobaticelytra.common.flight.WeatherData;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.debug.Debug;
import endorh.aerobaticelytra.network.AerobaticPackets;
import endorh.lazulib.animation.Easing;
import endorh.lazulib.math.Vec3f;
import endorh.lazulib.text.TextUtil;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class AerobaticFlight {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean remoteLookingAround;
    private static final Vec3f ZERO;
    private static final Vec3f prevMotionVec;
    private static final Vec3f motionVec;
    private static final Vec3f gravAccVec;
    private static final Vec3f rainAcc;
    private static final Vec3f propAccVec;
    private static final Vec3f glideAccVec;
    private static final Vec3f angularWindVec;

    public static boolean onAerobaticTravel(Player player, Vec3 travelVector) {
        boolean debugWing;
        float speed_cap;
        float friction;
        float boostStrength;
        AerobaticElytraTickEvent pre;
        if (!AerobaticFlight.shouldAerobaticFly(player)) {
            AerobaticFlight.onNonFlightTravel(player, travelVector);
            return false;
        }
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        IElytraSpec spec = AerobaticElytraLogic.getElytraSpecOrDefault((LivingEntity)player);
        boolean isRemote = AerobaticElytraLogic.isRemoteLocalPlayer(player);
        AerobaticElytraTickEvent aerobaticElytraTickEvent = pre = isRemote ? new AerobaticElytraTickEvent.Remote.Pre(player, spec, data) : new AerobaticElytraTickEvent.Pre(player, spec, data);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            AerobaticElytraTickEvent.Pre p;
            return pre instanceof AerobaticElytraTickEvent.Pre && (p = (AerobaticElytraTickEvent.Pre)pre).isPreventDefault();
        }
        double grav = TravelHandler.travelGravity(player);
        grav = player.m_20069_() ? (grav *= (double)(1.0f - spec.getAbility(IAbility.Ability.AQUATIC))) : (grav *= (double)(1.0f - spec.getAbility(IAbility.Ability.LIFT)));
        float liftCut = data.getLiftCut();
        motionVec.set(player.m_20184_());
        prevMotionVec.set(motionVec);
        Vec3f prevMotionVec = motionVec.copy();
        double hSpeedPrev = motionVec.hNorm();
        if ((double)AerobaticFlight.motionVec.y > -0.5 - 0.5 * (double)spec.getAbility(IAbility.Ability.LIFT)) {
            player.f_19789_ = 1.0f;
        }
        AerobaticFlight.applyRotationAcceleration(player, 1.0f);
        boolean affectedByWeather = Config.weather.ignore_cloud_level || player.m_20183_().m_123342_() > Config.weather.cloud_level || player.m_9236_().m_46861_(player.m_20183_());
        data.setAffectedByWeather(affectedByWeather);
        float biomePrecipitation = WeatherData.getBiomePrecipitationStrength(player);
        float rain2 = player.m_9236_().m_46722_(1.0f) * biomePrecipitation;
        float storm2 = player.m_9236_().m_46661_(1.0f) * biomePrecipitation;
        boolean useWeather = Config.weather.enabled && rain2 > 0.0f && !player.m_20069_() && affectedByWeather;
        Vec3f windVec = WeatherData.getWindVector(player);
        rainAcc.set(0.0f, -rain2 * Config.weather.rain.rain_strength_tick - storm2 * Config.weather.storm.rain_strength_tick, 0.0f);
        if (!data.isBoosted() && data.getPropulsionStrength() == Config.aerobatic.propulsion.range_tick.getFloatMax() && data.isSprinting() && data.getBoostHeat() <= 0.2f) {
            data.setBoosted(true);
            player.m_36222_(FlightStats.AEROBATIC_BOOSTS, 1);
            if (player.m_9236_().f_46443_) {
                AerobaticTrail.addBoostParticles(player);
                AerobaticElytraSound.playBoostSound(player);
            }
        } else if (data.isBoosted() && (!data.isSprinting() || data.getBoostHeat() == 1.0f)) {
            data.setBoosted(false);
            if (player.m_9236_().f_46443_) {
                AerobaticElytraSound.playSlowDownSound(player);
            }
        }
        float heatStep = data.isBoosted() ? 0.01f : -0.0075f;
        data.setBoostHeat(Mth.m_14036_((float)(data.getBoostHeat() + heatStep), (float)0.0f, (float)1.0f));
        float f = boostStrength = data.isBoosted() ? 0.04f : 0.0f;
        if (data.isSprinting()) {
            player.m_6858_(false);
        }
        float propAccStrength = Config.aerobatic.propulsion.range_length / 20.0f;
        float propAcc = data.getPropulsionAcceleration();
        data.setPropulsionStrength(Mth.m_14036_((float)(data.getPropulsionStrength() + propAcc * propAccStrength), (float)Config.aerobatic.propulsion.range_tick.getFloatMin(), (float)Config.aerobatic.propulsion.range_tick.getFloatMax()));
        if (travelVector != null) {
            propAcc = (float)Mth.m_14008_((double)(((double)propAcc + 2.0 * Math.signum(travelVector.f_82481_)) / 3.0), (double)-1.0, (double)1.0);
            data.setPropulsionAcceleration(propAcc);
        }
        float brakeAcc = 0.1f;
        data.setBraking(player.m_6047_() && !data.isBrakeCooling());
        if (Config.aerobatic.braking.max_time_ticks > 0.0f) {
            data.setBrakeHeat(Mth.m_14036_((float)(data.getBrakeHeat() + (data.isBraking() ? 1.0f : -1.0f) / Config.aerobatic.braking.max_time_ticks), (float)0.0f, (float)1.0f));
            if (data.getBrakeHeat() >= 1.0f) {
                data.setBrakeCooling(true);
            } else if (data.getBrakeHeat() <= 0.0f) {
                data.setBrakeCooling(false);
            }
        } else {
            data.setBrakeHeat(0.0f);
            data.setBrakeCooling(false);
        }
        float brakeStrength = Config.aerobatic.braking.enabled ? Mth.m_14036_((float)(data.getBrakeStrength() + (data.isBraking() ? brakeAcc : -brakeAcc)), (float)0.0f, (float)1.0f) : 0.0f;
        data.setBrakeStrength(brakeStrength);
        VectorBase base = data.getRotationBase();
        if (data.updateFlying(true)) {
            data.setRotationYaw(player.m_146908_());
            data.setRotationPitch(player.m_146909_());
            data.setRotationRoll(0.0f);
            data.setSuppressJumping(true);
            base.init(data);
            MinecraftForge.EVENT_BUS.post((Event)(isRemote ? new AerobaticElytraStartFlightEvent.Remote(player, spec, data) : new AerobaticElytraStartFlightEvent(player, spec, data)));
        }
        float tiltPitch = data.getTiltPitch();
        float tiltRoll = data.getTiltRoll();
        float tiltYaw = data.getTiltYaw();
        if (player.m_20069_()) {
            float underwaterTiltFriction = Mth.m_144920_((float)0.85f, (float)1.0f, (float)(motionVec.norm() / 0.8f));
            data.setTiltPitch(tiltPitch *= underwaterTiltFriction);
            data.setTiltRoll(tiltRoll *= underwaterTiltFriction);
            data.setTiltYaw(tiltYaw *= underwaterTiltFriction);
        }
        if (data.isJumping()) {
            data.setTiltPitch(tiltPitch *= 0.8f);
            data.setTiltRoll(tiltRoll *= 0.8f);
            data.setTiltYaw(tiltYaw *= 0.8f);
        }
        float angFriction = 1.0f - (1.0f - Config.aerobatic.physics.friction_angular) * (tiltPitch * tiltPitch + tiltRoll * tiltRoll + 0.5f * tiltYaw * tiltYaw) / Config.aerobatic.tilt.range_pondered;
        float propStrength = data.getPropulsionStrength() * spec.getAbility(IAbility.Ability.SPEED);
        if (data.isBoosted()) {
            propStrength += boostStrength;
        }
        gravAccVec.set(0.0f, -((float)grav) * Config.aerobatic.physics.gravity_multiplier - brakeStrength * Config.aerobatic.braking.added_gravity_tick, 0.0f);
        float stasis = player.m_20069_() ? 0.0f : Easing.quadInOut((float)(1.0f - propStrength / Config.aerobatic.propulsion.range_tick.getFloatMax()));
        AerobaticFlight.gravAccVec.y -= stasis * Config.aerobatic.physics.motorless_gravity_tick;
        if (player.m_20069_()) {
            friction = Mth.m_14179_((float)spec.getAbility(IAbility.Ability.AQUATIC), (float)Config.aerobatic.physics.friction_water_nerf, (float)Config.aerobatic.physics.friction_water);
            friction *= Mth.m_14179_((float)brakeStrength, (float)1.0f, (float)Config.aerobatic.braking.friction) * angFriction;
        } else {
            friction = Mth.m_14179_((float)stasis, (float)Config.aerobatic.physics.friction_base, (float)Config.aerobatic.physics.motorless_friction);
            friction = Mth.m_14179_((float)brakeStrength, (float)friction, (float)Config.aerobatic.braking.friction) * angFriction;
        }
        float glideAcc = -motionVec.dot(base.normal) * Config.aerobatic.physics.glide_multiplier;
        glideAccVec.set(base.normal);
        glideAccVec.mul(glideAcc);
        propAccVec.set(base.look);
        propAccVec.mul(propStrength);
        gravAccVec.mul(1.0f + liftCut * 0.8f);
        glideAccVec.mul(1.0f - liftCut);
        motionVec.mul(1.0f - liftCut * 0.8f);
        motionVec.add(glideAccVec);
        motionVec.add(gravAccVec);
        motionVec.add(propAccVec);
        if (useWeather) {
            motionVec.add(windVec);
            motionVec.add(rainAcc);
        }
        motionVec.mul(friction);
        if (useWeather) {
            Vec3f stasisVec = windVec.copy();
            stasisVec.mul(1.0f - friction);
            motionVec.add(stasisVec);
        }
        if (player instanceof ServerPlayer && (speed_cap = Config.network.speed_cap_tick) > 0.0f && (AerobaticFlight.motionVec.x > speed_cap || AerobaticFlight.motionVec.y > speed_cap || AerobaticFlight.motionVec.z > speed_cap)) {
            MutableComponent chatWarning = TextUtil.ttc((String)"aerobaticelytra.config.warning.speed_cap_broken", (Object[])new Object[]{TextUtil.stc((String)String.format("%.1f", Float.valueOf(Math.max(Math.max(AerobaticFlight.motionVec.x, AerobaticFlight.motionVec.y), AerobaticFlight.motionVec.z))))});
            String warning = String.format("Player %s is flying too fast!: %.1f. Aerobatic Elytra config might be broken", player.m_6302_(), Float.valueOf(Math.max(Math.max(AerobaticFlight.motionVec.x, AerobaticFlight.motionVec.y), AerobaticFlight.motionVec.z)));
            player.m_5661_((Component)chatWarning, false);
            LOGGER.warn(warning);
            AerobaticFlight.motionVec.x = Math.min(AerobaticFlight.motionVec.x, speed_cap);
            AerobaticFlight.motionVec.y = Math.min(AerobaticFlight.motionVec.y, speed_cap);
            AerobaticFlight.motionVec.z = Math.min(AerobaticFlight.motionVec.z, speed_cap);
        }
        if (!(debugWing = AerobaticElytraWingItem.hasDebugWing(player))) {
            motionVec.lerp(prevMotionVec, Config.aerobatic.physics.inertia);
        }
        player.m_20256_(motionVec.toVector3d());
        if (!isRemote && debugWing == Debug.DEBUG.invertFreeze) {
            player.m_6478_(MoverType.SELF, player.m_20184_());
        }
        if (player.f_19862_ || player.f_19863_) {
            AerobaticCollision.onAerobaticCollision(player, hSpeedPrev, motionVec);
        } else {
            data.setLiftCut(Mth.m_14036_((float)(liftCut - 0.15f), (float)0.0f, (float)1.0f));
        }
        float lookAroundYaw = data.getLookAroundYaw();
        float lookAroundPitch = data.getLookAroundPitch();
        data.setPrevLookAroundYaw(lookAroundYaw);
        data.setPrevLookAroundPitch(lookAroundPitch);
        if (player.m_7578_()) {
            boolean lookingAround;
            if (!data.isLookingAround()) {
                if (!data.isLookAroundPersistent()) {
                    data.setLookAroundYaw(lookAroundYaw *= 0.5f);
                    data.setLookAroundPitch(lookAroundPitch *= 0.5f);
                }
                if (lookAroundYaw != 0.0f && Math.abs(lookAroundYaw) < 1.0f) {
                    lookAroundYaw = 0.0f;
                    data.setLookAroundYaw(0.0f);
                }
                if (lookAroundPitch != 0.0f && Math.abs(lookAroundPitch) < 1.0f) {
                    lookAroundPitch = 0.0f;
                    data.setLookAroundPitch(0.0f);
                }
            }
            new AerobaticPackets.DTiltPacket(data).send();
            new AerobaticPackets.DRotationPacket(data).send();
            new AerobaticPackets.DAccelerationPacket(data).send();
            boolean bl = lookingAround = lookAroundYaw != 0.0f || lookAroundPitch != 0.0f;
            if (lookingAround || remoteLookingAround) {
                new AerobaticPackets.DLookAroundPacket(data).send();
            }
            remoteLookingAround = lookingAround;
        }
        if (player.m_20096_()) {
            data.land();
        }
        player.m_267651_(player instanceof FlyingAnimal);
        player.m_36222_(FlightStats.AEROBATIC_FLIGHT_ONE_CM, (int)Math.round(player.m_20184_().m_82553_() * 100.0));
        if (isRemote && data.updatePlayingSound(true)) {
            new AerobaticElytraSound(player).play();
        }
        if (player.m_9236_().f_46443_ && !Debug.DEBUG.suppressParticles && (float)data.getTicksFlying() > 10.0f && !player.f_19863_ && !player.f_19862_ && System.currentTimeMillis() - data.getLastBounceTime() > 250L && !AerobaticElytraWingItem.hasOffhandDebugWing(player)) {
            AerobaticTrail.addParticles(player, motionVec, prevMotionVec);
        }
        float prev = data.getPrevTickRotationRoll();
        while (data.getRotationRoll() - prev > 360.0f) {
            prev += 360.0f;
        }
        while (data.getRotationRoll() - prev < 0.0f) {
            prev -= 360.0f;
        }
        data.updatePrevTickAngles();
        MinecraftForge.EVENT_BUS.post((Event)(isRemote ? new AerobaticElytraTickEvent.Remote.Post(player, spec, data) : new AerobaticElytraTickEvent.Post(player, spec, data)));
        return true;
    }

    public static void onNonFlightTravel(Player player, Vec3 travelVector) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        if (data.updateBoosted(false)) {
            player.m_9236_().m_5594_(player, player.m_20183_(), AerobaticSounds.AEROBATIC_ELYTRA_SLOWDOWN, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (data.updateFlying(false)) {
            AerobaticFlight.doLand(player, data);
        }
        AerobaticFlight.cooldown(player, data);
    }

    public static void onOtherModeTravel(Player player, Vec3 travelVector) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        if (data.updateBoosted(false)) {
            player.m_9236_().m_5594_(player, player.m_20183_(), AerobaticSounds.AEROBATIC_ELYTRA_SLOWDOWN, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (data.getRotationBase().valid) {
            AerobaticFlight.doLand(player, data);
        }
        AerobaticFlight.cooldown(player, data);
    }

    public static void onRemoteOtherModeTravel(Player player) {
        AerobaticFlight.onOtherModeTravel(player, null);
    }

    public static void doLand(Player player, IAerobaticData data) {
        data.land();
        MinecraftForge.EVENT_BUS.post((Event)(AerobaticElytraLogic.isRemoteLocalPlayer(player) ? new AerobaticElytraFinishFlightEvent.Remote(player, data) : new AerobaticElytraFinishFlightEvent(player, data)));
    }

    public static void onRemoteFlightTravel(Player player) {
        AerobaticFlight.onAerobaticTravel(player, null);
    }

    public static void cooldown(Player player, IAerobaticData data) {
        float boostHeat;
        float propStrength = data.getPropulsionStrength();
        if (propStrength != Config.aerobatic.propulsion.takeoff_tick) {
            float step = player.m_20096_() ? 0.05f : 0.02f;
            data.setPropulsionStrength(Config.aerobatic.propulsion.takeoff_tick + (float)Mth.m_14205_((double)(propStrength - Config.aerobatic.propulsion.takeoff_tick)) * Math.max(0.0f, Math.abs(propStrength - Config.aerobatic.propulsion.takeoff_tick) - step * Math.max(Config.aerobatic.propulsion.range_tick.getFloatMax(), Config.aerobatic.propulsion.range_tick.getFloatMin())));
        }
        if ((boostHeat = data.getBoostHeat()) > 0.0f) {
            data.setBoostHeat(Math.max(0.0f, boostHeat - 0.2f));
        }
    }

    public static boolean isAerobaticFlying(Player player) {
        return AerobaticDataCapability.getAerobaticDataOrDefault(player).isFlying();
    }

    private static boolean shouldAerobaticFly(Player player) {
        if (!player.m_21255_() || player.m_150110_().f_35935_ || !FlightDataCapability.getFlightDataOrDefault(player).getFlightMode().is(FlightModeTags.AEROBATIC)) {
            return false;
        }
        ItemStack elytra = AerobaticElytraLogic.getAerobaticElytra((LivingEntity)player);
        if (elytra.m_41619_()) {
            return false;
        }
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        return (elytra.m_41773_() < elytra.m_41776_() - 1 && spec.getAbility(IAbility.Ability.FUEL) > 0.0f || player.m_7500_()) && !player.m_20077_() && (!player.m_20069_() || spec.getAbility(IAbility.Ability.AQUATIC) != 0.0f);
    }

    public static void applyRotationAcceleration(Player player, float partialTick) {
        float delta;
        Optional<IAerobaticData> opt = AerobaticDataCapability.getAerobaticData(player);
        if (opt.isEmpty()) {
            return;
        }
        IAerobaticData data = opt.get();
        VectorBase rotationBase = data.getRotationBase();
        VectorBase cameraBase = data.getCameraBase();
        double time = (double)System.currentTimeMillis() / 1000.0;
        double lastTime = data.getLastRotationTime();
        data.setLastRotationTime(time);
        float f = delta = lastTime == 0.0 ? 0.0f : (float)(time - lastTime) * 20.0f;
        if (delta == 0.0f) {
            return;
        }
        if (Config.weather.enabled && data.isAffectedByWeather()) {
            angularWindVec.set(WeatherData.getAngularWindVector(player));
        } else {
            angularWindVec.set(ZERO);
        }
        float tiltPitch = data.getTiltPitch();
        float tiltRoll = data.getTiltRoll();
        float tiltYaw = data.getTiltYaw();
        motionVec.set(player.m_20184_());
        if (!rotationBase.valid) {
            rotationBase.init(data);
        }
        float strength = motionVec.dot(rotationBase.look);
        if (player.m_20069_()) {
            strength = strength * strength / (Math.abs(strength) + 2.0f) + 0.5f;
        }
        float pitch = (-tiltPitch * strength - AerobaticFlight.angularWindVec.x) * delta;
        float yaw = (tiltYaw * strength - AerobaticFlight.angularWindVec.y) * delta;
        float roll = (tiltRoll * strength + AerobaticFlight.angularWindVec.z) * delta;
        if (player.m_20069_()) {
            yaw *= 4.0f;
        }
        rotationBase.rotate(pitch, yaw, roll);
        long bounceTime = System.currentTimeMillis();
        if (bounceTime - data.getLastBounceTime() < 320L) {
            float t = Easing.quadOut((float)((float)(bounceTime - data.getLastBounceTime()) / 320.0f));
            cameraBase.interpolate(t, data.getPreBounceBase(), data.getPosBounceBase(), rotationBase);
        } else {
            cameraBase.set(rotationBase);
        }
        data.updateRotation(cameraBase, partialTick);
    }

    static {
        ZERO = (Vec3f)Vec3f.ZERO.get();
        prevMotionVec = (Vec3f)Vec3f.ZERO.get();
        motionVec = (Vec3f)Vec3f.ZERO.get();
        gravAccVec = (Vec3f)Vec3f.ZERO.get();
        rainAcc = (Vec3f)Vec3f.ZERO.get();
        propAccVec = (Vec3f)Vec3f.ZERO.get();
        glideAccVec = (Vec3f)Vec3f.ZERO.get();
        angularWindVec = (Vec3f)Vec3f.ZERO.get();
    }
}

