/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.flight;

import endorh.aerobaticelytra.common.block.BrokenLeavesBlock;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.FlightStats;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.lazulib.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AerobaticCollision {
    public static void onAerobaticCollision(Player player, double hSpeedPrev, Vec3f motionVec) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        float propStrength = data.getPropulsionStrength();
        double hSpeedNew = new Vec3f(player.m_20184_()).hNorm();
        double reaction = hSpeedPrev - hSpeedNew;
        float collisionStrength = (float)(reaction * 10.0 - 3.0);
        float damageModifier = 0.0f;
        AABB aaBB = player.m_20191_();
        List<BlockPos> collided = null;
        for (double d = 0.005; d <= 0.5 && (collided = AerobaticCollision.getCollidedBlocksInAABB(player.m_9236_(), aaBB.m_82400_(d))).isEmpty(); d *= 2.0) {
        }
        if (collided.isEmpty()) {
            return;
        }
        int destroyed = 0;
        float speed = motionVec.norm() * 20.0f;
        boolean slimeBounce = false;
        boolean shouldBreakLeaves = Config.collision.leave_breaking.enable && speed > Config.collision.leave_breaking.min_speed_tick && player.m_217043_().m_188501_() < Config.collision.leave_breaking.chance + Config.collision.leave_breaking.chance_linear * speed;
        boolean preventLanding = false;
        for (BlockPos pos : collided) {
            BlockState bs = player.m_9236_().m_8055_(pos);
            if (bs.m_60713_(Blocks.f_50335_)) {
                damageModifier = Math.max(damageModifier, Config.collision.hay_bale_multiplier);
                continue;
            }
            if (bs.m_204336_(BlockTags.f_13035_)) {
                if (!shouldBreakLeaves) continue;
                BrokenLeavesBlock.breakLeaves(player.m_9236_(), pos);
                propStrength *= 0.8f;
                motionVec.mul(0.6f);
                ++destroyed;
                preventLanding = true;
                continue;
            }
            if (bs.m_60734_() instanceof SlimeBlock) {
                slimeBounce = true;
                continue;
            }
            damageModifier = 1.0f;
        }
        if (destroyed > 0) {
            data.setPropulsionStrength(propStrength);
            player.m_20256_(motionVec.toVector3d());
        }
        if (slimeBounce && Config.collision.slime_bounce.enable && motionVec.norm() > Config.collision.slime_bounce.min_speed_tick) {
            boolean bounced;
            preventLanding = true;
            VectorBase base = data.getRotationBase();
            if (player.m_9236_().f_46443_) {
                data.getCameraBase().set(base);
            }
            if ((bounced = AerobaticCollision.tryBounce(player, base, motionVec)) && player.m_9236_().f_46443_) {
                data.setLastBounceTime(System.currentTimeMillis());
                data.getPreBounceBase().set(data.getCameraBase());
                data.getPosBounceBase().set(base);
            }
        }
        if (collisionStrength > 0.0f && damageModifier > 0.0f) {
            player.m_5496_(collisionStrength > 4.0f ? SoundEvents.f_12319_ : SoundEvents.f_12276_, 1.0f, 1.0f);
            player.m_6469_(player.m_269291_().m_269515_(), damageModifier * collisionStrength * Config.collision.damage);
        }
        data.setLiftCut(Mth.m_14036_((float)(data.getLiftCut() + 0.2f), (float)0.0f, (float)1.0f));
        if (player.m_20096_() && player.m_21515_() && !preventLanding) {
            player.m_36321_();
        }
        if (preventLanding) {
            player.m_6853_(false);
        }
    }

    public static boolean tryBounce(Player player, VectorBase base, Vec3f motionVec) {
        boolean bounced = false;
        for (int includeCorners = 0; includeCorners < 2; ++includeCorners) {
            for (Direction.Axis axis : Direction.Axis.values()) {
                Direction dir = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
                if (!(AerobaticCollision.shouldBounceDir(player, dir, false) ^ AerobaticCollision.shouldBounceDir(player, dir.m_122424_(), includeCorners != 0))) continue;
                AerobaticCollision.bounce(player, base, motionVec, axis);
                bounced = true;
            }
            if (bounced) break;
        }
        player.m_20256_(motionVec.toVector3d());
        return bounced;
    }

    public static void bounce(Player player, VectorBase base, Vec3f motionVec, Direction.Axis axis) {
        Vec3f ax = Vec3f.forAxis((Direction.Axis)axis);
        Vec3f look = base.look.copy();
        look.sub(ax, ax.dot(look));
        if (!look.isZero()) {
            float bounceTilt = Mth.m_14036_((float)((1.0f - Math.abs(base.look.dot(ax))) * AerobaticDataCapability.getAerobaticDataOrDefault(player).getTiltRoll() * 12.0f), (float)-60.0f, (float)60.0f);
            look.unitary();
            ax.rotateAlongOrtVecDegrees(look, bounceTilt);
        }
        base.mirror(ax);
        motionVec.reflect(ax);
        motionVec.mul(Config.collision.slime_bounce.friction);
        if (Config.collision.slime_bounce.angular_friction < 1.0f) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
            data.setTiltPitch(data.getTiltPitch() * Config.collision.slime_bounce.angular_friction);
            data.setTiltYaw(data.getTiltYaw() * Config.collision.slime_bounce.angular_friction);
            data.setTiltRoll(data.getTiltRoll() * Config.collision.slime_bounce.angular_friction);
        }
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12391_, SoundSource.PLAYERS, Mth.m_144920_((float)0.0f, (float)1.0f, (float)(motionVec.norm() / 1.6f)), 1.0f);
        player.m_36222_(FlightStats.AEROBATIC_SLIME_BOUNCES, 1);
    }

    public static boolean shouldBounceDir(Player player, Direction dir, boolean includeCorners) {
        return !AerobaticCollision.getCollidedBlocksInAABB(player.m_9236_(), AerobaticCollision.sideAABB(player.m_20191_(), dir, includeCorners), bs -> bs.m_60734_() instanceof SlimeBlock).isEmpty();
    }

    public static AABB sideAABB(AABB b, Direction dir, boolean includeCorners) {
        double e = 0.5;
        double c = includeCorners ? e : 0.0;
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> new AABB(b.f_82291_, b.f_82289_ - c, b.f_82290_ - c, b.f_82291_ + e, b.f_82292_ + c, b.f_82293_ + c);
            case Direction.WEST -> new AABB(b.f_82288_ - e, b.f_82289_ - c, b.f_82290_ - c, b.f_82288_, b.f_82292_ + c, b.f_82293_ + c);
            case Direction.SOUTH -> new AABB(b.f_82288_ - c, b.f_82289_ - c, b.f_82293_, b.f_82291_ + c, b.f_82292_ + c, b.f_82293_ + e);
            case Direction.NORTH -> new AABB(b.f_82288_ - c, b.f_82289_ - c, b.f_82290_ - e, b.f_82291_ + c, b.f_82292_ + c, b.f_82290_);
            case Direction.UP -> new AABB(b.f_82288_ - c, b.f_82292_, b.f_82290_ - c, b.f_82291_ + c, b.f_82292_ + e, b.f_82293_ + c);
            case Direction.DOWN -> new AABB(b.f_82288_ - c, b.f_82289_ - e, b.f_82290_ - c, b.f_82291_ + c, b.f_82289_, b.f_82293_ + c);
        };
    }

    public static List<BlockPos> getCollidedBlocksInAABB(Level world, AABB aaBB) {
        return AerobaticCollision.getCollidedBlocksInAABB(world, aaBB, BlockBehaviour.BlockStateBase::m_280555_);
    }

    public static List<BlockPos> getCollidedBlocksInAABB(Level world, AABB aaBB, Predicate<BlockState> selector) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = Mth.m_14107_((double)aaBB.f_82288_); i < Mth.m_14165_((double)aaBB.f_82291_); ++i) {
            for (int j = Mth.m_14107_((double)aaBB.f_82289_); j < Mth.m_14165_((double)aaBB.f_82292_); ++j) {
                for (int k = Mth.m_14107_((double)aaBB.f_82290_); k < Mth.m_14165_((double)aaBB.f_82293_); ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!selector.test(world.m_8055_(pos))) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }
}

