/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.capability;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.item.IDatapackAbility;
import endorh.aerobaticelytra.common.item.IDatapackAbilityReloadListener;
import endorh.aerobaticelytra.common.item.IEffectAbility;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.capability.ISerializableCapability;
import endorh.lazulib.math.MathParser;
import endorh.lazulib.text.MutableComponentList;
import endorh.lazulib.text.TextUtil;
import endorh.lazulib.text.TooltipUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IElytraSpec
extends IDatapackAbilityReloadListener,
ISerializableCapability {
    default public float getAbility(IAbility prop) {
        return this.getAbilities().get(prop).floatValue();
    }

    public void setAbility(IAbility var1, float var2);

    public Float removeAbility(IAbility var1);

    default public void resetAbility(IAbility prop) {
        this.setAbility(prop, prop.getDefault());
    }

    public void putAbilities(Map<IAbility, Float> var1);

    public void setAbilities(Map<IAbility, Float> var1);

    default public boolean hasAbility(IAbility ability) {
        return this.getAbilities().containsKey(ability);
    }

    public Map<IAbility, Float> getAbilities();

    public Map<String, Float> getUnknownAbilities();

    public Map<IEffectAbility, Boolean> getEffectAbilities();

    public boolean areAbilitiesEqual(IElytraSpec var1);

    public void updatePlayerEntity(ServerPlayer var1);

    @Nullable
    public ServerPlayer getPlayerEntity();

    default public void copy(IElytraSpec spec) {
        this.setAbilities(spec.getAbilities());
        Map<String, Float> unknown = this.getUnknownAbilities();
        unknown.clear();
        unknown.putAll(spec.getUnknownAbilities());
        this.getTrailData().read(spec.getTrailData().write());
    }

    @Override
    default public void onAerobaticElytraDatapackAbilityReload() {
        Map<String, Float> unknown = this.getUnknownAbilities();
        for (IDatapackAbility ability : AerobaticElytraRegistries.getOutdatedAbilities()) {
            if (!this.hasAbility(ability)) continue;
            unknown.put(ability.fullName(), this.removeAbility(ability));
        }
        for (IDatapackAbility ability : AerobaticElytraRegistries.getDatapackAbilities().values()) {
            String name = ability.fullName();
            if (!unknown.containsKey(name)) continue;
            this.setAbility(ability, unknown.remove(name).floatValue());
        }
    }

    @Nonnull
    public TrailData getTrailData();

    default public void addAbilityTooltipInfo(List<Component> tooltip) {
        this.addAbilityTooltipInfo(tooltip, "");
    }

    default public void addAbilityTooltipInfo(List<Component> tooltip, String indent) {
        ArrayList<IAbility> abs = new ArrayList<IAbility>(this.getAbilities().keySet());
        abs.remove(IAbility.Ability.FUEL);
        abs.remove(IAbility.Ability.MAX_FUEL);
        if (abs.isEmpty()) {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)"aerobaticelytra.abilities", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)TextUtil.ttc((String)"gui.none", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY))).m_130940_(ChatFormatting.GRAY));
        } else if (Screen.m_96639_()) {
            abs.sort(Comparator.comparing(ab -> ab.getDisplayType().isBool() ? 1 : 0).thenComparing(ab -> ab.getDisplayName().getString()));
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)"aerobaticelytra.abilities", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)TooltipUtil.altToExpand())).m_130940_(ChatFormatting.GRAY));
            String innerIndent = indent + "  ";
            for (IAbility ability : abs) {
                ability.getDisplayType().format(ability, this.getAbility(ability)).ifPresent(tc -> tooltip.add((Component)TextUtil.stc((String)innerIndent).m_7220_((Component)tc).m_130940_(ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)"aerobaticelytra.abilities", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)TooltipUtil.altToExpand())).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static class TrailData {
        private static final RocketStar[] EMPTY = new RocketStar[0];
        private static final Random RANDOM = new Random();
        private final Map<AerobaticTrail.RocketSide, RocketStar[]> sides = new EnumMap<AerobaticTrail.RocketSide, RocketStar[]>(AerobaticTrail.RocketSide.class);
        private static final String I18N_TRAIL = "aerobaticelytra.item.trail";

        public static TrailData empty() {
            return new TrailData();
        }

        protected TrailData() {
        }

        @NotNull
        public RocketStar[] get(AerobaticTrail.RocketSide side) {
            return this.sides.getOrDefault((Object)side, EMPTY);
        }

        @NotNull
        public Set<AerobaticTrail.RocketSide> getUsedSides() {
            return this.sides.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(this.sides.keySet());
        }

        public Optional<RocketStar[]> pickRandom() {
            RocketStar[][] sides = (RocketStar[][])this.sides.values().stream().filter(Objects::nonNull).toArray(x$0 -> new RocketStar[x$0][]);
            if (sides.length == 0) {
                return Optional.empty();
            }
            return Optional.of(sides[RANDOM.nextInt(sides.length)]);
        }

        public void keep(ElytraDyement.WingSide side) {
            for (AerobaticTrail.RocketSide s : AerobaticTrail.RocketSide.forWingSide(side)) {
                RocketStar[] value = this.get(s);
                this.put(s.opposite(), value == null ? null : Arrays.copyOf(value, value.length));
            }
        }

        public void set(ElytraDyement.WingSide side, TrailData source) {
            AerobaticTrail.RocketSide[] rocketSideArray = AerobaticTrail.RocketSide.forWingSide(side);
            int n = rocketSideArray.length;
            for (int i = 0; i < n; ++i) {
                AerobaticTrail.RocketSide s;
                RocketStar[] value = source.get(s = rocketSideArray[i]);
                this.put(s, value == null ? null : Arrays.copyOf(value, value.length));
            }
        }

        public void put(AerobaticTrail.RocketSide side, RocketStar[] value) {
            if (value == null || value.length == 0) {
                this.sides.remove((Object)side);
            } else {
                this.sides.put(side, value);
            }
        }

        public static TrailData read(FriendlyByteBuf buf) {
            TrailData data = new TrailData();
            data.read(buf.m_130260_());
            return data;
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130079_(this.write());
        }

        public void read(CompoundTag trailNBT) {
            if (trailNBT == null) {
                trailNBT = new CompoundTag();
            }
            this.sides.clear();
            for (AerobaticTrail.RocketSide rocketSide : AerobaticTrail.RocketSide.values()) {
                if (!trailNBT.m_128441_(rocketSide.tagName)) continue;
                this.put(rocketSide, RocketStar.listFromNBT(trailNBT.m_128437_(rocketSide.tagName, 10)));
            }
        }

        public CompoundTag write() {
            CompoundTag trailNBT = new CompoundTag();
            for (AerobaticTrail.RocketSide rocketSide : AerobaticTrail.RocketSide.values()) {
                RocketStar[] stars = this.get(rocketSide);
                if (stars.length <= 0) continue;
                trailNBT.m_128365_(rocketSide.tagName, (Tag)RocketStar.listAsNBT(stars));
            }
            return trailNBT;
        }

        public void writeRocket(AerobaticTrail.RocketSide side, ItemStack rocket) {
            RocketStar[] stars = this.get(side);
            if (stars.length == 0) {
                CompoundTag fireworks = rocket.m_41737_("Fireworks");
                if (fireworks != null) {
                    fireworks.m_128473_("Explosions");
                }
            } else {
                CompoundTag fireworks = rocket.m_41698_("Fireworks");
                fireworks.m_128365_("Explosions", (Tag)RocketStar.listAsNBT(stars));
            }
        }

        public void readRocket(AerobaticTrail.RocketSide side, ItemStack rocket) {
            CompoundTag fireworks = rocket.m_41737_("Fireworks");
            if (fireworks != null && fireworks.m_128425_("Explosions", 9)) {
                this.put(side, RocketStar.listFromNBT(fireworks.m_128437_("Explosions", 10)));
            } else {
                this.put(side, null);
            }
        }

        public TrailData copy() {
            return (TrailData)Util.m_137469_((Object)new TrailData(), t -> {
                for (ElytraDyement.WingSide side : ElytraDyement.WingSide.values()) {
                    t.set(side, this);
                }
            });
        }

        public static void addTooltipInfo(List<Component> tooltip, TrailData data, String indent) {
            TrailData.addTooltipInfo(tooltip, data, null, indent);
        }

        public static void addTooltipInfo(List<Component> tooltip, TrailData data, @Nullable ElytraDyement.WingSide wingSide, String indent) {
            ArrayList<MutableComponent> trailInfo = new ArrayList<MutableComponent>();
            String innerIndent = indent + "  ";
            for (AerobaticTrail.RocketSide side : AerobaticTrail.RocketSide.forWingSide(wingSide)) {
                RocketStar[] stars = data.get(side);
                if (stars.length <= 0) continue;
                trailInfo.add(TextUtil.stc((String)innerIndent).m_7220_((Component)side.getDisplayName()).m_130946_(": ").m_130940_(ChatFormatting.GRAY));
                trailInfo.addAll((Collection<MutableComponent>)RocketStar.getTooltipInfo(stars, innerIndent + "  ", ChatFormatting.GRAY));
            }
            if (trailInfo.size() == 0) {
                tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)I18N_TRAIL, (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)TextUtil.ttc((String)"gui.none", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY))).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)I18N_TRAIL, (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)TooltipUtil.ctrlToExpand())).m_130940_(ChatFormatting.GRAY));
                if (Screen.m_96637_()) {
                    tooltip.addAll(trailInfo);
                }
            }
        }
    }

    public static class Upgrade {
        protected final String abilityName;
        protected IAbility type;
        protected final String rawExpression;
        protected MathParser.ParsedExpression<Double> expression;
        protected MutableComponent prettyExpression;
        protected boolean booleanValue;
        protected final float min;
        protected final float max;
        protected boolean valid;

        public Upgrade(String abilityName, String expression, float min, float max) {
            this.abilityName = abilityName;
            this.rawExpression = expression;
            this.min = min;
            this.max = max;
            this.reloadAbilities();
        }

        public boolean reloadAbilities() {
            this.type = AerobaticElytraRegistries.getAbilityByName(this.abilityName);
            try {
                this.expression = AerobaticElytraRegistries.ABILITY_EXPRESSION_PARSER.parse(this.rawExpression);
            }
            catch (MathParser.ExpressionParser.ParseException.NameParseException ignored) {
                this.expression = null;
            }
            boolean bl = this.valid = this.expression != null && this.type != null;
            if (this.valid) {
                MutableComponent pretty = (MutableComponent)AerobaticElytraRegistries.ABILITY_EXPRESSION_HIGHLIGHTER.parse(this.rawExpression).eval();
                if (this.type.getDisplayType().isBool()) {
                    String expr = pretty.getString().trim();
                    boolean val = false;
                    try {
                        double parsed = Double.parseDouble(expr);
                        if (parsed == 1.0 && this.min <= 1.0f && this.max >= 1.0f) {
                            pretty = null;
                            val = true;
                        } else if (parsed == 0.0 && this.min <= 0.0f && this.max >= 0.0f) {
                            pretty = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.booleanValue = val;
                } else {
                    this.booleanValue = false;
                }
                this.prettyExpression = pretty;
            }
            return this.valid;
        }

        public static List<Upgrade> deserialize(JsonArray arr) {
            ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
            for (int i = 0; i < arr.size(); ++i) {
                try {
                    upgrades.add(Upgrade.deserialize(arr.get(i).getAsJsonObject()));
                    continue;
                }
                catch (Exception e) {
                    throw new JsonSyntaxException("Malformed upgrade at index " + i, (Throwable)e);
                }
            }
            return upgrades;
        }

        public static Upgrade deserialize(JsonObject obj) {
            String expression;
            String abilityName = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            JsonElement expr = obj.get("expression");
            if (!expr.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected 'expression' to be a primitive JSON value");
            }
            JsonPrimitive primitive = expr.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                expression = String.valueOf(primitive.getAsDouble());
            } else if (primitive.isBoolean()) {
                expression = String.valueOf(primitive.getAsBoolean() ? 1.0f : 0.0f);
            } else if (primitive.isString()) {
                expression = GsonHelper.m_13906_((JsonObject)obj, (String)"expression");
            } else {
                throw new JsonSyntaxException("'expression' must be either a number, boolean or a string");
            }
            float min = GsonHelper.m_13820_((JsonObject)obj, (String)"min", (float)Float.NEGATIVE_INFINITY);
            float max = GsonHelper.m_13820_((JsonObject)obj, (String)"max", (float)Float.POSITIVE_INFINITY);
            if (min > max) {
                throw new JsonSyntaxException("'min' cannot be greater than 'max'");
            }
            return new Upgrade(abilityName, expression, min, max);
        }

        public static Upgrade read(FriendlyByteBuf buf) {
            String abilityName = buf.m_130277_();
            String expression = buf.m_130277_();
            float min = buf.readFloat();
            float max = buf.readFloat();
            return new Upgrade(abilityName, expression, min, max);
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.abilityName);
            buf.m_130070_(this.expression.getExpression());
            buf.writeFloat(this.min);
            buf.writeFloat(this.max);
        }

        public boolean apply(IElytraSpec spec) {
            MathParser.FixedNamespaceSet namespaceSet = this.expression.getNamespaceSet();
            for (IAbility t : AerobaticElytraRegistries.getAbilities().values()) {
                namespaceSet.set(t.getName(), (Object)spec.getAbility(t));
            }
            float result = (float)Mth.m_14008_((double)((Double)this.expression.eval()), (double)this.min, (double)this.max);
            if (spec.getAbility(this.type) != result) {
                spec.setAbility(this.type, result);
                return true;
            }
            return false;
        }

        public IAbility getType() {
            return this.type;
        }

        public MathParser.ParsedExpression<Double> getExpression() {
            return this.expression;
        }

        public MutableComponent getPrettyExpression() {
            return this.prettyExpression;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<Component> getDisplay() {
            ArrayList<Component> tt = new ArrayList<Component>();
            if (this.type == null) {
                tt.add((Component)TextUtil.stc((String)"<Error>").m_130940_(ChatFormatting.RED));
                return tt;
            }
            String name = this.type.getName();
            ChatFormatting color = AerobaticElytraRegistries.ABILITY_EXPRESSION_HIGHLIGHTER.getNameColor(name);
            if (this.prettyExpression != null) {
                tt.add((Component)TextUtil.stc((String)name).m_130940_(color).m_7220_((Component)TextUtil.stc((String)" = ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)this.prettyExpression));
            } else {
                tt.add((Component)TextUtil.ttc((String)("aerobaticelytra.recipe.upgrade." + (this.booleanValue ? "enable" : "disable")), (Object[])new Object[]{TextUtil.stc((String)name).m_130940_(color)}).m_130940_(ChatFormatting.GRAY));
            }
            if (this.min != Float.NEGATIVE_INFINITY || this.max != Float.POSITIVE_INFINITY) {
                MutableComponent l = TextUtil.stc((String)"  ");
                if (this.min != Float.NEGATIVE_INFINITY) {
                    l.m_7220_((Component)TextUtil.stc((String)"min: ").m_7220_((Component)TextUtil.stc((String)String.format("%.2f", Float.valueOf(this.min))).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
                }
                if (this.max != Float.POSITIVE_INFINITY) {
                    if (this.min != Float.NEGATIVE_INFINITY) {
                        l.m_7220_((Component)TextUtil.stc((String)", ").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    l.m_7220_((Component)TextUtil.stc((String)"max: ").m_7220_((Component)TextUtil.stc((String)String.format("%.2f", Float.valueOf(this.max))).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
                }
                tt.add((Component)l);
            }
            return tt;
        }

        public String toString() {
            return "<" + this.type.getName() + " = " + this.expression + (String)(this.min != Float.NEGATIVE_INFINITY ? "; min: " + this.min : "") + (String)(this.max != Float.POSITIVE_INFINITY ? "; max: " + this.max : "") + ">";
        }
    }

    public static class RocketStar {
        public static final byte SHAPE_SMALL_BALL = 0;
        public static final byte SHAPE_LARGE_BALL = 1;
        public static final byte SHAPE_STAR = 2;
        public static final byte SHAPE_CREEPER = 3;
        public static final byte SHAPE_BURST = 4;
        public static final byte SHAPE_BUBBLE = 5;
        public final boolean flicker;
        public final boolean trail;
        public final byte type;
        public final int[] colors;
        public final int[] fadeColors;

        public RocketStar(List<DyeColor> colors, List<DyeColor> fadeColors, boolean flicker, boolean trail, byte shape) {
            this(flicker, trail, shape, colors.stream().mapToInt(DyeColor::m_41070_).toArray(), fadeColors.stream().mapToInt(DyeColor::m_41070_).toArray());
        }

        public RocketStar(boolean flickerIn, boolean trailIn, byte typeIn, int[] colorsIn, int[] fadeColorsIn) {
            this.flicker = flickerIn;
            this.trail = trailIn;
            this.type = typeIn;
            this.colors = colorsIn;
            this.fadeColors = fadeColorsIn;
        }

        public static RocketStar[] listFromNBT(ListTag nbt) {
            int size = nbt.size();
            RocketStar[] explosions = new RocketStar[size];
            for (int i = 0; i < size; ++i) {
                CompoundTag item2 = nbt.m_128728_(i);
                explosions[i] = new RocketStar(item2.m_128471_("Flicker"), item2.m_128471_("Trail"), item2.m_128445_("Type"), item2.m_128465_("Colors"), item2.m_128465_("FadeColors"));
            }
            return explosions;
        }

        public static ListTag listAsNBT(RocketStar[] list) {
            ListTag nbt = new ListTag();
            for (RocketStar explosion : list) {
                CompoundTag item2 = new CompoundTag();
                item2.m_128379_("Flicker", explosion.flicker);
                item2.m_128379_("Trail", explosion.trail);
                item2.m_128344_("Type", explosion.type);
                item2.m_128385_("Colors", explosion.colors);
                item2.m_128385_("FadeColors", explosion.fadeColors);
                nbt.add((Object)item2);
            }
            return nbt;
        }

        public static MutableComponentList getTooltipInfo(RocketStar[] list, String indent, ChatFormatting format) {
            MutableComponentList tooltip = new MutableComponentList();
            String inner = indent + "  ";
            for (RocketStar star : list) {
                FireworkRocketItem.Shape shape = FireworkRocketItem.Shape.m_41237_((int)star.type);
                MutableComponent tc = TextUtil.stc((String)indent).m_7220_((Component)TextUtil.ttc((String)("item.minecraft.firework_star.shape." + shape.m_41241_()), (Object[])new Object[0])).m_130940_(format);
                if (star.trail) {
                    tc.m_130946_(": ");
                    tc.m_7220_((Component)TextUtil.ttc((String)"item.minecraft.firework_star.trail", (Object[])new Object[0]));
                }
                if (star.flicker) {
                    if (star.trail) {
                        tc.m_7220_((Component)TextUtil.stc((String)", "));
                    } else {
                        tc.m_7220_((Component)TextUtil.stc((String)": "));
                    }
                    tc.m_7220_((Component)TextUtil.ttc((String)"item.minecraft.firework_star.flicker", (Object[])new Object[0]));
                }
                tooltip.add(tc.m_130940_(format));
                if (star.colors.length > 0) {
                    tooltip.add(RocketStar.joinDyeList(TextUtil.stc((String)inner), star.colors).m_130940_(format));
                }
                if (star.fadeColors.length <= 0) continue;
                tooltip.add(TextUtil.stc((String)inner).m_7220_((Component)RocketStar.joinDyeList(TextUtil.ttc((String)"item.minecraft.firework_star.fade_to", (Object[])new Object[0]).m_130946_(" "), star.fadeColors)).m_130940_(format));
            }
            return tooltip;
        }

        private static MutableComponent joinDyeList(MutableComponent tc, int[] list) {
            for (int i = 0; i < list.length; ++i) {
                if (i > 0) {
                    tc.m_130946_(", ");
                }
                tc.m_7220_(RocketStar.dyeName(list[i]));
            }
            return tc;
        }

        private static Component dyeName(int color) {
            DyeColor dyecolor = DyeColor.m_41061_((int)color);
            return dyecolor == null ? Component.m_237115_((String)"item.minecraft.firework_star.custom_color") : Component.m_237115_((String)("item.minecraft.firework_star." + dyecolor.m_41065_()));
        }
    }
}

