/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.capability;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.sound.FadingTickableSound;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.common.flight.mode.FlightModes;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.capability.ISerializableCapability;
import endorh.lazulib.capability.SerializableCapabilityWrapperProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class FlightDataCapability {
    public static Capability<IFlightData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFlightData>(){});
    public static final ResourceLocation ID = AerobaticElytra.prefix("flight_data");

    public static IFlightData fromNBT(CompoundTag nbt) {
        FlightData data = new FlightData(null);
        data.deserializeCapability(nbt);
        return data;
    }

    public static CompoundTag asNBT(IFlightData data) {
        return data.serializeCapability();
    }

    public static IFlightData requireFlightData(Player player) {
        return (IFlightData)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("Missing IFlightData capability on player: " + player));
    }

    public static IFlightData getFlightDataOrDefault(Player player) {
        return (IFlightData)player.getCapability(CAPABILITY).orElse((Object)new FlightData(player));
    }

    public static Optional<IFlightData> getFlightData(Player player) {
        assert (CAPABILITY != null);
        return player.getCapability(CAPABILITY).resolve();
    }

    public static ICapabilitySerializable<CompoundTag> createProvider(Player player) {
        if (CAPABILITY == null) {
            return null;
        }
        return new SerializableCapabilityWrapperProvider(CAPABILITY, null, (ISerializableCapability)new FlightData(player));
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(ID, FlightDataCapability.createProvider(player));
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        IFlightData playerData = FlightDataCapability.requireFlightData(event.getEntity());
        playerData.copy(FlightDataCapability.getFlightDataOrDefault(event.getOriginal()));
        playerData.reset();
    }

    public static class FlightData
    implements IFlightData {
        public static final String TAG_FLIGHT_MODE = "FlightMode";
        protected final Player player;
        @Nonnull
        protected IFlightMode mode = FlightModes.ELYTRA_FLIGHT;
        protected final Map<ResourceLocation, FadingTickableSound> flightSounds = new HashMap<ResourceLocation, FadingTickableSound>();

        public FlightData(Player player) {
            this.player = player;
        }

        @Override
        public Player getPlayer() {
            return this.player;
        }

        @Override
        @Nonnull
        public IFlightMode getFlightMode() {
            return this.mode;
        }

        @Override
        public void setFlightMode(@Nonnull IFlightMode mode) {
            this.mode = mode;
        }

        @Override
        @Nullable
        public FadingTickableSound getFlightSound(ResourceLocation type) {
            return this.flightSounds.get(type);
        }

        @Override
        public void putFlightSound(ResourceLocation type, FadingTickableSound sound2) {
            this.flightSounds.put(type, sound2);
        }

        public CompoundTag serializeCapability() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_(TAG_FLIGHT_MODE, Objects.requireNonNull(AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.getKey((Object)this.getFlightMode())).toString());
            return nbt;
        }

        public void deserializeCapability(CompoundTag nbt) {
            ResourceLocation regName = new ResourceLocation(nbt.m_128461_(TAG_FLIGHT_MODE));
            if (!AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.containsKey(regName)) {
                this.setFlightMode(FlightModes.ELYTRA_FLIGHT);
            } else {
                IFlightMode mode = (IFlightMode)AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.getValue(regName);
                if (mode == null) {
                    mode = FlightModes.ELYTRA_FLIGHT;
                }
                this.setFlightMode(mode);
            }
        }
    }
}

