/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.capability;

import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.item.IEffectAbility;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.capability.ISerializableCapability;
import endorh.lazulib.capability.SerializableCapabilityWrapperProvider;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ElytraSpecCapability {
    public static Capability<IElytraSpec> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IElytraSpec>(){});

    public static IElytraSpec fromNBT(CompoundTag nbt) {
        ElytraSpec spec = new ElytraSpec();
        spec.deserializeCapability(nbt);
        return spec;
    }

    public static CompoundTag asNBT(IElytraSpec spec) {
        return spec.serializeCapability();
    }

    public static LazyOptional<IElytraSpec> getElytraSpec(ItemStack stack) {
        assert (CAPABILITY != null);
        return stack.getCapability(CAPABILITY);
    }

    public static IElytraSpec getElytraSpecOrDefault(ItemStack stack) {
        assert (CAPABILITY != null);
        return (IElytraSpec)stack.getCapability(CAPABILITY).orElse((Object)new ElytraSpec());
    }

    public static ICapabilitySerializable<CompoundTag> createProvider() {
        if (CAPABILITY == null) {
            return null;
        }
        return new SerializableCapabilityWrapperProvider(CAPABILITY, null, (ISerializableCapability)new ElytraSpec());
    }

    public static ICapabilitySerializable<CompoundTag> createProvider(IElytraSpec spec) {
        if (CAPABILITY == null) {
            return null;
        }
        return new SerializableCapabilityWrapperProvider(CAPABILITY, null, (ISerializableCapability)spec);
    }

    public static boolean compareNoTrail(CompoundTag leftCapNBT, CompoundTag rightCapNBT) {
        if (leftCapNBT == null && rightCapNBT == null) {
            return true;
        }
        if (leftCapNBT == null || rightCapNBT == null) {
            return false;
        }
        CompoundTag left = leftCapNBT.m_6426_();
        CompoundTag right = rightCapNBT.m_6426_();
        left.m_128469_("Parent").m_128469_("aerobaticelytra:spec").m_128473_("Trail");
        right.m_128469_("Parent").m_128469_("aerobaticelytra:spec").m_128473_("Trail");
        return left.equals((Object)right);
    }

    public static class ElytraSpec
    implements IElytraSpec {
        public static final String TAG_BASE = "aerobaticelytra:spec";
        public static final String TAG_ABILITIES = "Ability";
        public static final String TAG_TRAIL = "Trail";
        protected WeakReference<ServerPlayer> player;
        protected final Map<IAbility, Float> properties = new HashMap<IAbility, Float>();
        protected final Map<IEffectAbility, Boolean> effectAbilities = new HashMap<IEffectAbility, Boolean>();
        protected final IElytraSpec.TrailData trailData = new IElytraSpec.TrailData();
        protected final Map<String, Float> unknownProperties = new HashMap<String, Float>();

        public ElytraSpec() {
            this.registerAerobaticElytraDatapackAbilityReloadListener();
        }

        @Override
        public void updatePlayerEntity(ServerPlayer player) {
            this.player = new WeakReference<ServerPlayer>(player);
        }

        @Override
        @Nullable
        public ServerPlayer getPlayerEntity() {
            return (ServerPlayer)this.player.get();
        }

        @Override
        public float getAbility(IAbility prop) {
            return this.properties.getOrDefault(prop, Float.valueOf(prop.getDefault())).floatValue();
        }

        @Override
        public void setAbility(IAbility prop, float value) {
            this.properties.put(prop, Float.valueOf(value));
            if (prop instanceof IEffectAbility && !this.effectAbilities.containsKey(prop)) {
                this.effectAbilities.put((IEffectAbility)prop, false);
            }
        }

        @Override
        public Float removeAbility(IAbility ability) {
            ServerPlayer player;
            if (ability instanceof IEffectAbility && this.effectAbilities.remove(ability).booleanValue() && (player = (ServerPlayer)this.player.get()) != null) {
                ((IEffectAbility)ability).undoEffect(player);
            }
            return this.properties.remove(ability);
        }

        @Override
        public Map<IAbility, Float> getAbilities() {
            return Collections.unmodifiableMap(this.properties);
        }

        @Override
        public void putAbilities(Map<IAbility, Float> abilities) {
            this.properties.putAll(abilities);
            for (IAbility ability : abilities.keySet()) {
                if (!(ability instanceof IEffectAbility) || this.effectAbilities.containsKey(ability)) continue;
                this.effectAbilities.put((IEffectAbility)ability, false);
            }
        }

        @Override
        public void setAbilities(Map<IAbility, Float> abilities) {
            this.properties.clear();
            this.effectAbilities.clear();
            this.putAbilities(abilities);
        }

        @Override
        public boolean hasAbility(IAbility ability) {
            return this.properties.containsKey(ability);
        }

        @Override
        public Map<IEffectAbility, Boolean> getEffectAbilities() {
            return this.effectAbilities;
        }

        @Override
        public Map<String, Float> getUnknownAbilities() {
            return this.unknownProperties;
        }

        @Override
        public boolean areAbilitiesEqual(IElytraSpec other) {
            return this.properties.equals(other.getAbilities()) && this.effectAbilities.equals(other.getEffectAbilities()) && this.unknownProperties.equals(other.getUnknownAbilities());
        }

        @Override
        @Nonnull
        public IElytraSpec.TrailData getTrailData() {
            return this.trailData;
        }

        public CompoundTag serializeCapability() {
            CompoundTag nbt = new CompoundTag();
            CompoundTag data = new CompoundTag();
            CompoundTag ability = new CompoundTag();
            for (Map.Entry<String, Float> entry : this.getUnknownAbilities().entrySet()) {
                ability.m_128350_(entry.getKey(), entry.getValue().floatValue());
            }
            for (Map.Entry<Object, Float> entry : this.getAbilities().entrySet()) {
                IAbility type = (IAbility)entry.getKey();
                float val = entry.getValue().floatValue();
                if (val == type.getDefault()) continue;
                ability.m_128350_(type.fullName(), val);
            }
            data.m_128365_(TAG_ABILITIES, (Tag)ability);
            CompoundTag trailNBT = this.getTrailData().write();
            if (!trailNBT.m_128456_()) {
                data.m_128365_(TAG_TRAIL, (Tag)trailNBT);
            }
            nbt.m_128365_(TAG_BASE, (Tag)data);
            return nbt;
        }

        public void deserializeCapability(CompoundTag nbt) {
            CompoundTag data = nbt.m_128469_(TAG_BASE);
            CompoundTag ability = data.m_128469_(TAG_ABILITIES);
            for (IAbility iAbility : AerobaticElytraRegistries.getAbilities().values()) {
                if (ability.m_128441_(iAbility.fullName())) {
                    float value = ability.m_128457_(iAbility.fullName());
                    if (Config.item.fix_nan_elytra_abilities && Float.isNaN(value)) {
                        value = iAbility.getDefault();
                    }
                    this.setAbility(iAbility, value);
                    continue;
                }
                this.setAbility(iAbility, iAbility.getDefault());
            }
            Map<String, Float> unknown = this.getUnknownAbilities();
            unknown.clear();
            for (String name : ability.m_128431_()) {
                if (IAbility.isDefined(name)) continue;
                unknown.put(name, Float.valueOf(ability.m_128457_(name)));
            }
            IElytraSpec.TrailData trailData = this.getTrailData();
            if (data.m_128441_(TAG_TRAIL)) {
                trailData.read(data.m_128469_(TAG_TRAIL));
            }
        }

        public String toString() {
            return String.format("FlightSpec: {%s, TrailData: %s}", this.properties.entrySet().stream().map(entry -> String.format("%s: %2.2f", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")), this.trailData);
        }
    }
}

