/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.capability;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.lazulib.capability.ISerializableCapability;
import endorh.lazulib.capability.SerializableCapabilityWrapperProvider;
import endorh.lazulib.math.Vec3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class AerobaticDataCapability {
    public static Capability<IAerobaticData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAerobaticData>(){});
    public static final ResourceLocation ID = AerobaticElytra.prefix("aerobatic_data");

    public static IAerobaticData fromNBT(CompoundTag nbt) {
        AerobaticData data = new AerobaticData(null);
        data.deserializeCapability(nbt);
        return data;
    }

    public static CompoundTag asNBT(IAerobaticData data) {
        return data.serializeCapability();
    }

    public static IAerobaticData requireAerobaticData(Player player) {
        assert (CAPABILITY != null);
        return (IAerobaticData)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("Missing IAerobaticData capability on player: " + player));
    }

    public static IAerobaticData getAerobaticDataOrDefault(Player player) {
        assert (CAPABILITY != null);
        return (IAerobaticData)player.getCapability(CAPABILITY).orElse((Object)new AerobaticData(player));
    }

    public static Optional<IAerobaticData> getAerobaticData(Player player) {
        assert (CAPABILITY != null);
        return player.getCapability(CAPABILITY).resolve();
    }

    public static ICapabilitySerializable<CompoundTag> createProvider(Player player) {
        if (CAPABILITY == null) {
            return null;
        }
        return new SerializableCapabilityWrapperProvider(CAPABILITY, null, (ISerializableCapability)new AerobaticData(player));
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(ID, AerobaticDataCapability.createProvider(player));
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        IAerobaticData playerData = AerobaticDataCapability.requireAerobaticData(event.getEntity());
        playerData.copy(AerobaticDataCapability.getAerobaticDataOrDefault(event.getOriginal()));
        playerData.reset();
    }

    public static class AerobaticData
    implements IAerobaticData {
        public static final String TAG_ROLL = "Roll";
        public static final String TAG_PITCH_TILT = "PitchTilt";
        public static final String TAG_ROLL_TILT = "RollTilt";
        public static final String TAG_YAW_TILT = "YawTilt";
        public static final String TAG_LOOK_PITCH = "LookPitch";
        public static final String TAG_LOOK_YAW = "LookYaw";
        public static final String TAG_FLYING = "Flying";
        public static final String TAG_PROPULSION = "Propulsion";
        public static final String TAG_ROTATION_BASE = "Rotation";
        protected final Player player;
        protected float rotationYaw = 0.0f;
        protected float rotationPitch = 0.0f;
        protected float rotationRoll = 0.0f;
        protected float prevTickRotationPitch = 0.0f;
        protected float prevTickRotationRoll = 0.0f;
        protected float prevTickRotationYaw = 0.0f;
        protected float tiltPitch = 0.0f;
        protected float tiltRoll = 0.0f;
        protected float tiltYaw = 0.0f;
        protected float lookAroundYaw = 0.0f;
        protected float lookAroundPitch = 0.0f;
        protected float lookAroundRoll;
        protected float prevLookAroundYaw;
        protected float prevLookAroundPitch;
        protected float prevLookAroundRoll;
        protected final VectorBase rotationBase = new VectorBase();
        protected final VectorBase cameraBase = new VectorBase();
        protected final VectorBase preBounceBase = new VectorBase();
        protected final VectorBase posBounceBase = new VectorBase();
        protected final VectorBase lookAroundBase = new VectorBase();
        protected boolean braking = false;
        protected float brakeStrength = 0.0f;
        protected float brakeHeat = 0.0f;
        protected boolean brakeCooling = false;
        protected float propStrength = 0.0f;
        protected float propAcc = 0.0f;
        protected boolean boosted = false;
        protected float boostHeat = 0.0f;
        protected float liftCut = 0.0f;
        protected boolean isFlying = false;
        protected double lastRotationTime = 0.0;
        protected long lastBounceTime = 0L;
        protected boolean sneaking = false;
        protected boolean jumping = false;
        protected boolean suppressJumping = false;
        protected boolean sprinting = false;
        protected boolean lookingAround = false;
        protected boolean persistentLookAround = false;
        protected boolean aimingBow = false;
        protected boolean playingSound = false;
        protected ElytraOnPlayerSoundInstance elytraSound = null;
        protected int lastLiftOff = 0;
        protected final Vec3d lastTrailPos = (Vec3d)Vec3d.ZERO.get();
        protected boolean affectedByWeather;

        public AerobaticData(Player player) {
            this.player = player;
        }

        @Override
        public Player getPlayer() {
            return this.player;
        }

        @Override
        public float getRotationPitch() {
            return this.rotationPitch;
        }

        @Override
        public float getRotationYaw() {
            return this.rotationYaw;
        }

        @Override
        public void setRotationPitch(float pitch) {
            this.rotationPitch = pitch;
        }

        @Override
        public void updateRotation(VectorBase base, float partialTick) {
            float[] spherical = base.toSpherical(this.player.f_19859_);
            this.setRotationYaw(spherical[0]);
            this.setRotationPitch(spherical[1]);
            this.setRotationRoll(spherical[2]);
            this.lookAroundBase.set(base);
            float lookYaw = Mth.m_14179_((float)partialTick, (float)this.getPrevLookAroundYaw(), (float)this.getLookAroundYaw());
            float lookPitch = Mth.m_14179_((float)partialTick, (float)this.getPrevLookAroundPitch(), (float)this.getLookAroundPitch());
            this.lookAroundBase.applyLookAround(lookYaw, lookPitch);
            float[] lookSpherical = this.lookAroundBase.toSpherical(this.player.f_19859_);
            this.player.f_19859_ = this.player.m_146908_();
            this.player.m_146922_(lookSpherical[0]);
            this.player.f_19860_ = this.player.m_146909_();
            this.player.m_146926_(lookSpherical[1]);
            this.prevLookAroundRoll = this.lookAroundRoll;
            this.lookAroundRoll = lookSpherical[2];
        }

        @Override
        public void setRotationYaw(float yaw) {
            this.rotationYaw = yaw;
        }

        @Override
        public VectorBase getRotationBase() {
            return this.rotationBase;
        }

        @Override
        public VectorBase getCameraBase() {
            return this.cameraBase;
        }

        @Override
        public VectorBase getPreBounceBase() {
            return this.preBounceBase;
        }

        @Override
        public VectorBase getPosBounceBase() {
            return this.posBounceBase;
        }

        @Override
        public float getPrevTickRotationPitch() {
            return this.prevTickRotationPitch;
        }

        @Override
        public float getPrevTickRotationRoll() {
            return this.prevTickRotationRoll;
        }

        @Override
        public float getPrevTickRotationYaw() {
            return this.prevTickRotationYaw;
        }

        @Override
        public void setPrevTickRotationPitch(float pitch) {
            this.prevTickRotationPitch = pitch;
        }

        @Override
        public void setPrevTickRotationRoll(float roll) {
            this.prevTickRotationRoll = roll;
        }

        @Override
        public void setPrevTickRotationYaw(float yaw) {
            this.prevTickRotationYaw = yaw;
        }

        @Override
        public float getRotationRoll() {
            return this.rotationRoll;
        }

        @Override
        public void setRotationRoll(float rotationRoll) {
            this.rotationRoll = rotationRoll;
        }

        @Override
        public float getTiltPitch() {
            return this.tiltPitch;
        }

        @Override
        public float getTiltRoll() {
            return this.tiltRoll;
        }

        @Override
        public float getTiltYaw() {
            return this.tiltYaw;
        }

        @Override
        public void setTiltPitch(float tiltPitch) {
            this.tiltPitch = tiltPitch;
        }

        @Override
        public void setTiltRoll(float tiltRoll) {
            this.tiltRoll = tiltRoll;
        }

        @Override
        public void setTiltYaw(float tiltYaw) {
            this.tiltYaw = tiltYaw;
        }

        @Override
        public float getLookAroundYaw() {
            return this.lookAroundYaw;
        }

        @Override
        public float getLookAroundPitch() {
            return this.lookAroundPitch;
        }

        @Override
        public float getLookAroundRoll() {
            return this.lookAroundRoll;
        }

        @Override
        public void setLookAroundYaw(float yaw) {
            this.lookAroundYaw = yaw;
        }

        @Override
        public void setLookAroundPitch(float pitch) {
            this.lookAroundPitch = pitch;
        }

        @Override
        public void setLookAroundRoll(float roll) {
            this.lookAroundRoll = roll;
        }

        @Override
        public float getPrevLookAroundYaw() {
            return this.prevLookAroundYaw;
        }

        @Override
        public float getPrevLookAroundPitch() {
            return this.prevLookAroundPitch;
        }

        @Override
        public float getPrevLookAroundRoll() {
            return this.prevLookAroundRoll;
        }

        @Override
        public void setPrevLookAroundYaw(float yaw) {
            this.prevLookAroundYaw = yaw;
        }

        @Override
        public void setPrevLookAroundPitch(float pitch) {
            this.prevLookAroundPitch = pitch;
        }

        @Override
        public void setPrevLookAroundRoll(float roll) {
            this.prevLookAroundRoll = roll;
        }

        @Override
        public boolean isFlying() {
            return this.isFlying;
        }

        @Override
        public void setFlying(boolean flying) {
            if (this.player == null) {
                return;
            }
            this.isFlying = flying;
            if (flying) {
                this.lastLiftOff = this.player.f_19797_;
            }
        }

        @Override
        public int getTicksFlying() {
            return this.isFlying ? this.player.f_19797_ - this.lastLiftOff : 0;
        }

        @Override
        public boolean isAffectedByWeather() {
            return this.affectedByWeather;
        }

        @Override
        public void setAffectedByWeather(boolean affected) {
            this.affectedByWeather = affected;
        }

        @Override
        public float getPropulsionStrength() {
            return this.propStrength;
        }

        @Override
        public void setPropulsionStrength(float strength) {
            this.propStrength = strength;
        }

        @Override
        public float getPropulsionAcceleration() {
            return this.propAcc;
        }

        @Override
        public void setPropulsionAcceleration(float acc) {
            this.propAcc = acc;
        }

        @Override
        public boolean isBoosted() {
            return this.boosted;
        }

        @Override
        public void setBoosted(boolean boosted) {
            this.boosted = boosted;
        }

        @Override
        public float getBoostHeat() {
            return this.boostHeat;
        }

        @Override
        public void setBoostHeat(float heat) {
            this.boostHeat = heat;
        }

        @Override
        public float getBrakeStrength() {
            return this.brakeStrength;
        }

        @Override
        public void setBrakeStrength(float strength) {
            this.brakeStrength = strength;
        }

        @Override
        public boolean isBraking() {
            return this.braking;
        }

        @Override
        public void setBraking(boolean braking2) {
            this.braking = braking2;
        }

        @Override
        public float getBrakeHeat() {
            return this.brakeHeat;
        }

        @Override
        public void setBrakeHeat(float heat) {
            this.brakeHeat = heat;
        }

        @Override
        public boolean isBrakeCooling() {
            return this.brakeCooling;
        }

        @Override
        public void setBrakeCooling(boolean cooling) {
            this.brakeCooling = cooling;
        }

        @Override
        public float getLiftCut() {
            return this.liftCut;
        }

        @Override
        public void setLiftCut(float cut) {
            this.liftCut = cut;
        }

        @Override
        public boolean isSneaking() {
            return this.sneaking;
        }

        @Override
        public void setSneaking(boolean sneaking) {
            this.sneaking = sneaking;
        }

        @Override
        public boolean isJumping() {
            return this.jumping && !this.isSuppressJumping();
        }

        @Override
        public void setJumping(boolean jumping) {
            this.jumping = jumping;
            if (!jumping) {
                this.setSuppressJumping(false);
            }
        }

        @Override
        public boolean isSuppressJumping() {
            return this.suppressJumping;
        }

        @Override
        public void setSuppressJumping(boolean suppress) {
            this.suppressJumping = suppress;
        }

        @Override
        public boolean isSprinting() {
            return this.sprinting;
        }

        @Override
        public void setSprinting(boolean sprinting) {
            this.sprinting = sprinting;
        }

        @Override
        public boolean isLookingAround() {
            return this.lookingAround || this.isAimingBow();
        }

        @Override
        public void setLookingAround(boolean lookingAround) {
            this.lookingAround = lookingAround;
        }

        @Override
        public boolean updateLookingAround(boolean lookingAround) {
            if (lookingAround != this.lookingAround) {
                boolean prev = this.isLookingAround();
                this.setLookingAround(lookingAround);
                return prev != this.isLookingAround() && this.isLookingAround() == lookingAround;
            }
            return false;
        }

        @Override
        public boolean isLookAroundPersistent() {
            return this.persistentLookAround;
        }

        @Override
        public void setLookAroundPersistent(boolean persistent) {
            this.persistentLookAround = persistent;
        }

        @Override
        public boolean isAimingBow() {
            return this.aimingBow;
        }

        @Override
        public void setAimingBow(boolean aiming) {
            this.aimingBow = aiming;
        }

        @Override
        public boolean isPlayingSound() {
            return this.playingSound;
        }

        @Override
        public void setPlayingSound(boolean playing) {
            this.playingSound = playing;
        }

        @Override
        public double getLastRotationTime() {
            return this.lastRotationTime;
        }

        @Override
        public void setLastRotationTime(double time) {
            this.lastRotationTime = time;
        }

        @Override
        public long getLastBounceTime() {
            return this.lastBounceTime;
        }

        @Override
        public void setLastBounceTime(long time) {
            this.lastBounceTime = time;
        }

        @Override
        public Vec3d getLastTrailPos() {
            return this.lastTrailPos;
        }

        @Override
        @Nullable
        public ElytraOnPlayerSoundInstance getElytraSound() {
            return this.elytraSound;
        }

        @Override
        public void setElytraSound(ElytraOnPlayerSoundInstance sound2) {
            this.elytraSound = sound2;
        }

        public CompoundTag serializeCapability() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_(TAG_ROLL, this.getRotationRoll());
            nbt.m_128350_(TAG_PITCH_TILT, this.getTiltPitch());
            nbt.m_128350_(TAG_ROLL_TILT, this.getTiltRoll());
            nbt.m_128350_(TAG_YAW_TILT, this.getTiltYaw());
            nbt.m_128350_(TAG_LOOK_PITCH, this.getLookAroundPitch());
            nbt.m_128350_(TAG_LOOK_YAW, this.getLookAroundYaw());
            nbt.m_128379_(TAG_FLYING, this.isFlying());
            nbt.m_128350_(TAG_PROPULSION, this.getPropulsionStrength());
            nbt.m_128365_(TAG_ROTATION_BASE, (Tag)this.getRotationBase().toNBT());
            return nbt;
        }

        public void deserializeCapability(CompoundTag tag) {
            this.setRotationRoll(tag.m_128457_(TAG_ROLL));
            this.setTiltPitch(tag.m_128457_(TAG_PITCH_TILT));
            this.setTiltRoll(tag.m_128457_(TAG_ROLL_TILT));
            this.setTiltYaw(tag.m_128457_(TAG_YAW_TILT));
            this.setLookAroundPitch(tag.m_128457_(TAG_LOOK_PITCH));
            this.setLookAroundYaw(tag.m_128457_(TAG_LOOK_YAW));
            this.setFlying(tag.m_128471_(TAG_FLYING));
            this.setPropulsionStrength(tag.m_128457_(TAG_PROPULSION));
            this.getRotationBase().readNBT(tag.m_128469_(TAG_ROTATION_BASE));
        }
    }
}

