/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.block;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.common.block.AerobaticBlocks;
import endorh.aerobaticelytra.common.block.entity.BrokenLeavesBlockEntity;
import endorh.aerobaticelytra.common.config.Config;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrokenLeavesBlock
extends LeavesBlock
implements EntityBlock {
    public static final String NAME = "broken_leaves";
    public static final ResourceLocation ID = AerobaticElytra.prefix("broken_leaves");

    public BrokenLeavesBlock() {
        super(BrokenLeavesBlock.createBlockProperties());
    }

    private static BlockBehaviour.Properties createBlockProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((state, reader, pos, type) -> false).m_60960_((state, reader, pos) -> false).m_60971_((state, reader, pos) -> false).m_278183_().m_60910_().m_278166_(PushReaction.DESTROY).m_60924_((state, reader, pos) -> false).m_60999_();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BrokenLeavesBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return super.m_142354_(level, state, type);
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Entity entity) {
        float fallDistance = entity.f_19789_;
        entity.m_7601_(state, new Vec3((double)Config.collision.leave_breaking.motion_multiplier, (double)Config.collision.leave_breaking.motion_multiplier, (double)Config.collision.leave_breaking.motion_multiplier));
        if (entity.m_20184_().m_82556_() > 0.25) {
            entity.f_19789_ = fallDistance;
        }
    }

    public static void breakLeaves(Level world, BlockPos pos) {
        if (world.f_46443_) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            return;
        }
        BlockState prevBlockState = world.m_8055_(pos);
        if (!prevBlockState.m_204336_(BlockTags.f_13035_)) {
            throw new IllegalArgumentException("Attempt to replace non leaves block with broken leaves");
        }
        Integer dist = (Integer)prevBlockState.m_61143_((Property)f_54418_);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            cursor.m_122159_((Vec3i)pos, direction);
            BlockState adj = world.m_8055_((BlockPos)cursor);
            if (!adj.m_204336_(BlockTags.f_13035_) || ((Boolean)adj.m_61143_((Property)f_54419_)).booleanValue() || (Integer)adj.m_61143_((Property)f_54418_) >= 7 || (Integer)adj.m_61143_((Property)f_54418_) <= dist) continue;
            BrokenLeavesBlock.breakLeaves(world, (BlockPos)cursor);
        }
        world.m_7731_(pos, (BlockState)((BlockState)AerobaticBlocks.BROKEN_LEAVES.m_49966_().m_61124_((Property)f_54418_, (Comparable)((Integer)prevBlockState.m_61143_((Property)f_54418_)))).m_61124_((Property)f_54419_, (Comparable)((Boolean)prevBlockState.m_61143_((Property)f_54419_))), 3);
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof BrokenLeavesBlockEntity)) {
            throw new IllegalStateException("Broken leaves block did not have BrokenLeavesTileEntity");
        }
        BrokenLeavesBlockEntity te = (BrokenLeavesBlockEntity)tile;
        te.setReplacedLeaves(prevBlockState);
        te.m_6596_();
    }

    public void tryRestoreBrokenLeaves(ServerLevel world, BlockPos pos) {
        BlockState bs = world.m_8055_(pos);
        if (bs.m_60734_() != AerobaticBlocks.BROKEN_LEAVES) {
            return;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof BrokenLeavesBlockEntity)) {
            return;
        }
        BrokenLeavesBlockEntity te = (BrokenLeavesBlockEntity)tile;
        BlockState replacedLeaves = te.getReplacedLeaves();
        if (replacedLeaves != null) {
            if (world.m_45752_(replacedLeaves, pos, CollisionContext.m_82749_())) {
                world.m_46597_(pos, replacedLeaves);
            }
        } else {
            world.m_46961_(pos, false);
        }
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return true;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.m_213898_(state, world, pos, random);
        if (!world.m_276867_(pos) && random.m_188501_() > Config.collision.leave_breaking.regrow_chance) {
            this.tryRestoreBrokenLeaves(world, pos);
        }
    }

    public static Optional<BlockState> getStoredBlockState(BlockAndTintGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof BrokenLeavesBlockEntity)) {
            return Optional.empty();
        }
        BrokenLeavesBlockEntity te = (BrokenLeavesBlockEntity)tile;
        BlockState replacedLeaves = te.getReplacedLeaves();
        return replacedLeaves != null ? Optional.of(replacedLeaves) : Optional.empty();
    }
}

