/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.block;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.block.BrokenLeavesBlockModel;
import endorh.aerobaticelytra.common.block.BrokenLeavesBlock;
import endorh.lazulib.common.ForgeUtil;
import java.util.Map;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticBlocks {
    @ObjectHolder(value="aerobaticelytra:broken_leaves", registryName="block")
    public static Block BROKEN_LEAVES = (Block)ForgeUtil.futureNotNull();
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onRegisterBlocks(RegisterEvent event) {
        event.register(ForgeRegistries.BLOCKS.getRegistryKey(), r -> {
            r.register(BrokenLeavesBlock.ID, (Object)new BrokenLeavesBlock());
            AerobaticElytra.logRegistered("Blocks");
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map reg = event.getModels();
        for (BlockState bs : BROKEN_LEAVES.m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)bs);
            BakedModel existingModel = (BakedModel)reg.get(variantMRL);
            if (existingModel == null) {
                throw new IllegalStateException("Missing fallback model for Broken Leaves block");
            }
            if (existingModel instanceof BrokenLeavesBlockModel) {
                LOGGER.warn("Tried to replace BrokenLeavesBlockBakedModel twice");
                continue;
            }
            BrokenLeavesBlockModel customModel = new BrokenLeavesBlockModel(existingModel);
            reg.put(variantMRL, customModel);
        }
    }
}

