/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.integration.colytra.ColytraIntegration;
import endorh.aerobaticelytra.integration.curios.CuriosIntegration;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class AerobaticElytraLogic {
    public static boolean hasAerobaticElytra(Player player) {
        return !AerobaticElytraLogic.getAerobaticElytra((LivingEntity)player).m_41619_();
    }

    public static boolean isAerobaticElytra(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof AerobaticElytraItem || !ColytraIntegration.getColytraSubItem(stack).m_41619_());
    }

    public static boolean isRemoteLocalPlayer(Player player) {
        if (!player.m_9236_().f_46443_) {
            return false;
        }
        return player instanceof RemotePlayer;
    }

    public static boolean isLocalPlayer(Player player) {
        if (!player.m_9236_().f_46443_) {
            return false;
        }
        return player instanceof LocalPlayer;
    }

    public static ItemStack getAerobaticElytra(LivingEntity entity) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack elytra = ItemStack.f_41583_;
        if (chest.m_41720_() instanceof AerobaticElytraItem) {
            return chest;
        }
        if (chest.m_41720_() instanceof ArmorItem && AerobaticElytra.caelusLoaded && (elytra = ColytraIntegration.getColytraSubItem(chest)) != ItemStack.f_41583_) {
            return elytra;
        }
        if (AerobaticElytra.curiosLoaded) {
            elytra = CuriosIntegration.getCurioAerobaticElytra(entity);
        }
        return elytra;
    }

    public static LazyOptional<IElytraSpec> getElytraSpec(LivingEntity entity) {
        return ElytraSpecCapability.getElytraSpec(AerobaticElytraLogic.getAerobaticElytra(entity));
    }

    public static IElytraSpec getElytraSpecOrDefault(LivingEntity entity) {
        return ElytraSpecCapability.getElytraSpecOrDefault(AerobaticElytraLogic.getAerobaticElytra(entity));
    }
}

