/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.client.item.AerobaticElytraBannerTextureManager;
import endorh.aerobaticelytra.client.item.AerobaticElytraItemColor;
import endorh.aerobaticelytra.client.item.AerobaticElytraWingItemColor;
import endorh.aerobaticelytra.client.item.AerobaticItemProperties;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import endorh.aerobaticelytra.integration.caelus.CaelusIntegration;
import endorh.aerobaticelytra.integration.colytra.ClientColytraIntegration;
import endorh.aerobaticelytra.integration.colytra.ColytraIntegration;
import endorh.aerobaticelytra.integration.curios.CuriosIntegration;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticElytraInit {
    public static void setup() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AerobaticRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        Config.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientConfig::register);
        AerobaticElytra.logRegistered("Config");
        AerobaticElytraInit.registerIntegrations();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(AerobaticElytraInit::registerClient);
    }

    public static void registerClient() {
        AerobaticElytraItemColor.register((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
        AerobaticElytraWingItemColor.register((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA_WING);
        AerobaticElytra.logRegistered("Item Colors");
        AerobaticItemProperties.register();
        AerobaticElytra.logRegistered("Item Properties");
    }

    public static void registerIntegrations() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        if (AerobaticElytra.caelusLoaded && AerobaticElytra.colytraLoaded) {
            eventBus.register(ColytraIntegration.class);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                eventBus.register(ClientColytraIntegration.class);
            }
        }
        if (AerobaticElytra.curiosLoaded) {
            eventBus.register(CuriosIntegration.class);
            if (AerobaticElytra.caelusLoaded) {
                eventBus.register(CaelusIntegration.class);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="aerobaticelytra")
    public static class GameEventRegistrar {
        @SubscribeEvent
        public static void onRegisterReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)AerobaticElytra.JSON_ABILITY_MANAGER);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
    @OnlyIn(value=Dist.CLIENT)
    public static class ClientRegistrar {
        @SubscribeEvent
        public static void onMinecraftConstructed(RegisterParticleProvidersEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            AerobaticElytra.BANNER_TEXTURE_MANAGER = new AerobaticElytraBannerTextureManager(mc.m_91097_());
            ResourceManager resourceManager = mc.m_91098_();
            if (resourceManager instanceof ReloadableResourceManager) {
                ReloadableResourceManager rm = (ReloadableResourceManager)resourceManager;
                rm.m_7217_((PreparableReloadListener)AerobaticElytra.BANNER_TEXTURE_MANAGER);
            }
        }
    }
}

