/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.trail;

import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.lazulib.math.Vec3d;
import endorh.lazulib.math.Vec3f;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public abstract class BoostShape {
    public abstract void generate(LivingEntity var1, Vec3d var2, Vec3f var3, VectorBase var4, IElytraSpec.RocketStar var5, float var6, float var7);

    public static class BurstBoostShape
    extends BoostShape {
        private static final Vec3f direction = (Vec3f)Vec3f.ZERO.get();
        public float radius;
        public int points;

        public BurstBoostShape(float radius, int points) {
            this.radius = radius;
            this.points = points;
        }

        @Override
        public void generate(LivingEntity player, Vec3d pos, Vec3f motion, VectorBase base, IElytraSpec.RocketStar explosion, float radius, float trailMod) {
            float rad = this.radius * radius;
            for (int i = 0; i < this.points; ++i) {
                direction.setRandomSpherical();
                BurstBoostShape.direction.z *= 0.5f;
                direction.mul(rad);
                AerobaticTrail.createBoostParticle(player, explosion, pos, base, motion, BurstBoostShape.direction.x, BurstBoostShape.direction.y, BurstBoostShape.direction.z, 0.0f, trailMod);
            }
        }
    }

    public static class ShapedBoostShape
    extends BoostShape {
        public float[][] shape;
        public int points;
        public int passes;
        public float radius;
        public boolean mirror;
        public float noise;

        public ShapedBoostShape(float[][] shape, int points, int passes, float radius, boolean mirror, float noise) {
            this.shape = shape;
            this.points = points;
            this.passes = passes;
            this.mirror = mirror;
            this.radius = radius;
            this.noise = noise;
        }

        @Override
        public void generate(LivingEntity player, Vec3d pos, Vec3f motion, VectorBase base, IElytraSpec.RocketStar explosion, float radius, float trailMod) {
            float rad = this.radius * radius;
            for (int i = 0; i < this.passes; ++i) {
                float x_s = this.shape[0][0] * rad;
                float y_s = this.shape[0][1] * rad;
                AerobaticTrail.createBoostParticle(player, explosion, pos, base, motion, x_s, y_s, 0.0f, this.noise, trailMod);
                for (int j = 1; j < this.shape.length; ++j) {
                    float x_e = this.shape[j][0] * rad;
                    float y_e = this.shape[j][1] * rad;
                    for (int k = 1; k < this.points; ++k) {
                        float p = (float)k / (float)this.points;
                        float x = Mth.m_14179_((float)p, (float)x_e, (float)x_s);
                        float y = Mth.m_14179_((float)p, (float)y_e, (float)y_s);
                        AerobaticTrail.createBoostParticle(player, explosion, pos, base, motion, x, y, 0.0f, this.noise, trailMod);
                        if (!this.mirror) continue;
                        AerobaticTrail.createBoostParticle(player, explosion, pos, base, motion, -x, y, 0.0f, this.noise, trailMod);
                    }
                    x_s = x_e;
                    y_s = y_e;
                }
            }
        }
    }

    public static class CircleBoostShape
    extends BoostShape {
        public float radius;
        public int points;
        public int passes;
        public float noise;

        public CircleBoostShape(float radius, int points, int passes, float noise) {
            this.radius = radius;
            this.points = points;
            this.passes = passes;
            this.noise = noise;
        }

        @Override
        public void generate(LivingEntity player, Vec3d pos, Vec3f motion, VectorBase base, IElytraSpec.RocketStar explosion, float radius, float trailMod) {
            float rad = this.radius * radius;
            for (int i = 0; i < this.passes; ++i) {
                for (int j = 0; j < this.points; ++j) {
                    float x = Mth.m_14089_((float)((float)j * (float)Math.PI * 2.0f / (float)this.points)) * rad;
                    float y = Mth.m_14031_((float)((float)j * (float)Math.PI * 2.0f / (float)this.points)) * rad;
                    AerobaticTrail.createBoostParticle(player, explosion, pos, base, motion, x, y, 0.0f, this.noise, trailMod);
                }
                rad *= 0.9f;
            }
        }
    }
}

