/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.trail;

import endorh.aerobaticelytra.client.trail.BoostShape;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.particle.TrailParticleData;
import endorh.aerobaticelytra.debug.Debug;
import endorh.lazulib.math.Vec3d;
import endorh.lazulib.math.Vec3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AerobaticTrail {
    public static final Map<Byte, BoostShape> SHAPES = new HashMap<Byte, BoostShape>();
    private static final Random random;
    private static final Vec3d rocketLeft;
    private static final Vec3d rocketRight;
    private static final Vec3d rocketCenterLeft;
    private static final Vec3d rocketCenterRight;
    private static final Vec3d rocketLeftTarget;
    private static final Vec3d rocketRightTarget;
    private static final Vec3d rocketCenterLeftTarget;
    private static final Vec3d rocketCenterRightTarget;
    private static final Vec3d pos;
    private static final Vec3f motion;
    private static final Vec3f particleMotion;
    private static final VectorBase base;
    private static final VectorBase prevBase;
    public static final TrailParticleData DEFAULT_BOOST_PARTICLE;
    public static final TrailParticleData UNDERWATER_BOOST_PARTICLE;
    private static final Vec3f off;

    public static void addParticles(Player player, Vec3f motionVec, Vec3f prevMotionVec) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        base.set(data.getCameraBase());
        prevBase.update(data.getPrevTickRotationYaw(), data.getPrevTickRotationPitch(), data.getPrevTickRotationRoll());
        float tiltYaw = data.getTiltYaw();
        float tiltPitch = data.getTiltPitch();
        float tiltRoll = data.getTiltRoll();
        pos.set(player.m_20182_());
        Vec3d lastPos = data.getLastTrailPos();
        if (lastPos.normSquared() < 0.2) {
            lastPos.set(pos);
            return;
        }
        rocketLeft.set(lastPos);
        rocketRight.set(lastPos);
        rocketCenterLeft.set(lastPos);
        rocketCenterRight.set(lastPos);
        if (player.m_20069_()) {
            pos.sub(AerobaticTrail.base.look, 1.5);
            if (data.getPropulsionStrength() == 0.0f) {
                return;
            }
        }
        rocketLeftTarget.set(pos);
        rocketRightTarget.set(pos);
        rocketCenterLeftTarget.set(pos);
        rocketCenterRightTarget.set(pos);
        lastPos.set(pos);
        prevBase.tilt(tiltYaw, tiltPitch, tiltRoll);
        base.tilt(tiltYaw, tiltPitch, tiltRoll);
        prevBase.offset(rocketLeft, rocketRight, rocketCenterLeft, rocketCenterRight);
        base.offset(rocketLeftTarget, rocketRightTarget, rocketCenterLeftTarget, rocketCenterRightTarget);
        AerobaticTrail.base.normal.unitary();
        AerobaticTrail.base.roll.unitary();
        motionVec.mul(-1.0f);
        prevMotionVec.mul(-1.0f);
        particleMotion.set(prevMotionVec);
        int c = 5;
        float s = 0.2f;
        boolean ownPlayer = Minecraft.m_91087_().f_91074_ == player;
        Vec3f roll = AerobaticTrail.base.roll;
        ItemStack elytra = AerobaticElytraLogic.getAerobaticElytra((LivingEntity)player);
        for (int i = 0; i < 5; ++i) {
            float t = (float)i * 0.2f;
            float l = 0.2f / (1.0f - t);
            rocketLeft.lerp(rocketLeftTarget, (double)l);
            rocketRight.lerp(rocketRightTarget, (double)l);
            rocketCenterLeft.lerp(rocketCenterLeftTarget, (double)l);
            rocketCenterRight.lerp(rocketCenterRightTarget, (double)l);
            particleMotion.set(prevMotionVec);
            particleMotion.lerp(motionVec, t);
            boolean isFreeze = AerobaticElytraWingItem.hasDebugWing(player) != Debug.DEBUG.invertFreeze;
            particleMotion.mul(isFreeze ? Debug.DEBUG.freezeParticleSpeed : Debug.DEBUG.particleSpeed);
            AerobaticTrail.getTrailParticle(player, RocketSide.RIGHT, elytra, i, t, ownPlayer, roll).ifPresent(particle -> {
                float[] off = AerobaticTrail.getTransversalOffset(particle.type);
                player.m_9236_().m_7106_((ParticleOptions)particle, AerobaticTrail.rocketRight.x, AerobaticTrail.rocketRight.y, AerobaticTrail.rocketRight.z, (double)(AerobaticTrail.particleMotion.x + AerobaticTrail.base.normal.x * off[0] + AerobaticTrail.base.roll.x * off[1]), (double)(AerobaticTrail.particleMotion.y + AerobaticTrail.base.normal.y * off[0] + AerobaticTrail.base.roll.y * off[1]), (double)(AerobaticTrail.particleMotion.z + AerobaticTrail.base.normal.z * off[0] + AerobaticTrail.base.roll.z * off[1]));
            });
            AerobaticTrail.getTrailParticle(player, RocketSide.LEFT, elytra, i, t, ownPlayer, roll).ifPresent(particle -> {
                float[] off = AerobaticTrail.getTransversalOffset(particle.type);
                player.m_9236_().m_7106_((ParticleOptions)particle, AerobaticTrail.rocketLeft.x, AerobaticTrail.rocketLeft.y, AerobaticTrail.rocketLeft.z, (double)(AerobaticTrail.particleMotion.x + AerobaticTrail.base.normal.x * off[0] + AerobaticTrail.base.roll.x * off[1]), (double)(AerobaticTrail.particleMotion.y + AerobaticTrail.base.normal.y * off[0] + AerobaticTrail.base.roll.y * off[1]), (double)(AerobaticTrail.particleMotion.z + AerobaticTrail.base.normal.z * off[0] + AerobaticTrail.base.roll.z * off[1]));
            });
            AerobaticTrail.getTrailParticle(player, RocketSide.CENTER_RIGHT, elytra, i, t, ownPlayer, roll).ifPresent(particle -> {
                float[] off = AerobaticTrail.getTransversalOffset(particle.type);
                player.m_9236_().m_7106_((ParticleOptions)particle, AerobaticTrail.rocketCenterRight.x, AerobaticTrail.rocketCenterRight.y, AerobaticTrail.rocketCenterRight.z, (double)(AerobaticTrail.particleMotion.x + AerobaticTrail.base.normal.x * off[0] + AerobaticTrail.base.roll.x * off[1]), (double)(AerobaticTrail.particleMotion.y + AerobaticTrail.base.normal.y * off[0] + AerobaticTrail.base.roll.y * off[1]), (double)(AerobaticTrail.particleMotion.z + AerobaticTrail.base.normal.z * off[0] + AerobaticTrail.base.roll.z * off[1]));
            });
            AerobaticTrail.getTrailParticle(player, RocketSide.CENTER_LEFT, elytra, i, t, ownPlayer, roll).ifPresent(particle -> {
                float[] off = AerobaticTrail.getTransversalOffset(particle.type);
                player.m_9236_().m_7106_((ParticleOptions)particle, AerobaticTrail.rocketCenterLeft.x, AerobaticTrail.rocketCenterLeft.y, AerobaticTrail.rocketCenterLeft.z, (double)(AerobaticTrail.particleMotion.x + AerobaticTrail.base.normal.x * off[0] + AerobaticTrail.base.roll.x * off[1]), (double)(AerobaticTrail.particleMotion.y + AerobaticTrail.base.normal.y * off[0] + AerobaticTrail.base.roll.y * off[1]), (double)(AerobaticTrail.particleMotion.z + AerobaticTrail.base.normal.z * off[0] + AerobaticTrail.base.roll.z * off[1]));
            });
        }
    }

    public static Optional<TrailParticleData> getTrailParticle(Player player, RocketSide side, ItemStack elytra, int partial, float partialTick, boolean ownPlayer, Vec3f rollVec) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        IElytraSpec.TrailData data = spec.getTrailData();
        if (player.m_20069_()) {
            return AerobaticTrail.shouldGenerate((byte)5, partial) ? Optional.of(new TrailParticleData(Color.WHITE, Color.LIGHT_GRAY, 5, false, false, 35, 0.16f, partialTick, ownPlayer, rollVec, side, data)) : Optional.empty();
        }
        Optional<IElytraSpec.RocketStar> explosionOpt = AerobaticTrail.pickRandom(data.get(side));
        if (explosionOpt.isEmpty()) {
            return AerobaticTrail.shouldGenerate((byte)0, partial) ? Optional.of(new TrailParticleData(Color.WHITE, Color.WHITE, 0, false, false, 25, 0.2f, partialTick, ownPlayer, rollVec, side, data)) : Optional.empty();
        }
        IElytraSpec.RocketStar explosion = explosionOpt.get();
        Color color = new Color(AerobaticTrail.pickRandom(explosion.colors).orElse(Color.WHITE.getRGB()));
        Color fadeColor = new Color(AerobaticTrail.pickRandom(explosion.fadeColors).orElse(color.getRGB()));
        int life = Math.round((float)AerobaticTrail.getLife(explosion.type, explosion.trail) * spec.getAbility(IAbility.Ability.TRAIL));
        float size = Mth.m_144920_((float)0.4f, (float)0.5f, (float)spec.getAbility(IAbility.Ability.TRAIL));
        return AerobaticTrail.shouldGenerate(explosion.type, partial) ? Optional.of(new TrailParticleData(color, fadeColor, explosion.type, explosion.flicker, explosion.trail, life, size, partialTick, ownPlayer, rollVec, side, data)) : Optional.empty();
    }

    public static void addBoostParticles(Player player) {
        Optional<IElytraSpec.RocketStar> explosionOpt;
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        IElytraSpec spec = AerobaticElytraLogic.getElytraSpecOrDefault((LivingEntity)player);
        pos.set(player.m_20182_());
        motion.set(player.m_20184_());
        particleMotion.set(motion);
        particleMotion.mul(0.1f);
        base.update(data.getRotationYaw(), data.getRotationPitch(), data.getRotationRoll());
        IElytraSpec.TrailData trail = spec.getTrailData();
        float trailModifier = spec.getAbility(IAbility.Ability.TRAIL);
        Optional<IElytraSpec.RocketStar[]> listOpt = trail.pickRandom();
        IElytraSpec.RocketStar explosion = null;
        if (listOpt.isPresent() && (explosionOpt = AerobaticTrail.pickRandom(listOpt.get())).isPresent()) {
            explosion = explosionOpt.get();
        }
        byte shape = explosion == null ? (byte)0 : explosion.type;
        BoostShape boostShape = SHAPES.get(shape);
        if (explosion != null && explosion.trail) {
            float radius = 1.2f;
            int halos = 3;
            pos.sub(motion, (double)halos);
            particleMotion.sub(motion, 0.05f);
            for (int i = 0; i < halos; ++i) {
                boostShape.generate((LivingEntity)player, pos, particleMotion, base, explosion, radius, trailModifier);
                if (i >= halos - 1) continue;
                pos.add(motion);
                particleMotion.add(motion, 0.05f);
                radius *= 0.8f;
            }
        } else {
            boostShape.generate((LivingEntity)player, pos, particleMotion, base, explosion, 1.0f, trailModifier);
        }
    }

    public static TrailParticleData getBoostParticle(LivingEntity player, IElytraSpec.RocketStar explosion, float trailMod) {
        if (player.m_20069_()) {
            return UNDERWATER_BOOST_PARTICLE;
        }
        if (explosion == null) {
            return DEFAULT_BOOST_PARTICLE;
        }
        Color color = new Color(AerobaticTrail.pickRandom(explosion.colors).orElse(Color.WHITE.getRGB()));
        Color fadeColor = new Color(AerobaticTrail.pickRandom(explosion.fadeColors).orElse(color.getRGB()));
        int life = Math.round((float)AerobaticTrail.getLife(explosion.type, explosion.trail) * trailMod * 0.6f);
        float size = Mth.m_144920_((float)0.4f, (float)0.5f, (float)trailMod);
        return new TrailParticleData(color, fadeColor, explosion.type, explosion.flicker, false, life, size, 0.0f, false, null, null, null);
    }

    public static void createBoostParticle(LivingEntity player, IElytraSpec.RocketStar explosion, Vec3d pos, VectorBase base, Vec3f motion, float x, float y, float z, float noise, float trailMod) {
        TrailParticleData data = AerobaticTrail.getBoostParticle(player, explosion, trailMod);
        if (data == null) {
            return;
        }
        off.set(base.roll);
        off.mul(x);
        off.add(base.normal, y);
        if (z != 0.0f) {
            off.add(base.look, z);
        }
        if (noise > 0.0f) {
            off.add(base.roll, (float)random.nextGaussian() * noise * Math.max(0.2f, x));
            off.add(base.normal, (float)random.nextGaussian() * noise * Math.max(0.2f, y));
            off.add(base.look, (float)random.nextGaussian() * noise * Math.max(0.2f, z));
        }
        player.m_9236_().m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, (double)(motion.x + AerobaticTrail.off.x), (double)(motion.y + AerobaticTrail.off.y), (double)(motion.z + AerobaticTrail.off.z));
    }

    public static boolean shouldGenerate(byte type, int partial) {
        return type != 5 || partial == 0;
    }

    public static int getLife(byte type, boolean trail) {
        int life;
        int n = life = type == 1 ? 180 : 120;
        if (trail) {
            life = Math.round((float)life * 0.6f);
        }
        return life;
    }

    public static float[] getTransversalOffset(byte type) {
        float[] fArray;
        switch (type) {
            case 5: {
                float[] fArray2 = new float[2];
                fArray2[0] = (float)random.nextGaussian() * 0.025f;
                fArray = fArray2;
                fArray2[1] = (float)random.nextGaussian() * 0.025f;
                break;
            }
            case 4: {
                float[] fArray3 = new float[2];
                fArray3[0] = (float)random.nextGaussian() * 0.05f;
                fArray = fArray3;
                fArray3[1] = (float)random.nextGaussian() * 0.05f;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray4 = new float[2];
                fArray4[0] = (float)random.nextGaussian() * 0.002f;
                fArray = fArray4;
                fArray4[1] = (float)random.nextGaussian() * 0.002f;
                break;
            }
            default: {
                float[] fArray5 = new float[2];
                fArray5[0] = 0.0f;
                fArray = fArray5;
                fArray5[1] = 0.0f;
            }
        }
        return fArray;
    }

    private static Optional<Integer> pickRandom(int[] array) {
        if (array == null || array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[random.nextInt(array.length)]);
    }

    private static <T> Optional<T> pickRandom(T[] array) {
        if (array == null || array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[random.nextInt(array.length)]);
    }

    static {
        SHAPES.put((byte)0, new BoostShape.CircleBoostShape(0.2f, 50, 2, 0.04f));
        SHAPES.put((byte)1, new BoostShape.CircleBoostShape(0.3f, 60, 3, 0.05f));
        SHAPES.put((byte)2, new BoostShape.ShapedBoostShape(new float[][]{{0.0f, 1.0f}, {0.3455f, 0.309f}, {0.9511f, 0.309f}, {0.3795918f, -0.1265306f}, {0.6122449f, -0.8040816f}, {0.0f, -0.3591837f}}, 5, 3, 0.35f, true, 0.03f));
        SHAPES.put((byte)3, new BoostShape.ShapedBoostShape(new float[][]{{0.0f, 0.2f}, {0.2f, 0.2f}, {0.2f, 0.6f}, {0.6f, 0.6f}, {0.6f, 0.2f}, {0.2f, 0.2f}, {0.2f, 0.0f}, {0.4f, 0.0f}, {0.4f, -0.6f}, {0.2f, -0.6f}, {0.2f, -0.4f}, {0.0f, -0.4f}}, 4, 3, 0.45f, true, 0.025f));
        SHAPES.put((byte)4, new BoostShape.BurstBoostShape(0.4f, 70));
        random = new Random();
        rocketLeft = (Vec3d)Vec3d.ZERO.get();
        rocketRight = (Vec3d)Vec3d.ZERO.get();
        rocketCenterLeft = (Vec3d)Vec3d.ZERO.get();
        rocketCenterRight = (Vec3d)Vec3d.ZERO.get();
        rocketLeftTarget = (Vec3d)Vec3d.ZERO.get();
        rocketRightTarget = (Vec3d)Vec3d.ZERO.get();
        rocketCenterLeftTarget = (Vec3d)Vec3d.ZERO.get();
        rocketCenterRightTarget = (Vec3d)Vec3d.ZERO.get();
        pos = (Vec3d)Vec3d.ZERO.get();
        motion = (Vec3f)Vec3f.ZERO.get();
        particleMotion = (Vec3f)Vec3f.ZERO.get();
        base = new VectorBase();
        prevBase = new VectorBase();
        DEFAULT_BOOST_PARTICLE = new TrailParticleData(Color.WHITE, Color.WHITE, 0, false, false, 35, 0.3f, 0.0f, false, null, null, null);
        UNDERWATER_BOOST_PARTICLE = new TrailParticleData(Color.WHITE, Color.LIGHT_GRAY, 5, false, false, 35, 0.16f, 0.0f, false, null, null, null);
        off = (Vec3f)Vec3f.ZERO.get();
    }

    public static enum RocketSide {
        LEFT("Left", "aerobaticelytra.side.left", ElytraDyement.WingSide.LEFT),
        RIGHT("Right", "aerobaticelytra.side.right", ElytraDyement.WingSide.RIGHT),
        CENTER_LEFT("CenterLeft", "aerobaticelytra.side.center_left", ElytraDyement.WingSide.LEFT),
        CENTER_RIGHT("CenterRight", "aerobaticelytra.side.center_right", ElytraDyement.WingSide.RIGHT);

        public final String tagName;
        public final String translationKey;
        public final ElytraDyement.WingSide wingSide;
        private static final Map<ElytraDyement.WingSide, RocketSide[]> wingSideMap;

        private RocketSide(String tagName, String translationKey, ElytraDyement.WingSide wingSide) {
            this.tagName = tagName;
            this.translationKey = translationKey;
            this.wingSide = wingSide;
        }

        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)this.translationKey);
        }

        public RocketSide opposite() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LEFT -> RIGHT;
                case RIGHT -> LEFT;
                case CENTER_LEFT -> CENTER_RIGHT;
                case CENTER_RIGHT -> CENTER_LEFT;
            };
        }

        public static RocketSide[] forWingSide(ElytraDyement.WingSide side) {
            if (side == null) {
                return RocketSide.values();
            }
            return wingSideMap.getOrDefault((Object)side, new RocketSide[0]);
        }

        static {
            wingSideMap = new HashMap<ElytraDyement.WingSide, RocketSide[]>();
            HashMap listMap = new HashMap();
            for (RocketSide side : RocketSide.values()) {
                if (!listMap.containsKey((Object)side.wingSide)) {
                    listMap.put(side.wingSide, new ArrayList());
                }
                ((List)listMap.get((Object)side.wingSide)).add(side);
            }
            for (Map.Entry entry : listMap.entrySet()) {
                wingSideMap.put((ElytraDyement.WingSide)((Object)entry.getKey()), (RocketSide[])((List)entry.getValue()).stream().toArray(RocketSide[]::new));
            }
        }
    }
}

