/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.sound;

import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.debug.DebugOverlay;
import endorh.lazulib.sound.AudioUtil;
import endorh.lazulib.sound.PlayerTickableSound;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FadingTickableSound
extends PlayerTickableSound {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final IFlightData flightData;
    protected int fadeIn;
    protected int fadeOut;
    protected final ResourceLocation type;
    protected int age = 0;
    private int remainingMinimum;
    private boolean fading_out;
    private int animation = 0;

    public FadingTickableSound(Player player, SoundEvent sound2, SoundSource category) {
        this(player, sound2, category, 8, 8, 0);
    }

    public FadingTickableSound(Player player, SoundEvent sound2, SoundSource category, int fadeIn, int fadeOut, int minimumLength) {
        this(player, sound2, category, fadeIn, fadeOut, minimumLength, null);
    }

    public FadingTickableSound(Player player, SoundEvent sound2, SoundSource category, int fadeIn, int fadeOut, int minimumLength, @Nullable PlayerTickableSound.IAttenuation attenuation) {
        this(player, sound2, category, fadeIn, fadeOut, minimumLength, attenuation, ForgeRegistries.SOUND_EVENTS.getKey((Object)sound2));
    }

    public FadingTickableSound(Player player, SoundEvent sound2, SoundSource category, int fadeIn, int fadeOut, int minimumLength, @Nullable PlayerTickableSound.IAttenuation attenuation, ResourceLocation type) {
        super(player, sound2, category, attenuation);
        this.flightData = FlightDataCapability.getFlightDataOrDefault(player);
        this.fadeIn = fadeIn;
        this.fadeOut = fadeOut;
        this.type = type;
        this.remainingMinimum = minimumLength;
        this.f_119573_ = 0.0f;
        this.f_119574_ = 1.0f;
    }

    public void recover() {
        this.fading_out = false;
        this.animation = Math.round((float)this.animation / (float)this.fadeOut * (float)this.fadeIn);
    }

    public void fadeOut() {
        if (this.fading_out) {
            return;
        }
        this.fading_out = true;
        this.animation = Math.round((float)this.animation / (float)this.fadeIn * (float)this.fadeOut);
        this.onFadeOut();
    }

    protected boolean isFadingOut() {
        return this.fading_out;
    }

    protected void onStart() {
    }

    protected void onFadeOut() {
    }

    protected void onFinish() {
    }

    public void play() {
        FadingTickableSound sound2 = this.flightData.getFlightSound(this.type);
        if (sound2 != null) {
            sound2.recover();
            this.m_119609_();
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this);
            this.flightData.putFlightSound(this.type, this);
            this.onStart();
        }
    }

    public final void m_7788_() {
        super.m_7788_();
        if (this.animation < 0) {
            return;
        }
        ++this.age;
        --this.remainingMinimum;
        DebugOverlay.animation = this.animation;
        float fade_factor = 1.0f;
        if (!this.player.m_6084_() || this.shouldFadeOut()) {
            this.fadeOut();
        }
        if (this.fading_out) {
            if (this.remainingMinimum < this.fadeOut) {
                fade_factor = AudioUtil.fadeOutExp((float)((float)(this.fadeOut - --this.animation) / (float)this.fadeOut));
            }
            this.tick(fade_factor);
            if (this.animation <= 0) {
                this.onFinish();
                this.m_119609_();
                this.animation = -1;
                this.f_119573_ = 0.0f;
                if (this.flightData.getFlightSound(this.type) == this) {
                    this.flightData.putFlightSound(this.type, null);
                }
            }
        } else {
            if (this.animation < this.fadeIn) {
                fade_factor = AudioUtil.fadeInExp((float)((float)(++this.animation) / (float)this.fadeIn));
            }
            this.tick(fade_factor);
        }
        DebugOverlay.sound = this.f_119573_;
    }

    public abstract void tick(float var1);

    public boolean shouldFadeOut() {
        return false;
    }
}

