/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.sound;

import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.client.sound.AerobaticSounds;
import endorh.aerobaticelytra.client.sound.FadingTickableSound;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.lazulib.common.LogUtil;
import endorh.lazulib.common.ObfuscationReflectionUtil;
import endorh.lazulib.sound.PlayerTickableSound;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class AerobaticElytraSound
extends FadingTickableSound {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IAerobaticData aerobaticData;
    protected static final int FADE_IN = 15;
    protected static final int FADE_OUT = 8;
    protected static final int MIN_LEN = 20;
    protected static final PlayerTickableSound.IAttenuation ATTENUATION = PlayerTickableSound.IAttenuation.linear((float)64.0f);
    private static final SoundSource CATEGORY = SoundSource.PLAYERS;
    private static final String REFLECTION_ERROR_MESSAGE = "Aerobatic Elytra sound may not play properly";
    private static final ObfuscationReflectionUtil.SoftField<ElytraOnPlayerSoundInstance, Player> elytraSound$player = ObfuscationReflectionUtil.getSoftField(ElytraOnPlayerSoundInstance.class, (String)"f_119670_", (String)"player", (Consumer)LogUtil.oneTimeLogger(arg_0 -> ((Logger)LOGGER).error(arg_0)), (String)"Aerobatic Elytra sound may not play properly");
    private static final ObfuscationReflectionUtil.SoftMethod<AbstractTickableSoundInstance, Void> tickableSound$stop = ObfuscationReflectionUtil.getSoftMethod(AbstractTickableSoundInstance.class, (String)"m_119609_", (String)"stop", (Consumer)LogUtil.oneTimeLogger(arg_0 -> ((Logger)LOGGER).error(arg_0)), (String)"Aerobatic Elytra sound may not play properly", (Class[])new Class[0]);
    protected float brakeVolume = 0.0f;
    protected float brakePitch = 1.0f;
    protected float rotateVolume = 0.0f;
    protected float rotatePitch = 1.0f;
    protected float whistleVolume = 0.0f;
    protected float whistlePitch = 1.0f;
    private final PlayerTickableSound.PlayerTickableSubSound brakeSound;
    private final PlayerTickableSound.PlayerTickableSubSound rotateSound;
    private final PlayerTickableSound.PlayerTickableSubSound whistleSound;

    public static void playBoostSound(Player player) {
        AerobaticElytraSound.playPlayerSound(player, AerobaticSounds.AEROBATIC_ELYTRA_BOOST, SoundSource.PLAYERS, ClientConfig.sound.boost, 1.0f);
    }

    public static void playSlowDownSound(Player player) {
        AerobaticElytraSound.playPlayerSound(player, AerobaticSounds.AEROBATIC_ELYTRA_SLOWDOWN, SoundSource.PLAYERS, ClientConfig.sound.boost, 1.0f);
    }

    public static void playPlayerSound(Player player, SoundEvent sound2, SoundSource category, float volume, float pitch) {
        if (!player.m_9236_().f_46443_) {
            return;
        }
        Vec3 position = player.m_20182_();
        if (player instanceof RemotePlayer) {
            LocalPlayer client = Minecraft.m_91087_().f_91074_;
            if (client == null) {
                return;
            }
            Vec3 clientPos = client.m_20182_();
            volume = ATTENUATION.attenuate(volume, (float)position.m_82554_(clientPos));
            position = clientPos;
        }
        player.m_9236_().m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, sound2, category, volume, pitch, false);
    }

    public AerobaticElytraSound(Player player) {
        super(player, AerobaticSounds.AEROBATIC_ELYTRA_FLIGHT, CATEGORY, 15, 8, 20, ATTENUATION);
        this.aerobaticData = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        this.brakeSound = new PlayerTickableSound.PlayerTickableSubSound(player, AerobaticSounds.AEROBATIC_ELYTRA_BRAKE, CATEGORY, ATTENUATION);
        this.rotateSound = new PlayerTickableSound.PlayerTickableSubSound(player, AerobaticSounds.AEROBATIC_ELYTRA_ROTATE, CATEGORY, ATTENUATION);
        this.whistleSound = new PlayerTickableSound.PlayerTickableSubSound(player, AerobaticSounds.AEROBATIC_ELYTRA_WHISTLE, CATEGORY, ATTENUATION);
    }

    @Override
    public boolean shouldFadeOut() {
        return !this.player.m_21255_();
    }

    @Override
    protected void onStart() {
        ElytraOnPlayerSoundInstance elytraSound = this.aerobaticData.getElytraSound();
        if (elytraSound != null && !elytraSound.m_7801_()) {
            if (tickableSound$stop.testInvoke((Object)elytraSound, new Object[0])) {
                this.aerobaticData.setElytraSound(null);
                this.brakeSound.play();
                this.rotateSound.play();
                this.whistleSound.play();
            } else {
                this.m_119609_();
            }
        }
    }

    @Override
    protected void onFinish() {
        this.brakeSound.finish();
        this.rotateSound.finish();
        this.whistleSound.finish();
    }

    @Override
    protected void onFadeOut() {
        this.aerobaticData.setPlayingSound(false);
    }

    @Override
    public void tick(float fade_factor) {
        if (AerobaticElytraLogic.hasAerobaticElytra(this.player) && this.flightData.getFlightMode().is(FlightModeTags.AEROBATIC)) {
            if (this.player.m_20069_()) {
                this.aerobaticUnderwaterTick(fade_factor);
            } else {
                this.aerobaticElytraTick(fade_factor);
            }
        } else {
            this.whistleVolume = 0.0f;
            this.rotateVolume = 0.0f;
            this.brakeVolume = 0.0f;
            this.whistlePitch = 1.0f;
            this.rotatePitch = 1.0f;
            this.brakePitch = 1.0f;
            if (this.player.m_20069_()) {
                this.elytraUnderwaterTick(fade_factor);
            } else {
                this.elytraTick(fade_factor);
            }
        }
        this.brakeSound.setVolume(this.brakeVolume * ClientConfig.sound.brake);
        this.brakeSound.setPitch(this.brakePitch);
        this.rotateSound.setVolume(this.rotateVolume * ClientConfig.sound.rotating_wind);
        this.rotateSound.setPitch(this.rotatePitch);
        this.whistleSound.setVolume(this.whistleVolume * ClientConfig.sound.whistle);
        this.whistleSound.setPitch(this.whistlePitch);
    }

    public void aerobaticElytraTick(float fade_factor) {
        float speed = (float)this.player.m_20184_().m_82553_();
        float pitchTilt = Math.abs(this.aerobaticData.getTiltPitch() / Config.aerobatic.tilt.range_pitch);
        float rollTilt = Math.abs(this.aerobaticData.getTiltRoll() / Config.aerobatic.tilt.range_roll);
        float yawTilt = Math.abs(this.aerobaticData.getTiltYaw() / Config.aerobatic.tilt.range_yaw);
        float angularStrength = 2.0f * pitchTilt + rollTilt + 0.2f * yawTilt;
        this.f_119573_ = Mth.m_14036_((float)(speed / 4.0f), (float)-0.2f, (float)0.6f) + Mth.m_14036_((float)(angularStrength / 3.0f), (float)0.0f, (float)0.1f) * fade_factor;
        this.f_119573_ = Mth.m_14036_((float)this.f_119573_, (float)0.0f, (float)1.0f);
        this.f_119574_ = 1.0f;
        this.brakeVolume = this.aerobaticData.getBrakeStrength() * fade_factor;
        this.rotatePitch = Mth.m_14036_((float)(angularStrength / 2.0f), (float)1.0f, (float)1.25f);
        float wVolume = Mth.m_14036_((float)(angularStrength / 2.0f), (float)0.1f, (float)0.9f) * fade_factor * Mth.m_144920_((float)0.0f, (float)1.0f, (float)(speed / 2.0f));
        this.rotateVolume = (this.rotateVolume + wVolume) / 2.0f;
        float wave = (float)Math.sin((float)this.player.f_19797_ / 40.0f);
        this.whistleVolume = (float)Mth.m_14085_((double)0.0, (double)1.0, (double)(((double)speed - 2.8) / 1.2 + (double)(wave * 0.2f)));
        this.whistlePitch = (float)Mth.m_14085_((double)1.0, (double)1.4f, (double)(((double)speed - 2.8) / 1.8 + (double)(wave * 0.3f)));
        this.f_119573_ *= ClientConfig.sound.wind;
    }

    public void elytraTick(float fade_factor) {
        int ageThreshold = 20;
        float volumeThreshold = 0.8f;
        float speedSquared = (float)this.player.m_20184_().m_82556_();
        this.f_119573_ = (double)speedSquared >= 1.0E-7 ? Mth.m_14036_((float)(speedSquared / 4.0f), (float)0.0f, (float)1.0f) : 0.0f;
        this.f_119573_ *= this.age > 20 ? (float)Math.min(this.age - 20, 20) / 20.0f * fade_factor : 0.0f;
        this.f_119574_ = Math.max(1.0f + this.f_119573_ - 0.8f, 1.0f);
    }

    public void aerobaticUnderwaterTick(float fade_factor) {
        this.whistleVolume = 0.0f;
        this.rotateVolume = 0.0f;
        this.brakeVolume = 0.0f;
        this.f_119573_ = 0.0f;
        this.whistlePitch = 1.0f;
        this.rotatePitch = 1.0f;
        this.brakePitch = 1.0f;
        this.f_119574_ = 1.0f;
    }

    public void elytraUnderwaterTick(float fade_factor) {
        this.f_119573_ = 0.0f;
        this.f_119574_ = 1.0f;
    }

    @SubscribeEvent
    public static void onSoundEvent(PlaySoundEvent event) {
        if (SoundEvents.f_11886_.m_11660_().toString().equals("minecraft:" + event.getName())) {
            SoundInstance sound2 = event.getSound();
            if (!(sound2 instanceof ElytraOnPlayerSoundInstance)) {
                LogUtil.errorOnce((Logger)LOGGER, (String)"Non-ElytraSound elytra sound detected, aerobatic elytra sound may not play properly");
                return;
            }
            ElytraOnPlayerSoundInstance elytraSound = (ElytraOnPlayerSoundInstance)sound2;
            Player player = (Player)elytraSound$player.get((Object)elytraSound);
            if (player != null) {
                AerobaticDataCapability.getAerobaticDataOrDefault(player).setElytraSound(elytraSound);
                if (AerobaticElytraLogic.hasAerobaticElytra(player)) {
                    event.setSound(null);
                    new AerobaticElytraSound(player).play();
                }
            }
        }
    }
}

