/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class FlightModeToastOverlay
implements IGuiOverlay {
    private long toastEnd = 0L;
    private long remainingToastTime = 0L;
    private IFlightMode mode;

    public void render(ForgeGui gui, GuiGraphics gg, float partialTick, int width, int height) {
        if (this.remainingToastTime > 0L) {
            float alpha = (float)this.remainingToastTime / (float)ClientConfig.style.visual.mode_toast_length_ms;
            ResourceLocation t = this.mode.getToastIconLocation();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            Window win = Minecraft.m_91087_().m_91268_();
            int winW = win.m_85445_();
            int winH = win.m_85446_();
            int tW = 256;
            int tH = 256;
            int iW = 32;
            int iH = 32;
            int u = this.mode.getToastIconU();
            int v = this.mode.getToastIconV();
            if (u != -1 && v != -1) {
                int x = Math.round((float)(winW - iW) * ClientConfig.style.visual.mode_toast_x_fraction);
                int y = Math.round((float)(winH - iH) * ClientConfig.style.visual.mode_toast_y_fraction);
                gg.m_280163_(t, x, y, (float)u, (float)v, iW, iH, tW, tH);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            long tt = System.currentTimeMillis();
            this.remainingToastTime = this.toastEnd - tt;
        }
    }

    public void showModeToast(IFlightMode modeIn) {
        this.mode = modeIn;
        this.toastEnd = System.currentTimeMillis() + ClientConfig.style.visual.mode_toast_length_ms;
        this.remainingToastTime = ClientConfig.style.visual.mode_toast_length_ms;
    }
}

