/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import endorh.aerobaticelytra.client.AerobaticElytraResources;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class FlightBarOverlay
implements IGuiOverlay {
    private static float lastBoost = 0.0f;
    private static float lastProp = 0.0f;
    private static float prevBoost = 0.0f;
    private static float prevProp = 0.0f;
    private static float lastPartialTicks = 0.0f;

    public void render(ForgeGui gui, GuiGraphics gg, float partialTicks, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        Window win = Minecraft.m_91087_().m_91268_();
        boolean replace = ClientConfig.style.visual.flight_bar == ClientConfig.FlightBarDisplay.REPLACE_XP || player.m_7500_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        ResourceLocation t = AerobaticElytraResources.FLIGHT_GUI_ICONS_LOCATION;
        int winW = win.m_85445_();
        int winH = win.m_85446_();
        int cap = player.m_36323_();
        int x = winW / 2 - 91;
        int y = winH - 32 + 3;
        float barLength = 183.0f;
        int barHeight = 5;
        if (!replace) {
            y -= 3;
            barHeight = 3;
        }
        int tW = 256;
        int tH = 256;
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
        float pr = data.getPropulsionStrength();
        int prop = (int)((pr >= 0.0f ? pr / Config.aerobatic.propulsion.positive_span : pr / Config.aerobatic.propulsion.negative_span) * barLength);
        int boost = (int)(data.getBoostHeat() * barLength);
        int brake_heat = (int)((1.0 - Math.pow(1.0f - data.getBrakeHeat(), 1.4)) * (double)barLength);
        boolean brake_cooldown = data.isBrakeCooling();
        if (partialTicks < lastPartialTicks) {
            lastBoost = prevBoost;
            lastProp = prevProp;
            prevBoost = boost;
            prevProp = prop;
        }
        lastPartialTicks = partialTicks;
        prop = Math.round(Mth.m_14179_((float)partialTicks, (float)lastProp, (float)prop));
        boost = Math.round(Mth.m_14179_((float)partialTicks, (float)lastBoost, (float)boost));
        if (cap > 0) {
            gg.m_280163_(t, x, y, 0.0f, 50.0f, (int)barLength - 1, barHeight, tW, tH);
            if (prop > 0) {
                gg.m_280163_(t, x, y, 0.0f, 55.0f, prop, barHeight, tW, tH);
            } else if (prop < 0) {
                gg.m_280163_(t, x, y, 0.0f, 60.0f, -prop, barHeight, tW, tH);
            }
            if (boost > 0) {
                gg.m_280163_(t, x, y, 0.0f, 65.0f, boost, barHeight, tW, tH);
            }
            if (brake_heat > 0) {
                gg.m_280163_(t, x, y, 0.0f, brake_cooldown ? 75.0f : 70.0f, brake_heat, barHeight, tW, tH);
            }
            gg.m_280163_(t, x, y, 0.0f, 80.0f, (int)barLength - 1, barHeight, tW, tH);
        }
        RenderSystem.disableBlend();
    }
}

