/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import endorh.aerobaticelytra.client.AerobaticElytraResources;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.lazulib.animation.ToggleAnimator;
import endorh.lazulib.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class AerobaticCrosshairOverlay
implements IGuiOverlay {
    private static final Vec3f XP = (Vec3f)Vec3f.XP.get();
    private static final Vec3f YP = (Vec3f)Vec3f.YP.get();
    private static final Vec3f ZP = (Vec3f)Vec3f.ZP.get();
    private final ToggleAnimator lookAroundAnimator = ToggleAnimator.quadOut((long)100L);
    private final ToggleAnimator rectifyAnimator = ToggleAnimator.quadOut((long)100L);

    public AerobaticCrosshairOverlay() {
        this.lookAroundAnimator.setRange(-45.0f, 0.0f);
        this.rectifyAnimator.setRange(1.2f, 1.0f);
    }

    public void render(ForgeGui gui, GuiGraphics gg, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
        Window win = mc.m_91268_();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.renderCrosshair(gg, win, data, partialTicks);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    private void renderCrosshair(GuiGraphics gg, Window win, IAerobaticData data, float partialTicks) {
        ResourceLocation t = AerobaticElytraResources.FLIGHT_GUI_ICONS_LOCATION;
        int winW = win.m_85445_();
        int winH = win.m_85446_();
        int tW = 256;
        int tH = 256;
        int cS = 25;
        float scaledPitch = data.getTiltPitch() / Config.aerobatic.tilt.range_pitch * 3.0f;
        float scaledRoll = data.getTiltRoll() / Config.aerobatic.tilt.range_roll * 60.0f;
        float scaledYaw = -Mth.m_14036_((float)data.getTiltYaw(), (float)(-Config.aerobatic.tilt.range_yaw), (float)Config.aerobatic.tilt.range_yaw) / Config.aerobatic.tilt.range_yaw * 0.5f;
        float lookYaw = Mth.m_14179_((float)partialTicks, (float)data.getPrevLookAroundYaw(), (float)data.getLookAroundYaw());
        float lookPitch = Mth.m_14179_((float)partialTicks, (float)data.getPrevLookAroundPitch(), (float)data.getLookAroundPitch());
        boolean isLookingAround = lookYaw != 0.0f || lookPitch != 0.0f || data.isLookingAround();
        if (this.lookAroundAnimator.getTarget() == 1.0f != isLookingAround) {
            this.lookAroundAnimator.setTarget(isLookingAround);
        }
        if (this.rectifyAnimator.getTarget() == 1.0f != data.isJumping()) {
            this.rectifyAnimator.setTarget(data.isJumping());
        }
        boolean animatingLook = this.lookAroundAnimator.isInProgress();
        float cX = (float)winW / 2.0f;
        float cY = (float)winH / 2.0f;
        int crossX = (winW - cS) / 2;
        int crossY = (winH - cS) / 2;
        PoseStack pStack = gg.m_280168_();
        pStack.m_85836_();
        if (animatingLook) {
            pStack.m_85836_();
            pStack.m_252880_(cX, cY, 0.0f);
            pStack.m_252781_(ZP.rotationDegrees(this.lookAroundAnimator.getProgress()));
            pStack.m_252880_(-cX, -cY, 0.0f);
            gg.m_280163_(t, crossX, crossY, (float)(2 * cS), 0.0f, cS, cS, tW, tH);
            pStack.m_85849_();
        }
        if (isLookingAround) {
            float rotDiag = (float)Math.sqrt(lookPitch * lookPitch + lookYaw * lookYaw);
            if (!animatingLook) {
                gg.m_280163_(t, crossX, crossY, (float)(2 * cS), data.isLookAroundPersistent() ? (float)cS : 0.0f, cS, cS, tW, tH);
            }
            if (rotDiag > 1.0E-4f) {
                float diag = (float)Math.sqrt(winW * winW + winH * winH);
                float rotationOffset = diag / 8.0f;
                float rotationStrength = Mth.m_14036_((float)(1.0f - 1.0f / rotDiag), (float)0.0f, (float)1.0f);
                float relRot = (rotDiag - 90.0f) / 5.0f;
                float counterRotationStrength = 0.4f * (float)Math.cbrt(relRot / (1.0f + (float)Math.pow(relRot, 4.0)));
                pStack.m_252880_(cX, cY, -rotationOffset);
                pStack.m_252781_(XP.rotationDegrees(lookPitch * rotationStrength));
                pStack.m_252781_(YP.rotationDegrees(lookYaw * rotationStrength));
                pStack.m_252880_(0.0f, 0.0f, rotationOffset);
                pStack.m_252781_(XP.rotationDegrees(lookPitch * counterRotationStrength));
                pStack.m_252781_(YP.rotationDegrees(lookYaw * counterRotationStrength));
                pStack.m_252880_(-cX, -cY, 0.0f);
            }
        }
        gg.m_280163_(t, crossX, crossY, 0.0f, 0.0f, cS, cS, tW, tH);
        pStack.m_85836_();
        pStack.m_85837_(0.0, (double)scaledPitch, 0.0);
        gg.m_280163_(t, crossX, crossY, (float)cS, 0.0f, cS, cS, tW, tH);
        pStack.m_85849_();
        pStack.m_85836_();
        pStack.m_252880_(scaledYaw, 0.0f, 0.0f);
        gg.m_280163_(t, crossX, crossY, 0.0f, (float)cS, cS, cS, tW, tH);
        pStack.m_85849_();
        pStack.m_85836_();
        pStack.m_252880_(cX, cY, 0.0f);
        pStack.m_252781_(ZP.rotationDegrees(scaledRoll));
        pStack.m_252880_(-cX, -cY, 0.0f);
        gg.m_280163_(t, crossX, crossY, (float)cS, (float)cS, cS, cS, tW, tH);
        pStack.m_85849_();
        if (this.rectifyAnimator.isInProgress()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.rectifyAnimator.getUnitProgress());
            pStack.m_85836_();
            float scale = this.rectifyAnimator.getProgress();
            pStack.m_252880_(cX, cY, 0.0f);
            pStack.m_85841_(scale, scale, 1.0f);
            pStack.m_252880_(-cX, -cY, 0.0f);
            gg.m_280163_(t, crossX, crossY, (float)(3 * cS), 0.0f, cS, cS, tW, tH);
            pStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (data.isJumping()) {
            gg.m_280163_(t, crossX, crossY, (float)(3 * cS), 0.0f, cS, cS, tW, tH);
        }
        pStack.m_85849_();
    }
}

