/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.model;

import endorh.aerobaticelytra.client.render.model.AerobaticElytraModelPose;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.lazulib.math.Vec3f;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IElytraPose {
    public static final AerobaticElytraModelPose DEFAULT_POSE = new AerobaticElytraModelPose();
    public static final IElytraPose STANDING_POSE = new ElytraPose(){

        @Override
        protected void build() {
            this.pose.leftWing.x = 0.2617994f;
            this.pose.leftWing.z = -0.2617994f;
            this.pose.leftWing.origin.x = 5.0f;
            this.pose.leftTip = (float)(-Math.PI);
            this.pose.leftRoll = (float)(-Math.PI);
            this.pose.leftPitch = (float)(-Math.PI);
            this.pose.leftRocket.x = 0.08726646f;
            this.pose.leftRocket.z = 0.2617994f;
            this.pose.copyRightFromLeft();
        }

        @Override
        public AerobaticElytraModelPose getPose(LivingEntity entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, float ageInTicks) {
            this.pose.leftWing.x = 0.2617994f + 0.34906584f * limbSwingAmount;
            this.pose.leftWing.z = -0.2617994f - 0.17453292f * limbSwingAmount;
            this.pose.rightWing.x = this.pose.leftWing.x;
            this.pose.rightWing.z = -this.pose.leftWing.z;
            return this.pose;
        }
    };
    public static final IElytraPose CROUCHING_POSE = new ElytraPose(){

        @Override
        protected void build() {
            this.pose.leftWing.x = 0.87266463f;
            this.pose.leftWing.y = 0.08726646f;
            this.pose.leftWing.z = -1.134464f;
            this.pose.leftWing.origin.x = 6.0f;
            this.pose.leftWing.origin.y = 3.0f;
            this.pose.leftRocket.z = -this.pose.leftWing.z + 0.17453292f;
            this.pose.copyRightFromLeft();
        }

        @Override
        public void modifyPrevious(AerobaticElytraModelPose prev) {
            if (prev.leftWing.x <= 0.5235988f) {
                prev.leftWing.x += 0.08726646f;
            }
            if (prev.rightWing.x <= 0.5235988f) {
                prev.rightWing.x += 0.08726646f;
            }
        }
    };
    public static final IElytraPose FLYING_POSE = new ElytraPose(){

        @Override
        protected void build() {
            this.pose.leftWing.x = 0.2617994f;
            this.pose.leftWing.y = -0.2f;
            this.pose.leftWing.z = -0.2617994f;
            this.pose.leftWing.origin.x = 5.0f;
            this.pose.rightWing.x = this.pose.leftWing.x;
            this.pose.rightWing.y = -this.pose.leftWing.y;
            this.pose.rightWing.z = -this.pose.leftWing.z;
            this.pose.rightWing.origin.x = -this.pose.leftWing.origin.x;
        }

        @Override
        @Nullable
        public AerobaticElytraModelPose getPose(LivingEntity entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, float ageInTicks) {
            float tipRoll;
            float tipLift;
            float tipBase;
            float scaledRoll;
            float scaledPitch;
            float leftTipExtra = 0.0f;
            float rightTipExtra = 0.0f;
            float yTilt = 1.0f;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
                scaledPitch = data.getTiltPitch() / Config.aerobatic.tilt.range_pitch;
                scaledRoll = data.getTiltRoll() / Config.aerobatic.tilt.range_roll;
                tipBase = 0.08726646f;
                tipLift = -((float)player.m_20154_().f_82480_) * 0.5f;
                tipRoll = scaledRoll * 0.3f;
                Vec3f motionVec = new Vec3f(player.m_20184_());
                if ((double)motionVec.y < 0.0) {
                    yTilt = 1.0f - (float)Math.pow(-motionVec.y / motionVec.norm(), 1.5);
                }
            } else if (entity instanceof ArmorStand) {
                ArmorStand stand = (ArmorStand)entity;
                scaledPitch = 0.08726646f;
                scaledRoll = 0.0f;
                tipBase = 0.08726646f;
                tipLift = -0.17453292f;
                tipRoll = scaledRoll * 0.3f;
                yTilt = Math.min(1.0f - stand.m_31680_().m_123158_() / 180.0f, 1.0f);
                leftTipExtra = Mth.m_14177_((float)(stand.m_31688_().m_123158_() + 10.0f)) * ((float)Math.PI / 180);
                rightTipExtra = Mth.m_14177_((float)(stand.m_31689_().m_123158_() - 10.0f)) * ((float)Math.PI / 180);
            } else {
                return this.pose;
            }
            yTilt = Math.max(yTilt, 0.3f);
            yTilt = 1.0f - (1.0f - yTilt) * (1.0f - yTilt);
            float pitchSens = 0.8f;
            float rollSens = 0.8f;
            float targetX = Mth.m_14179_((float)yTilt, (float)0.2617994f, (float)0.34906584f);
            float targetZ = Mth.m_14179_((float)yTilt, (float)-0.2617994f, (float)-1.5707964f);
            this.pose.leftWing.x = Mth.m_14179_((float)0.1f, (float)this.pose.leftWing.x, (float)targetX);
            this.pose.leftWing.z = Mth.m_14179_((float)0.1f, (float)this.pose.leftWing.z, (float)targetZ);
            this.pose.rightWing.x = this.pose.leftWing.x;
            this.pose.rightWing.z = -this.pose.leftWing.z;
            this.pose.leftRocket.z = -this.pose.leftWing.z - 0.13962634f;
            this.pose.rightRocket.z = -this.pose.rightWing.z + 0.13962634f;
            this.pose.leftTip = tipLift - tipRoll + tipBase - leftTipExtra;
            this.pose.rightTip = tipLift + tipRoll + tipBase + rightTipExtra;
            this.pose.leftPitch = scaledPitch * pitchSens;
            this.pose.rightPitch = -scaledPitch * pitchSens;
            this.pose.leftRoll = -scaledRoll * rollSens;
            this.pose.rightRoll = -scaledRoll * rollSens;
            return this.pose;
        }
    };

    default public float getFadeInTime() {
        return Float.NaN;
    }

    default public float getFadeOutTime() {
        return Float.NaN;
    }

    default public void modifyPrevious(AerobaticElytraModelPose previousPose) {
    }

    @Nullable
    public AerobaticElytraModelPose getPose(LivingEntity var1, float var2, float var3, float var4, float var5, float var6);

    @NotNull
    default public AerobaticElytraModelPose getNonNullPose(LivingEntity entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, float ageInTicks) {
        AerobaticElytraModelPose pose = this.getPose(entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, ageInTicks);
        return pose == null ? DEFAULT_POSE : pose;
    }

    public static abstract class ElytraPose
    implements IElytraPose {
        protected final AerobaticElytraModelPose pose = new AerobaticElytraModelPose();

        protected ElytraPose() {
            this.build();
        }

        protected void build() {
        }

        @Override
        @Nullable
        public AerobaticElytraModelPose getPose(LivingEntity entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, float ageInTicks) {
            return this.pose;
        }
    }
}

