/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class AerobaticElytraModelPose {
    public ModelMovableRotation leftWing = new ModelMovableRotation();
    public float leftTip = 0.0f;
    public float leftRoll = 0.0f;
    public float leftPitch = 0.0f;
    public ModelRotation leftRocket = new ModelRotation();
    public ModelMovableRotation rightWing = new ModelMovableRotation();
    public float rightTip = 0.0f;
    public float rightRoll = 0.0f;
    public float rightPitch = 0.0f;
    public ModelMovableRotation rightRocket = new ModelMovableRotation();

    public void copyRightFromLeft() {
        this.rightWing.copy(this.leftWing, true);
        this.rightTip = this.leftTip;
        this.rightRoll = -this.leftRoll;
        this.rightPitch = -this.leftPitch;
        this.rightRocket.copy(this.leftRocket, true);
    }

    public void copyLeftFromRight() {
        this.leftWing.copy(this.rightWing, true);
        this.leftTip = this.rightTip;
        this.leftRoll = -this.rightRoll;
        this.leftPitch = -this.rightPitch;
        this.leftRocket.copy(this.rightRocket, true);
    }

    public static class ModelMovableRotation
    extends ModelRotation {
        public RotationPoint origin;

        public ModelMovableRotation() {
            this.origin = new RotationPoint();
        }

        public ModelMovableRotation(float x, float y, float z) {
            super(x, y, z);
        }

        public ModelMovableRotation(float x, float y, float z, float oX, float oY, float oZ) {
            super(x, y, z);
            this.origin = new RotationPoint(oX, oY, oZ);
        }

        @Override
        public void copy(ModelRotation source, boolean mirror) {
            super.copy(source, mirror);
            if (source instanceof ModelMovableRotation) {
                this.origin.copy(((ModelMovableRotation)source).origin, mirror);
            }
        }

        public void copyAngles(ModelRotation source) {
            this.copyAngles(source, false);
        }

        public void copyAngles(ModelRotation source, boolean mirror) {
            super.copy(source, mirror);
        }

        public void copyOrigin(ModelMovableRotation source) {
            this.copyOrigin(source, false);
        }

        public void copyOrigin(ModelMovableRotation source, boolean mirror) {
            this.origin.copy(source.origin, mirror);
        }

        public void applyOffset(ModelPart part) {
            this.origin.applyOffset(part);
        }

        public void applyOffsetAndRotation(ModelPart part) {
            this.applyRotation(part);
            this.applyOffset(part);
        }

        public void copyOffset(ModelPart part) {
            this.origin.copyOffset(part);
        }

        public void copyOffsetAndRotation(ModelPart part) {
            this.copyRotation(part);
            this.copyOffset(part);
        }
    }

    public static class ModelRotation {
        public static final float TO_RAD = (float)Math.PI / 180;
        public static final float DEG_360 = (float)Math.PI * 2;
        public static final float DEG_5 = 0.08726646f;
        public static final float DEG_10 = 0.17453292f;
        public static final float DEG_15 = 0.2617994f;
        public static final float DEG_20 = 0.34906584f;
        public static final float DEG_25 = 0.43633232f;
        public static final float DEG_30 = 0.5235988f;
        public static final float DEG_35 = 0.5235988f;
        public static final float DEG_40 = 0.5235988f;
        public static final float DEG_45 = 0.7853982f;
        public static final float DEG_60 = 1.0471976f;
        public static final float DEG_85 = 1.4835298f;
        public static final float DEG_90 = 1.5707964f;
        public static final float DEG_95 = 1.6580628f;
        public static final float DEG_175 = 3.054326f;
        public static final float DEG_180 = (float)Math.PI;
        public float x = 0.0f;
        public float y = 0.0f;
        public float z = 0.0f;

        public static float lerpAngle(float t, float a, float b) {
            if (a < b && b - a > a - b + (float)Math.PI * 2) {
                float r = Mth.m_14179_((float)t, (float)a, (float)(b - (float)Math.PI * 2));
                return r <= (float)(-Math.PI) ? r + (float)Math.PI * 2 : r;
            }
            if (a > b && a - b > b - a + (float)Math.PI * 2) {
                float r = Mth.m_14179_((float)t, (float)a, (float)(b + (float)Math.PI * 2));
                return r > (float)Math.PI ? r - (float)Math.PI * 2 : r;
            }
            return Mth.m_14179_((float)t, (float)a, (float)b);
        }

        public ModelRotation() {
        }

        public ModelRotation(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void copy(ModelRotation source) {
            this.copy(source, false);
        }

        public void copy(ModelRotation source, boolean mirror) {
            this.x = source.x;
            this.y = mirror ? -source.y : source.y;
            this.z = mirror ? -source.z : source.z;
        }

        public void copyRotation(ModelPart part) {
            this.x = part.f_104203_;
            this.y = part.f_104204_;
            this.z = part.f_104205_;
        }

        public void applyRotation(ModelPart part) {
            part.m_171327_(this.x, this.y, this.z);
        }
    }

    public static class RotationPoint {
        public float x = 0.0f;
        public float y = 0.0f;
        public float z = 0.0f;

        public RotationPoint() {
        }

        public RotationPoint(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void copy(RotationPoint source) {
            this.copy(source, false);
        }

        public void copy(RotationPoint source, boolean mirror) {
            this.x = mirror ? -source.x : source.x;
            this.y = source.y;
            this.z = source.z;
        }

        public void applyOffset(ModelPart part) {
            part.m_104227_(this.x, this.y, this.z);
        }

        public void copyOffset(ModelPart part) {
            this.x = part.f_104200_;
            this.y = part.f_104201_;
            this.z = part.f_104202_;
        }
    }
}

