/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import endorh.aerobaticelytra.client.render.layer.AerobaticRenderData;
import endorh.aerobaticelytra.client.render.model.AerobaticElytraModelPose;
import endorh.aerobaticelytra.client.render.model.IElytraPose;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.lazulib.animation.Easing;
import endorh.lazulib.math.Vec3f;
import java.util.List;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Rotations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
@OnlyIn(value=Dist.CLIENT)
public class AerobaticElytraModel<T extends LivingEntity>
extends ElytraModel<T> {
    public static final ModelLayerLocation AEROBATIC_ELYTRA_LAYER = new ModelLayerLocation(new ResourceLocation("player"), "aerobatic_elytra");
    public static final String LEFT_WING = "left_wing";
    public static final String RIGHT_WING = "right_wing";
    public static final String WING = "wing";
    public static final String TIP = "tip";
    public static final String PITCH = "pitch";
    public static final String ROLL = "roll";
    public static final String ROCKET = "rocket";
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftWingWing;
    public final ModelPart rightWingWing;
    public final ModelPart leftTip;
    public final ModelPart leftPitch;
    public final ModelPart leftRoll;
    public final ModelPart rightTip;
    public final ModelPart rightPitch;
    public final ModelPart rightRoll;
    public final ModelPart leftRocket;
    public final ModelPart rightRocket;
    private static final float DEG_5 = 0.08726646f;
    private static final float DEG_15 = 0.2617994f;
    protected final Vec3f bodyRotation = (Vec3f)Vec3f.ZERO.get();
    protected List<ModelPart> reportedBodyParts;
    protected final List<ModelPart> leftWingList;
    protected final List<ModelPart> rightWingList;
    protected final List<ModelPart> bothWingsList;
    protected static final float DEG_180 = (float)Math.PI;
    public static final float DEFAULT_ANIMATION_LENGTH = 10.0f;

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AEROBATIC_ELYTRA_LAYER, AerobaticElytraModel::m_170539_);
    }

    public static LayerDefinition m_170539_() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition left = root.m_171599_(LEFT_WING, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = left.m_171599_(WING, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-15.0f, -10.0f, -1.0f, 20.0f, 40.0f, 4.0f, new CubeDeformation(-4.0f, -9.0f, 0.0f)), PartPose.f_171404_);
        PartDefinition leftTip = leftWing.m_171599_(TIP, CubeListBuilder.m_171558_().m_171514_(48, 44).m_171488_(-4.0f, -3.0f, -2.0f, 20.0f, 16.0f, 2.0f, new CubeDeformation(-4.0f, -3.0f, 0.0f)), PartPose.m_171423_((float)-11.0f, (float)21.0f, (float)3.0f, (float)((float)(-Math.PI)), (float)0.0f, (float)0.0f));
        leftTip.m_171599_(ROLL, CubeListBuilder.m_171558_().m_171514_(92, 44).m_171488_(-5.0f, -3.0f, -2.0f, 6.0f, 16.0f, 2.0f, new CubeDeformation(-1.0f, -3.0f, 0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)(-Math.PI)), (float)0.0f));
        leftWing.m_171599_(PITCH, CubeListBuilder.m_171558_().m_171514_(92, 12).m_171488_(-5.0f, -23.25f, -2.0f, 6.0f, 30.0f, 2.0f, new CubeDeformation(-1.0f, -6.75f, 0.0f)), PartPose.m_171423_((float)-11.0f, (float)21.0f, (float)3.0f, (float)0.0f, (float)((float)(-Math.PI)), (float)0.0f));
        PartDefinition right = root.m_171599_(RIGHT_WING, CubeListBuilder.m_171558_().m_171480_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = right.m_171599_(WING, CubeListBuilder.m_171558_().m_171480_().m_171514_(44, 0).m_171488_(-5.0f, -10.0f, -1.0f, 20.0f, 40.0f, 4.0f, new CubeDeformation(-4.0f, -9.0f, 0.0f)), PartPose.f_171404_);
        PartDefinition rightTip = rightWing.m_171599_(TIP, CubeListBuilder.m_171558_().m_171480_().m_171514_(48, 44).m_171488_(-16.0f, -3.0f, -2.0f, 20.0f, 16.0f, 2.0f, new CubeDeformation(-4.0f, -3.0f, 0.0f)), PartPose.m_171423_((float)11.0f, (float)21.0f, (float)3.0f, (float)((float)(-Math.PI)), (float)0.0f, (float)0.0f));
        rightTip.m_171599_(ROLL, CubeListBuilder.m_171558_().m_171480_().m_171514_(92, 44).m_171488_(-1.0f, -3.0f, -2.0f, 6.0f, 16.0f, 2.0f, new CubeDeformation(-1.0f, -3.0f, 0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        rightWing.m_171599_(PITCH, CubeListBuilder.m_171558_().m_171480_().m_171514_(92, 12).m_171488_(-1.0f, -23.25f, -2.0f, 6.0f, 30.0f, 2.0f, new CubeDeformation(-1.0f, -6.75f, 0.0f)), PartPose.m_171423_((float)11.0f, (float)21.0f, (float)3.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        left.m_171599_(ROCKET, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -7.7f, -0.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(-0.5f, -1.2f, -0.5f)).m_171514_(0, 13).m_171488_(-2.5f, -6.0f, -1.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(-1.0f, -0.2f, -1.0f)).m_171514_(0, 13).m_171488_(-0.5f, -7.3f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f, -0.1f, -0.1f)).m_171514_(0, 15).m_171488_(-0.5f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f, -0.1f, -0.1f)), PartPose.m_171423_((float)-2.4f, (float)8.7f, (float)1.7f, (float)0.08726646f, (float)0.0f, (float)0.2617994f));
        right.m_171599_(ROCKET, CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-1.5f, -7.7f, -0.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(-0.5f, -1.2f, -0.5f)).m_171514_(20, 13).m_171488_(-2.5f, -6.0f, -1.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(-1.0f, -0.2f, -1.0f)).m_171514_(20, 13).m_171488_(-0.5f, -7.3f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f, -0.1f, -0.1f)).m_171514_(20, 15).m_171488_(-0.5f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f, -0.1f, -0.1f)), PartPose.m_171423_((float)2.4f, (float)8.7f, (float)1.7f, (float)0.08726646f, (float)0.0f, (float)-0.2617994f));
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public AerobaticElytraModel(ModelPart modelPart) {
        super(modelPart);
        this.leftWing = modelPart.m_171324_(LEFT_WING);
        this.rightWing = modelPart.m_171324_(RIGHT_WING);
        this.leftWingWing = this.leftWing.m_171324_(WING);
        this.rightWingWing = this.rightWing.m_171324_(WING);
        this.leftTip = this.leftWingWing.m_171324_(TIP);
        this.leftRoll = this.leftTip.m_171324_(ROLL);
        this.leftPitch = this.leftWingWing.m_171324_(PITCH);
        this.rightTip = this.rightWingWing.m_171324_(TIP);
        this.rightRoll = this.rightTip.m_171324_(ROLL);
        this.rightPitch = this.rightWingWing.m_171324_(PITCH);
        this.leftRocket = this.leftWing.m_171324_(ROCKET);
        this.rightRocket = this.rightWing.m_171324_(ROCKET);
        this.leftWingList = ImmutableList.of((Object)this.leftWing);
        this.rightWingList = ImmutableList.of((Object)this.rightWing);
        this.reportedBodyParts = this.bothWingsList = ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
        this.initVisibility();
    }

    protected void initVisibility() {
        this.leftWingWing.f_104207_ = true;
        this.rightWingWing.f_104207_ = true;
        this.leftTip.f_104207_ = false;
        this.leftPitch.f_104207_ = false;
        this.leftRoll.f_104207_ = false;
        this.rightTip.f_104207_ = false;
        this.rightPitch.f_104207_ = false;
        this.rightRoll.f_104207_ = false;
    }

    public void renderGlint(PoseStack mStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ResourceLocation glintTexture, float red, float green, float blue, float alpha) {
        this.reportedBodyParts = this.bothWingsList;
        this.setupRenderVisibility(true, false);
        VertexConsumer glintBuilder = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)RenderType.m_110482_((ResourceLocation)glintTexture), (boolean)false, (boolean)true);
        this.doRender(mStack, glintBuilder, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderWing(ElytraDyement.WingSide side, PoseStack mStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.reportedBodyParts = switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ElytraDyement.WingSide.LEFT -> this.leftWingList;
            case ElytraDyement.WingSide.RIGHT -> this.rightWingList;
        };
        this.setupRenderVisibility(true, false);
        this.doRender(mStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRockets(@NotNull PoseStack mStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.reportedBodyParts = this.bothWingsList;
        this.setupRenderVisibility(false, true);
        mStack.m_85836_();
        this.prepareRender(mStack);
        super.m_7695_(mStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        mStack.m_85849_();
    }

    protected void doRender(PoseStack mStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        mStack.m_85836_();
        this.prepareRender(mStack);
        mStack.m_85837_(0.0, 0.0, 0.125);
        super.m_7695_(mStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        mStack.m_85849_();
    }

    protected void prepareRender(PoseStack mStack) {
        if (this.bodyRotation.z != 0.0f) {
            mStack.m_252781_(Axis.f_252403_.m_252961_(this.bodyRotation.z));
        }
        if (this.bodyRotation.y != 0.0f) {
            mStack.m_252781_(Axis.f_252436_.m_252961_(this.bodyRotation.y));
        }
        if (this.bodyRotation.x != 0.0f) {
            mStack.m_252781_(Axis.f_252529_.m_252961_(this.bodyRotation.x));
        }
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return this.reportedBodyParts;
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            IFlightData fd = FlightDataCapability.getFlightDataOrDefault((Player)player);
            IElytraPose newPose = fd.getFlightMode().getElytraPose((Player)player);
            AerobaticRenderData smoother = AerobaticRenderData.getAerobaticRenderData((LivingEntity)player);
            if (newPose == null) {
                newPose = player.m_21255_() ? IElytraPose.FLYING_POSE : (player.m_6047_() ? IElytraPose.CROUCHING_POSE : IElytraPose.STANDING_POSE);
            }
            IElytraPose prevPose = smoother.pose;
            if (ageInTicks - smoother.animationStart < 0.0f) {
                smoother.animationStart = 0.0f;
            }
            float t = (ageInTicks - smoother.animationStart) / smoother.animationLength;
            if (smoother.updatePose(newPose)) {
                AerobaticElytraModelPose prev = prevPose.getNonNullPose((LivingEntity)entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, ageInTicks);
                if (t < 1.0f) {
                    this.interpolate(Easing.quadOut((float)t), smoother.capturedPose, prev);
                } else {
                    this.update(prev);
                }
                this.captureSnapshot(smoother.capturedPose);
                newPose.modifyPrevious(smoother.capturedPose);
                smoother.animationStart = ageInTicks;
                float temp = newPose.getFadeInTime();
                if (Float.isNaN(temp) && Float.isNaN(temp = prevPose.getFadeOutTime())) {
                    temp = 10.0f;
                }
                smoother.animationLength = temp;
                t = 0.0f;
            }
            AerobaticElytraModelPose targetPose = smoother.pose.getNonNullPose((LivingEntity)entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, ageInTicks);
            if (t < 1.0f) {
                this.interpolate(Easing.quadOut((float)t), smoother.capturedPose, targetPose);
            } else {
                this.update(targetPose);
            }
            this.updatePartVisibility();
            this.bodyRotation.set(0.0f, 0.0f, 0.0f);
        } else if (entity instanceof ArmorStand) {
            Rotations leftLegRotation = ((ArmorStand)entity).m_31691_();
            Rotations rightLegRotation = ((ArmorStand)entity).m_31694_();
            IElytraPose p = leftLegRotation.m_123156_() >= 30.0f ? IElytraPose.FLYING_POSE : (rightLegRotation.m_123156_() >= 30.0f ? IElytraPose.CROUCHING_POSE : IElytraPose.STANDING_POSE);
            AerobaticElytraModelPose pose = p.getNonNullPose((LivingEntity)entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, ageInTicks);
            Rotations bodyPose = ((ArmorStand)entity).m_31685_();
            this.bodyRotation.set(bodyPose.m_123156_() * ((float)Math.PI / 180), bodyPose.m_123157_() * ((float)Math.PI / 180), bodyPose.m_123158_() * ((float)Math.PI / 180));
            this.update(pose);
            this.updatePartVisibility();
        } else {
            AerobaticElytraModelPose pose = IElytraPose.STANDING_POSE.getNonNullPose((LivingEntity)entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, ageInTicks);
            this.update(pose);
        }
    }

    public void captureSnapshot(AerobaticElytraModelPose p) {
        p.leftWing.copyOffsetAndRotation(this.leftWing);
        p.rightWing.copyOffsetAndRotation(this.rightWing);
        p.leftTip = this.leftTip.f_104203_;
        p.leftRoll = this.leftRoll.f_104204_;
        p.leftPitch = this.leftPitch.f_104204_;
        p.leftRocket.copyRotation(this.leftRocket);
        p.rightTip = this.rightTip.f_104203_;
        p.rightRoll = this.rightRoll.f_104204_;
        p.rightPitch = this.rightPitch.f_104204_;
        p.rightRocket.copyRotation(this.rightRocket);
    }

    public void interpolate(float t, AerobaticElytraModelPose pre, AerobaticElytraModelPose pos) {
        this.leftWing.f_104203_ = Mth.m_14179_((float)t, (float)pre.leftWing.x, (float)pos.leftWing.x);
        this.leftWing.f_104204_ = Mth.m_14179_((float)t, (float)pre.leftWing.y, (float)pos.leftWing.y);
        this.leftWing.f_104205_ = Mth.m_14179_((float)t, (float)pre.leftWing.z, (float)pos.leftWing.z);
        this.leftWing.f_104200_ = Mth.m_14179_((float)t, (float)pre.leftWing.origin.x, (float)pos.leftWing.origin.x);
        this.leftWing.f_104201_ = Mth.m_14179_((float)t, (float)pre.leftWing.origin.y, (float)pos.leftWing.origin.y);
        this.leftWing.f_104202_ = Mth.m_14179_((float)t, (float)pre.leftWing.origin.z, (float)pos.leftWing.origin.z);
        this.leftTip.f_104203_ = Mth.m_14179_((float)t, (float)pre.leftTip, (float)pos.leftTip);
        this.leftRoll.f_104204_ = Mth.m_14179_((float)t, (float)pre.leftRoll, (float)pos.leftRoll);
        this.leftPitch.f_104204_ = Mth.m_14179_((float)t, (float)pre.leftPitch, (float)pos.leftPitch);
        this.rightWing.f_104203_ = Mth.m_14179_((float)t, (float)pre.rightWing.x, (float)pos.rightWing.x);
        this.rightWing.f_104204_ = Mth.m_14179_((float)t, (float)pre.rightWing.y, (float)pos.rightWing.y);
        this.rightWing.f_104205_ = Mth.m_14179_((float)t, (float)pre.rightWing.z, (float)pos.rightWing.z);
        this.rightWing.f_104200_ = Mth.m_14179_((float)t, (float)pre.rightWing.origin.x, (float)pos.rightWing.origin.x);
        this.rightWing.f_104201_ = Mth.m_14179_((float)t, (float)pre.rightWing.origin.y, (float)pos.rightWing.origin.y);
        this.rightWing.f_104202_ = Mth.m_14179_((float)t, (float)pre.rightWing.origin.z, (float)pos.rightWing.origin.z);
        this.rightTip.f_104203_ = Mth.m_14179_((float)t, (float)pre.rightTip, (float)pos.rightTip);
        this.rightRoll.f_104204_ = Mth.m_14179_((float)t, (float)pre.rightRoll, (float)pos.rightRoll);
        this.rightPitch.f_104204_ = Mth.m_14179_((float)t, (float)pre.rightPitch, (float)pos.rightPitch);
        this.leftRocket.f_104203_ = Mth.m_14179_((float)t, (float)pre.leftRocket.x, (float)pos.leftRocket.x);
        this.leftRocket.f_104204_ = Mth.m_14179_((float)t, (float)pre.leftRocket.y, (float)pos.leftRocket.y);
        this.leftRocket.f_104205_ = Mth.m_14179_((float)t, (float)pre.leftRocket.z, (float)pos.leftRocket.z);
        this.rightRocket.f_104203_ = Mth.m_14179_((float)t, (float)pre.rightRocket.x, (float)pos.rightRocket.x);
        this.rightRocket.f_104204_ = Mth.m_14179_((float)t, (float)pre.rightRocket.y, (float)pos.rightRocket.y);
        this.rightRocket.f_104205_ = Mth.m_14179_((float)t, (float)pre.rightRocket.z, (float)pos.rightRocket.z);
    }

    public void update(AerobaticElytraModelPose pose) {
        pose.leftWing.applyOffsetAndRotation(this.leftWing);
        this.leftTip.f_104203_ = pose.leftTip;
        this.leftRoll.f_104204_ = pose.leftRoll;
        this.leftPitch.f_104204_ = pose.leftPitch;
        pose.rightWing.applyOffsetAndRotation(this.rightWing);
        this.rightTip.f_104203_ = pose.rightTip;
        this.rightRoll.f_104204_ = pose.rightRoll;
        this.rightPitch.f_104204_ = pose.rightPitch;
        pose.leftRocket.applyRotation(this.leftRocket);
        pose.rightRocket.applyRotation(this.rightRocket);
    }

    public void setupRenderVisibility(boolean renderWings, boolean renderRockets) {
        this.leftWingWing.f_104207_ = renderWings;
        this.rightWingWing.f_104207_ = renderWings;
        this.leftRocket.f_104207_ = renderRockets;
        this.rightRocket.f_104207_ = renderRockets;
    }

    public void updatePartVisibility() {
        this.leftPitch.f_104207_ = Mth.m_14154_((float)this.leftPitch.f_104204_) <= 3.054326f;
        this.rightPitch.f_104207_ = Mth.m_14154_((float)this.rightPitch.f_104204_) <= 3.054326f;
        this.leftRoll.f_104207_ = (Mth.m_14154_((float)this.leftTip.f_104203_) <= 1.5707964f || Mth.m_14154_((float)this.leftRoll.f_104204_) <= 1.5707964f) && Mth.m_14154_((float)this.leftRoll.f_104204_) <= 3.054326f;
        this.rightRoll.f_104207_ = (Mth.m_14154_((float)this.rightTip.f_104203_) <= 1.5707964f || Mth.m_14154_((float)this.rightRoll.f_104204_) <= 1.5707964f) && Mth.m_14154_((float)this.rightRoll.f_104204_) <= 3.054326f;
        this.leftTip.f_104207_ = Mth.m_14154_((float)this.leftTip.f_104203_) <= 3.054326f;
        this.rightTip.f_104207_ = Mth.m_14154_((float)this.rightTip.f_104203_) <= 3.054326f;
    }
}

