/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.AerobaticElytraResources;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.client.render.model.AerobaticElytraChestModel;
import endorh.aerobaticelytra.client.render.model.AerobaticElytraModel;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final AerobaticElytraModel<T> modelElytra;
    private final AerobaticElytraChestModel<T> modelBack;
    private final ElytraDyement dyement = new ElytraDyement();

    public AerobaticElytraLayer(RenderLayerParent<T, M> rendererIn, EntityModelSet modelSet) {
        super(rendererIn, modelSet);
        if (!(rendererIn.m_7200_() instanceof HumanoidModel)) {
            throw new IllegalArgumentException("Illegal parent renderer. Aerobatic Elytra Layer cannot be applied to non-humanoid models.");
        }
        this.modelElytra = new AerobaticElytraModel(modelSet.m_171103_(AerobaticElytraModel.AEROBATIC_ELYTRA_LAYER));
        this.modelBack = new AerobaticElytraChestModel(modelSet.m_171103_(AerobaticElytraChestModel.AEROBATIC_ELYTRA_CHEST_LAYER));
    }

    public boolean shouldRender(@NotNull ItemStack stack, @NotNull T entity) {
        return true;
    }

    public void m_6494_(@NotNull PoseStack mStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean effect;
        ItemStack elytra = AerobaticElytraLogic.getAerobaticElytra(entity);
        Item it = elytra.m_41720_();
        if (elytra.m_41619_() || !(it instanceof AerobaticElytraItem)) {
            return;
        }
        AerobaticElytraItem item2 = (AerobaticElytraItem)it;
        if (!this.shouldRender(elytra, entity) || !item2.shouldRenderAerobaticElytraLayer(elytra, (LivingEntity)entity)) {
            return;
        }
        this.dyement.read(elytra);
        ((HumanoidModel)this.m_117386_()).m_102872_(this.modelBack);
        this.modelBack.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (item2.shouldRenderAerobaticElytraBackRockets(elytra, (LivingEntity)entity)) {
            this.renderBackRockets(mStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, elytra);
        }
        this.m_117386_().m_102624_(this.modelElytra);
        this.modelElytra.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean bl = effect = !ClientConfig.style.visibility.disable_wing_glint && item2.hasModelEffect(elytra);
        if (effect) {
            ResourceLocation glintTexture = this.getElytraTexture(elytra, entity);
            this.modelElytra.renderGlint(mStack, buffer, packedLight, OverlayTexture.f_118083_, glintTexture, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (ElytraDyement.WingSide side : ElytraDyement.WingSide.values()) {
            ElytraDyement.WingDyement wingDyement = this.dyement.getWing(side);
            if (wingDyement.hasPattern) {
                this.renderWingBanner(mStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, elytra, side, item2, wingDyement.patternColorData);
                continue;
            }
            this.renderWingDyed(mStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, elytra, side, wingDyement.color, effect);
        }
        if (item2.shouldRenderAerobaticElytraRockets(elytra, (LivingEntity)entity)) {
            this.renderRockets(mStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, elytra);
        }
    }

    public void renderRockets(PoseStack mStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack elytra) {
        AerobaticElytraItem item2 = (AerobaticElytraItem)elytra.m_41720_();
        ResourceLocation texture = this.getElytraTexture(elytra, entity);
        VertexConsumer rocketBuilder = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)item2.hasModelEffect(elytra));
        this.modelElytra.renderRockets(mStack, rocketBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderBackRockets(PoseStack mStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack elytra) {
        AerobaticElytraItem item2 = (AerobaticElytraItem)elytra.m_41720_();
        VertexConsumer backBuilder = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)AerobaticElytraResources.TEXTURE_AEROBATIC_ELYTRA), (boolean)false, (boolean)item2.hasModelEffect(elytra));
        this.modelBack.m_7695_(mStack, backBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderWingDyed(PoseStack mStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack elytra, ElytraDyement.WingSide side, int color, boolean effect) {
        float[] components = this.componentArray(color);
        ResourceLocation texture = this.getElytraTexture(elytra, entity);
        VertexConsumer elytraBuilder = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)effect);
        this.modelElytra.renderWing(side, mStack, elytraBuilder, packedLight, OverlayTexture.f_118083_, components[0], components[1], components[2], 1.0f);
    }

    public void renderWingBanner(PoseStack mStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack elytra, ElytraDyement.WingSide side, AerobaticElytraItem item2, List<Pair<BannerPattern, DyeColor>> patternColorData) {
        int size = Math.min(ClientConfig.style.visual.max_rendered_banner_layers + 1, patternColorData.size());
        for (int i = 0; i < size; ++i) {
            Pair<BannerPattern, DyeColor> pair = patternColorData.get(i);
            float[] color = ((DyeColor)pair.getSecond()).m_41068_();
            Material material = item2.getBannerMaterial((BannerPattern)pair.getFirst());
            if (material.m_119203_() == MissingTextureAtlasSprite.m_118071_()) continue;
            this.modelElytra.renderWing(side, mStack, material.m_119194_(buffer, RenderType::m_110473_), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }

    public float[] componentArray(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    @NotNull
    public ResourceLocation getElytraTexture(@NotNull ItemStack stack, @NotNull T entity) {
        return AerobaticElytraResources.TEXTURE_AEROBATIC_ELYTRA;
    }

    @SubscribeEvent
    public static void onAddLayersEvent(EntityRenderersEvent.AddLayers event) {
        EntityModelSet entityModels = event.getEntityModels();
        LivingEntityRenderer armorStandRenderer = event.getRenderer(EntityType.f_20529_);
        assert (armorStandRenderer != null);
        event.getSkins().forEach(s -> {
            LivingEntityRenderer skin = event.getSkin(s);
            skin.m_115326_(new AerobaticElytraLayer(skin, entityModels));
        });
        armorStandRenderer.m_115326_(new AerobaticElytraLayer(armorStandRenderer, entityModels));
        AerobaticElytra.logRegistered("Render Layers");
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void addAerobaticElytraLayer(LivingEntityRenderer<T, M> renderer, EntityModelSet modelSet) {
        renderer.m_115326_(new AerobaticElytraLayer<T, M>(renderer, modelSet));
    }
}

