/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import endorh.lazulib.animation.Easing;
import endorh.lazulib.events.SetupRotationsRenderPlayerEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class PlayerRendererHandler {
    @SubscribeEvent
    public static void onRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (AerobaticFlight.isAerobaticFlying(player)) {
            float yRot;
            player.f_20883_ = yRot = player.m_146908_();
            player.f_20884_ = yRot;
            player.f_20885_ = yRot;
            player.f_20886_ = yRot;
        }
    }

    @SubscribeEvent
    public static void onSetupRotationsRenderPlayerEvent(SetupRotationsRenderPlayerEvent event) {
        AbstractClientPlayer player = event.player;
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
        if (data.isFlying()) {
            event.setCanceled(true);
            PoseStack mStack = event.matrixStack;
            float t = ((float)player.m_21256_() + event.partialTicks) / 10.0f;
            float yaw = 180.0f - data.getRotationYaw();
            float pitch = -90.0f - data.getRotationPitch();
            if (t < 1.0f) {
                float i = Easing.quadInOut((float)t);
                pitch = Mth.m_14179_((float)i, (float)0.0f, (float)pitch);
                yaw = Mth.m_14179_((float)i, (float)(180.0f - data.getPrevTickRotationYaw()), (float)yaw);
            }
            mStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            mStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            mStack.m_252781_(Axis.f_252436_.m_252977_(data.getRotationRoll() + data.getTiltRoll() * 3.0f));
            mStack.m_252781_(Axis.f_252529_.m_252977_(-data.getTiltPitch() * 3.0f));
            mStack.m_252781_(Axis.f_252403_.m_252977_(data.getTiltYaw() * 3.0f));
            String s = ChatFormatting.m_126649_((String)player.m_7755_().getString());
            if (("Dinnerbone".equals(s) || "Grumm".equals(s)) && player.m_36170_(PlayerModelPart.CAPE)) {
                mStack.m_85837_(0.0, (double)player.m_20206_() + (double)0.1f, 0.0);
                mStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            }
        }
    }
}

