/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class CameraHandler {
    public static double lastFOV = 0.0;
    public static float lastRoll = 0.0f;
    public static final Logger LOGGER = LogManager.getLogger();
    private static float lastPitchOffset = 0.0f;
    private static float lastRollOffset = 0.0f;
    private static float lastYawOffset = 0.0f;
    private static boolean cameraOffset;

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Camera cam = event.getCamera();
        Entity entity = cam.m_90592_();
        if (entity instanceof LocalPlayer) {
            int invertRoll;
            LocalPlayer player = (LocalPlayer)entity;
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            int n = invertRoll = gameSettings.m_92176_() == CameraType.THIRD_PERSON_FRONT ? -1 : 1;
            if (data.isFlying()) {
                lastRoll = data.getLookAroundRoll();
                event.setRoll(lastRoll * (float)invertRoll);
                player.f_108585_ = player.f_108587_ = player.m_146908_();
                player.f_108586_ = player.f_108588_ = player.m_146909_();
            } else if (lastRoll != 0.0f) {
                float f = lastRoll = lastRoll > 180.0f ? 360.0f - (360.0f - lastRoll) * 0.75f : lastRoll * 0.75f;
                if (lastRoll < 1.0E-4f || lastRoll > 359.9999f) {
                    lastRoll = 0.0f;
                }
                event.setRoll(lastRoll * (float)invertRoll);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (AerobaticFlight.isAerobaticFlying((Player)player)) {
            cameraOffset = true;
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
                lastPitchOffset = Mth.m_14179_((float)0.1f, (float)lastPitchOffset, (float)(data.getTiltPitch() / Config.aerobatic.tilt.range_pitch * 3.0f));
                lastRollOffset = Mth.m_14179_((float)0.1f, (float)lastRollOffset, (float)(data.getTiltRoll() / Config.aerobatic.tilt.range_roll * 5.0f));
                lastYawOffset = Mth.m_14179_((float)0.1f, (float)lastYawOffset, (float)(data.getTiltYaw() / Config.aerobatic.tilt.range_yaw * -1.5f));
            }
            PoseStack mStack = event.getPoseStack();
            mStack.m_252781_(Axis.f_252529_.m_252977_(lastPitchOffset));
            mStack.m_252781_(Axis.f_252436_.m_252977_(lastYawOffset));
            mStack.m_252781_(Axis.f_252403_.m_252977_(lastRollOffset));
        } else if (cameraOffset) {
            cameraOffset = false;
            lastYawOffset = 0.0f;
            lastRollOffset = 0.0f;
            lastPitchOffset = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onFovModifier(ViewportEvent.ComputeFov event) {
        Camera cam = event.getCamera();
        Entity entity = cam.m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
            double fov = event.getFOV();
            double newFOV = 0.0;
            if (data.isFlying()) {
                double f = Math.min(1.0, ((double)data.getTicksFlying() + event.getPartialTick()) / 4.0);
                double p = (double)(Mth.m_14154_((float)data.getPropulsionStrength()) / Config.aerobatic.propulsion.span) * 10.0;
                double b = data.isBoosted() ? 15.0 : 0.0;
                newFOV = f * (p + b) * (double)ClientConfig.style.visual.fov_effect_strength;
            }
            lastFOV = (lastFOV * 3.0 + newFOV) / 4.0;
            event.setFOV(fov + lastFOV);
        }
    }
}

