/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.render;

import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.client.render.overlay.AerobaticCrosshairOverlay;
import endorh.aerobaticelytra.client.render.overlay.AerobaticDebugCrosshairOverlay;
import endorh.aerobaticelytra.client.render.overlay.FlightBarOverlay;
import endorh.aerobaticelytra.client.render.overlay.FlightModeToastOverlay;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class AerobaticOverlays {
    public static AerobaticCrosshairOverlay AEROBATIC_CROSSHAIR;
    public static AerobaticDebugCrosshairOverlay AEROBATIC_DEBUG_CROSSHAIR;
    public static FlightBarOverlay FLIGHT_BAR;
    public static FlightModeToastOverlay MODE_TOAST_OVERLAY;
    private static boolean rotatingDebugCrosshair;
    private static boolean showingCrosshair;
    private static boolean showingFlightBar;
    private static boolean showingExperienceBar;

    public static void showModeToastIfRelevant(Player player, IFlightMode mode) {
        if (AerobaticElytraLogic.hasAerobaticElytra(player)) {
            AerobaticOverlays.showModeToast(mode);
        }
    }

    public static void showModeToast(IFlightMode modeIn) {
        MODE_TOAST_OVERLAY.showModeToast(modeIn);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            rotatingDebugCrosshair = false;
            boolean showCrosshair = false;
            if (ClientConfig.style.visual.flight_crosshair) {
                Minecraft mc = Minecraft.m_91087_();
                LocalPlayer pl = mc.f_91074_;
                assert (pl != null);
                IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)pl);
                float roll = data.getRotationRoll();
                if (AerobaticFlight.isAerobaticFlying((Player)pl) || Float.compare(roll, 0.0f) != 0) {
                    Options opt = mc.f_91066_;
                    assert (mc.f_91072_ != null);
                    if (opt.m_92176_().m_90612_() && mc.f_91072_.m_105295_() != GameType.SPECTATOR && !opt.f_92062_) {
                        if (opt.f_92063_ && !pl.m_36330_() && !((Boolean)opt.m_231824_().m_231551_()).booleanValue()) {
                            rotatingDebugCrosshair = true;
                        } else {
                            showCrosshair = true;
                        }
                    }
                }
            }
            if (showCrosshair != showingCrosshair || showCrosshair) {
                showingCrosshair = showCrosshair;
            }
            boolean showFlightBar = false;
            boolean suppressExperienceBar = false;
            if (ClientConfig.style.visual.flight_bar != ClientConfig.FlightBarDisplay.HIDE) {
                Minecraft mc = Minecraft.m_91087_();
                LocalPlayer player = mc.f_91074_;
                assert (player != null);
                if (AerobaticFlight.isAerobaticFlying((Player)player)) {
                    showFlightBar = true;
                    if (ClientConfig.style.visual.flight_bar == ClientConfig.FlightBarDisplay.REPLACE_XP) {
                        suppressExperienceBar = true;
                    }
                }
            }
            if (suppressExperienceBar) {
                showingExperienceBar = false;
            } else if (showFlightBar != showingFlightBar) {
                showingExperienceBar = true;
            }
            if (showFlightBar != showingFlightBar) {
                showingFlightBar = showFlightBar;
            }
        } else if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            event.setCanceled(showingCrosshair || rotatingDebugCrosshair);
        } else if (event.getOverlay().overlay() == AEROBATIC_DEBUG_CROSSHAIR) {
            event.setCanceled(!rotatingDebugCrosshair);
        } else if (event.getOverlay().overlay() == AEROBATIC_CROSSHAIR) {
            event.setCanceled(!showingCrosshair);
        } else if (event.getOverlay().overlay() == FLIGHT_BAR) {
            event.setCanceled(!showingFlightBar);
        } else if (event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            event.setCanceled(!showingExperienceBar);
        }
    }

    static {
        rotatingDebugCrosshair = false;
        showingCrosshair = true;
        showingFlightBar = true;
        showingExperienceBar = true;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
    public static class Registrar {
        @SubscribeEvent
        public static void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
            AEROBATIC_CROSSHAIR = new AerobaticCrosshairOverlay();
            event.registerAboveAll("crosshair", (IGuiOverlay)AEROBATIC_CROSSHAIR);
            AEROBATIC_DEBUG_CROSSHAIR = new AerobaticDebugCrosshairOverlay();
            event.registerAboveAll("debug_crosshair", (IGuiOverlay)AEROBATIC_DEBUG_CROSSHAIR);
            FLIGHT_BAR = new FlightBarOverlay();
            event.registerBelow(new ResourceLocation("experience_bar"), "flight_bar", (IGuiOverlay)FLIGHT_BAR);
            MODE_TOAST_OVERLAY = new FlightModeToastOverlay();
            event.registerAboveAll("flight_mode_toast", (IGuiOverlay)MODE_TOAST_OVERLAY);
        }
    }
}

