/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.particle.TrailParticleData;
import endorh.aerobaticelytra.debug.Debug;
import endorh.lazulib.common.ColorUtil;
import endorh.lazulib.common.LogUtil;
import endorh.lazulib.math.Vec3f;
import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrailParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double GRAVITY_STRENGTH = 0.04;
    private static final float FRICTION = 0.98f;
    private final SpriteSet sprites;
    private final float size;
    private final MutableBlockPos pos;
    private final boolean ownPlayer;
    private final Vec3f m;
    private final Vec3f rollVec;
    private final AerobaticTrail.RocketSide side;
    private final float[] initialColorHSB;
    private final float[] fadeColorHSB;
    private final float[] colorRGB;
    private final Color color;
    private final Color fadeColor;
    private final byte type;
    private final boolean flicker;
    private final boolean trail;
    private final IElytraSpec.TrailData trailData;
    private boolean flickerState;

    protected TrailParticle(ClientLevel world, double x, double y, double z, double speedX, double speedY, double speedZ, Color color, Color fadeColor, byte type, boolean flicker, boolean trail, float size, int life, float partialTick, boolean ownPlayer, @Nullable AerobaticTrail.RocketSide rocketSide, @Nullable Vec3f rollVec, @Nullable IElytraSpec.TrailData data, SpriteSet sprites) {
        super(world, x, y, z, speedX, speedY, speedZ);
        this.pos = new MutableBlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        this.m = (Vec3f)Vec3f.ZERO.get();
        this.initialColorHSB = new float[3];
        this.fadeColorHSB = new float[3];
        this.colorRGB = new float[3];
        this.flickerState = true;
        this.sprites = sprites;
        this.color = color;
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.initialColorHSB);
        this.fadeColor = fadeColor;
        Color.RGBtoHSB(fadeColor.getRed(), fadeColor.getGreen(), fadeColor.getBlue(), this.fadeColorHSB);
        this.type = type;
        this.flicker = flicker;
        this.trail = trail;
        this.ownPlayer = ownPlayer;
        this.rollVec = rollVec;
        this.side = rocketSide;
        this.trailData = data;
        ColorUtil.hsbLerpToRgb((float)0.0f, (float[])this.initialColorHSB, (float[])this.fadeColorHSB, (float[])this.colorRGB);
        this.m_107253_(this.colorRGB[0], this.colorRGB[1], this.colorRGB[2]);
        this.size = size;
        this.f_107663_ = size;
        this.f_107225_ = Math.max(life, 1);
        this.f_107230_ = 1.0f;
        this.f_107226_ = 0.05f;
        if (type == 5) {
            this.f_107226_ = -0.02f;
        }
        double prevMotionY = -0.04 * (double)this.f_107226_ * (double)(1.0f - partialTick);
        this.m_6257_(0.0, prevMotionY, 0.0);
        this.f_107215_ = speedX;
        this.f_107216_ = speedY + prevMotionY;
        this.f_107217_ = speedZ;
        if (partialTick > 0.0f) {
            double partialFriction = Math.pow(0.98f, 1.0f - partialTick);
            this.f_107215_ *= partialFriction;
            this.f_107216_ *= partialFriction;
            this.f_107217_ *= partialFriction;
        }
        this.f_107219_ = true;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        boolean shouldRender;
        Minecraft mc = Minecraft.m_91087_();
        float lSquared = (float)mc.f_91063_.m_109153_().m_90583_().m_82531_(this.f_107212_, this.f_107213_, this.f_107214_);
        boolean bl = !this.ownPlayer || (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON ? this.f_107224_ > 5 || lSquared > 12.0f : this.f_107224_ > 10 || lSquared > 6.0f) ? true : (shouldRender = false);
        if (shouldRender) {
            this.f_107663_ = this.getScaleForAge((float)this.f_107224_ + partialTicks);
            this.m_107271_(this.getAlphaForAge((float)this.f_107224_ + partialTicks));
            super.m_5744_(buffer, renderInfo, partialTicks);
        }
    }

    public float getScaleForAge(float age) {
        float start_animation = 10.0f;
        float end_animation = 30.0f;
        if (Debug.DEBUG.persistentParticles && age + 1.0f >= (float)this.f_107225_) {
            return this.size * 0.5f;
        }
        if (age < 10.0f) {
            return this.size * (age / 10.0f);
        }
        if ((float)this.f_107225_ - age < 30.0f) {
            return Mth.m_14179_((float)((age - (float)this.f_107225_ + 30.0f) / 30.0f), (float)this.size, (float)(this.size * 1.5f));
        }
        return this.size;
    }

    public float getAlphaForAge(float age) {
        float end_animation = 30.0f;
        if (Debug.DEBUG.persistentParticles && age + 1.0f >= (float)this.f_107225_) {
            return 1.0f;
        }
        if (age >= (float)this.f_107225_) {
            return 0.0f;
        }
        if (this.flicker) {
            float r = RANDOM.nextFloat();
            if (this.flickerState) {
                if (r >= 0.6f) {
                    this.flickerState = false;
                    return 0.0f;
                }
            } else {
                if (r < 0.5f) {
                    return 0.0f;
                }
                this.flickerState = true;
            }
        }
        if ((float)this.f_107225_ - age < 30.0f) {
            return Mth.m_14179_((float)((age - (float)this.f_107225_ + 30.0f) / 30.0f), (float)0.8f, (float)0.0f);
        }
        return Mth.m_14179_((float)(age / ((float)this.f_107225_ - 30.0f)), (float)1.0f, (float)0.8f);
    }

    public void m_5989_() {
        if (this.trail && this.f_107224_ == 0) {
            this.m.set(this.f_107215_, this.f_107216_, this.f_107217_);
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.type == 5) {
            if (RANDOM.nextFloat() > 0.9f) {
                this.f_107224_ = this.f_107225_;
            } else if (!this.f_107208_.m_8055_((BlockPos)this.pos.set(this.f_107212_, this.f_107213_, this.f_107214_)).m_60819_().m_205070_(FluidTags.f_13131_)) {
                this.f_107224_ = this.f_107225_;
            }
        }
        this.m_108335_(this.sprites);
        ColorUtil.hsbLerpToRgb((float)((float)this.f_107224_ / (float)this.f_107225_), (float[])this.initialColorHSB, (float[])this.fadeColorHSB, (float[])this.colorRGB);
        this.m_107253_(this.colorRGB[0], this.colorRGB[1], this.colorRGB[2]);
        if (this.f_107224_ == this.f_107225_ && Debug.DEBUG.persistentParticles) {
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)0.98f;
            this.f_107216_ *= (double)0.98f;
            this.f_107217_ *= (double)0.98f;
            if (this.f_107218_) {
                this.f_107215_ *= (double)0.7f;
                this.f_107217_ *= (double)0.7f;
            }
        }
        if (this.trail && this.f_107224_ == 1) {
            this.trail();
        }
    }

    public void trail() {
        this.m.mul(0.2f);
        this.m.unitary();
        this.rollVec.unitary();
        Vec3f r = this.rollVec.copy();
        float f_r = 0.015f;
        float f_m = 0.1f;
        float f_o = 0.015f;
        if (this.side == AerobaticTrail.RocketSide.LEFT || this.side == AerobaticTrail.RocketSide.CENTER_LEFT) {
            this.rollVec.mul(-1.0f);
        }
        Vec3f o = this.rollVec.copy();
        if (this.side == AerobaticTrail.RocketSide.CENTER_LEFT || this.side == AerobaticTrail.RocketSide.CENTER_RIGHT) {
            this.rollVec.rotateAlongOrtVecDegrees(this.m, 30.0f);
            f_r = 0.025f;
            o.mul(0.0f);
        }
        for (int i = -2; i <= 2; ++i) {
            if (i == 0 && (this.side == AerobaticTrail.RocketSide.CENTER_LEFT || this.side == AerobaticTrail.RocketSide.CENTER_RIGHT)) {
                this.rollVec.rotateAlongOrtVecDegrees(this.m, -60.0f);
            }
            float p_r = (float)i * f_r;
            r.set(this.rollVec);
            r.mul(p_r);
            TrailParticleData data = this.childrenParticle();
            if (data == null) continue;
            this.f_107208_.m_7106_((ParticleOptions)data, this.f_107212_, this.f_107213_, this.f_107214_, (double)(r.x + f_m * this.m.x + f_o * o.x), (double)(r.y + f_m * this.m.y + f_o * o.y), (double)(r.z + f_m * this.m.z + f_o * o.z));
        }
        this.f_107225_ = 2;
    }

    public TrailParticleData childrenParticle() {
        if (this.trailData == null) {
            return null;
        }
        Optional<IElytraSpec.RocketStar> explosionOpt = TrailParticle.pickRandom(this.trailData.get(this.side));
        if (explosionOpt.isEmpty()) {
            LogUtil.warnOnce((Logger)LOGGER, (String)"No explosions in trailed particle");
            return null;
        }
        IElytraSpec.RocketStar explosion = explosionOpt.get();
        Color cColor = new Color(TrailParticle.pickRandom(explosion.colors).orElse(this.color.getRGB()));
        Color cFadeColor = new Color(TrailParticle.pickRandom(explosion.colors).orElse(this.fadeColor.getRGB()));
        int life = this.f_107225_ - 10;
        float cSize = this.size * 0.5f;
        return new TrailParticleData(cColor, cFadeColor, explosion.type, explosion.flicker, false, life, cSize, 0.0f, this.ownPlayer, this.rollVec, this.side, this.trailData);
    }

    private static Optional<Integer> pickRandom(int[] array) {
        if (array == null || array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[RANDOM.nextInt(array.length)]);
    }

    private static <T> Optional<T> pickRandom(T[] array) {
        if (array == null || array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[RANDOM.nextInt(array.length)]);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private static class MutableBlockPos
    extends BlockPos {
        public MutableBlockPos(int x, int y, int z) {
            super(x, y, z);
        }

        public MutableBlockPos set(int x, int y, int z) {
            this.m_142451_(x);
            this.m_142448_(y);
            this.m_142443_(z);
            return this;
        }

        public MutableBlockPos set(double x, double y, double z) {
            this.m_142451_((int)x);
            this.m_142448_((int)y);
            this.m_142443_((int)z);
            return this;
        }
    }

    public static class Factory
    implements ParticleProvider<TrailParticleData> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprite) {
            this.sprites = sprite;
        }

        @Nullable
        public Particle createParticle(@NotNull TrailParticleData data, @NotNull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TrailParticle particle = new TrailParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.color, data.fadeColor, data.type, data.flicker, data.trail, data.size, data.life, data.partialTick, data.ownPlayer, data.side, data.rollVec, data.trailData, this.sprites);
            particle.m_108339_(this.sprites);
            return particle;
        }
    }
}

