/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.item;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.item.IAbility;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AerobaticItemProperties {
    public static final ResourceLocation BROKEN_PROPERTY = new ResourceLocation("broken");
    public static final ResourceLocation FUEL_PROPERTY = AerobaticElytra.prefix("fuel");
    public static final ResourceLocation HIDE_FUEL_PROPERTY = AerobaticElytra.prefix("hide_fuel");
    public static final ResourceLocation HIDE_ROCKETS_PROPERTY = AerobaticElytra.prefix("hide_rockets");
    public static final ResourceLocation EQUAL_WINGS_PROPERTY = AerobaticElytra.prefix("equal_wings");
    private static final ElytraDyement dyement = new ElytraDyement();

    public static void register() {
        AerobaticItemProperties.reg((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, BROKEN_PROPERTY, AerobaticItemProperties::getBrokenProperty);
        AerobaticItemProperties.reg((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, FUEL_PROPERTY, AerobaticItemProperties::getFuelProperty);
        AerobaticItemProperties.reg((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, HIDE_FUEL_PROPERTY, AerobaticItemProperties::getHideFuelProperty);
        AerobaticItemProperties.reg((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, HIDE_ROCKETS_PROPERTY, AerobaticItemProperties::getHideRocketsProperty);
        AerobaticItemProperties.reg((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, EQUAL_WINGS_PROPERTY, AerobaticItemProperties::getEqualWingsProperty);
        AerobaticItemProperties.reg(AerobaticElytraItems.AEROBATIC_ELYTRA_WING, BROKEN_PROPERTY, AerobaticItemProperties::getBrokenProperty);
        AerobaticItemProperties.reg(AerobaticElytraItems.AEROBATIC_ELYTRA_WING, HIDE_ROCKETS_PROPERTY, AerobaticItemProperties::getHideRocketsProperty);
    }

    private static void reg(Item item2, ResourceLocation property, ClampedItemPropertyFunction getter) {
        ItemProperties.register((Item)item2, (ResourceLocation)property, (ItemPropertyFunction)getter);
    }

    public static float getFuelProperty(ItemStack stack, ClientLevel world, LivingEntity holder, int seed) {
        return AerobaticItemProperties.getFuelProperty(stack, world, holder, ElytraSpecCapability.getElytraSpecOrDefault(stack));
    }

    public static float getFuelProperty(ItemStack stack, ClientLevel world, LivingEntity holder, IElytraSpec spec) {
        return spec.getAbility(IAbility.Ability.MAX_FUEL) == 0.0f ? 0.0f : spec.getAbility(IAbility.Ability.FUEL) / spec.getAbility(IAbility.Ability.MAX_FUEL);
    }

    public static float getBrokenProperty(ItemStack stack, ClientLevel world, LivingEntity holder, int seed) {
        return Mth.m_14036_((float)((float)stack.m_41773_() / (float)(stack.m_41776_() - 1)), (float)0.0f, (float)1.0f);
    }

    public static float getHideFuelProperty(ItemStack stack, ClientLevel world, LivingEntity holder, int seed) {
        if (!(stack.m_41720_() instanceof AerobaticElytraItem)) {
            return 0.0f;
        }
        if (!((AerobaticElytraItem)stack.m_41720_()).shouldFuelRenderOverRockets(stack)) {
            return 1.0f;
        }
        if (holder == null) {
            return ClientConfig.style.visibility.fuel_visibility.test() ? 0.0f : 1.0f;
        }
        ItemStack chest = holder.m_6844_(EquipmentSlot.CHEST);
        if (chest == stack) {
            return 0.0f;
        }
        return ClientConfig.style.visibility.fuel_visibility.test() ? 0.0f : 1.0f;
    }

    public static float getHideRocketsProperty(ItemStack stack, ClientLevel world, LivingEntity holder, int seed) {
        if (!AerobaticElytraLogic.isAerobaticElytra(stack)) {
            return 0.0f;
        }
        return ElytraSpecCapability.getElytraSpecOrDefault(stack).getAbility(IAbility.Ability.ROCKETLESS);
    }

    public static float getEqualWingsProperty(ItemStack stack, ClientLevel world, LivingEntity holder, int seed) {
        if (!(stack.m_41720_() instanceof AerobaticElytraItem)) {
            return 0.0f;
        }
        dyement.read(stack, false);
        return AerobaticItemProperties.dyement.hasWingDyement ? 0.0f : 1.0f;
    }
}

