/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.item;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.lazulib.events.RegisterTextureAtlasEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AerobaticElytraBannerTextureManager
extends TextureAtlasHolder {
    public static final ResourceLocation AEROBATIC_ELYTRA_BANNER_SHEET = AerobaticElytra.prefix("textures/atlas/aerobatic_elytra_banner_patterns.png");
    public static final ResourceLocation AEROBATIC_ELYTRA_BANNER_ATLAS = AerobaticElytra.prefix("aerobatic_elytra_banner_patterns");
    private final Map<BannerPattern, Material> MATERIAL_CACHE = new HashMap<BannerPattern, Material>();

    public AerobaticElytraBannerTextureManager(TextureManager manager) {
        super(manager, AEROBATIC_ELYTRA_BANNER_SHEET, AEROBATIC_ELYTRA_BANNER_ATLAS);
    }

    @SubscribeEvent
    public static void onRegisterTextureAtlas(RegisterTextureAtlasEvent event) {
        LogManager.getLogger().warn("Registering texture atlas");
        event.add(AEROBATIC_ELYTRA_BANNER_SHEET, AEROBATIC_ELYTRA_BANNER_ATLAS);
    }

    public TextureAtlasSprite getBannerSprite(BannerPattern pattern) {
        ResourceLocation key = BuiltInRegistries.f_256878_.m_7981_((Object)pattern);
        if (key == null) {
            key = new ResourceLocation("missing");
        }
        return this.m_118901_(key);
    }

    public Material getBannerMaterial(BannerPattern pattern) {
        return this.MATERIAL_CACHE.computeIfAbsent(pattern, p -> new Material(AEROBATIC_ELYTRA_BANNER_SHEET, "b".equals(pattern.m_58579_()) ? AerobaticElytra.prefix("entity/aerobatic_elytra/base") : BuiltInRegistries.f_256878_.m_7854_((Object)pattern).map(path -> AerobaticElytra.prefix("entity/aerobatic_elytra/banner/" + path.m_135782_().m_135815_())).orElse(MissingTextureAtlasSprite.m_118071_())));
    }
}

