/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.input;

import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.lazulib.events.PlayerTurnEvent;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class RotationHandler {
    public static final float ROLL_SENS_PRESCALE = 0.012f;
    public static final float PITCH_SENS_PRESCALE = 0.02f;
    public static final float YAW_SENS_PRESCALE = 0.1f;
    private static boolean flying = false;
    private static int scheduledAimCancel = 0;

    @SubscribeEvent
    public static void onPlayerEntityRotateEvent(PlayerTurnEvent event) {
        Player player = event.player;
        if (AerobaticFlight.isAerobaticFlying(player)) {
            flying = true;
            event.setCanceled(true);
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
            float x = (float)event.x;
            float y = (float)event.y;
            if (data.isLookingAround()) {
                RotationHandler.onLookAround(player, x, y);
            } else if (player.m_20069_()) {
                RotationHandler.onUnderwaterPlayerRotate(player, x, y);
            } else {
                RotationHandler.onPlayerRotate(player, x, y);
            }
        } else if (flying) {
            flying = false;
        }
    }

    public static void onLookAround(Player player, float x, float y) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        x *= -0.15f * ClientConfig.lookaround.sensitivity;
        y *= 0.15f * ClientConfig.lookaround.sensitivity;
        Options settings = Minecraft.m_91087_().f_91066_;
        if (settings.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            y *= -1.0f;
        }
        data.setLookAroundYaw(Mth.m_14036_((float)(data.getLookAroundYaw() + x), (float)(-ClientConfig.lookaround.max_yaw), (float)ClientConfig.lookaround.max_yaw));
        data.setLookAroundPitch(Mth.m_14036_((float)(data.getLookAroundPitch() + y), (float)(-ClientConfig.lookaround.max_pitch), (float)ClientConfig.lookaround.max_pitch));
    }

    public static void onPlayerRotate(Player player, float x, float y) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        double scaledY = (double)y * 0.15;
        double scaledX = (double)x * 0.15;
        Options settings = Minecraft.m_91087_().f_91066_;
        int invertPitch = (Boolean)settings.m_231820_().m_231551_() != false ? -1 : 1;
        int invertRoll = 1;
        if (ClientConfig.controls.invert_pitch) {
            invertPitch *= -1;
        }
        if (settings.m_92176_() == CameraType.THIRD_PERSON_FRONT && ClientConfig.controls.invert_front_third_person) {
            invertPitch *= -1;
            invertRoll *= -1;
        }
        float tiltPitch = data.getTiltPitch();
        float tiltRoll = data.getTiltRoll();
        float tiltYaw = data.getTiltYaw();
        tiltRoll = (float)((double)tiltRoll + scaledX * (double)0.012f * (double)ClientConfig.controls.roll_sens * (double)invertRoll);
        tiltPitch = (float)((double)tiltPitch + scaledY * (double)0.02f * (double)ClientConfig.controls.pitch_sens * (double)invertPitch);
        tiltRoll = Mth.m_14036_((float)tiltRoll, (float)(-Config.aerobatic.tilt.range_roll), (float)Config.aerobatic.tilt.range_roll);
        tiltPitch = Mth.m_14036_((float)tiltPitch, (float)(-Config.aerobatic.tilt.range_pitch), (float)Config.aerobatic.tilt.range_pitch);
        float yawDelta = -0.5f * (float)Mth.m_14205_((double)tiltYaw) + 1.5f * (float)Mth.m_14205_((double)player.f_20900_);
        if (player.f_20900_ == 0.0f) {
            yawDelta = (float)Mth.m_14205_((double)yawDelta) * Mth.m_14036_((float)(2.0f * Math.abs(yawDelta)), (float)0.0f, (float)Math.abs(tiltYaw));
        }
        tiltYaw = Mth.m_14036_((float)(tiltYaw + yawDelta * 0.1f * ClientConfig.controls.yaw_sens), (float)(-Config.aerobatic.tilt.range_yaw), (float)Config.aerobatic.tilt.range_yaw);
        data.setTiltPitch(tiltPitch);
        data.setTiltRoll(tiltRoll);
        data.setTiltYaw(tiltYaw);
    }

    public static void onUnderwaterPlayerRotate(Player player, float x, float y) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        double scaledY = (double)y * 0.15;
        double scaledX = (double)x * 0.15;
        Options settings = Minecraft.m_91087_().f_91066_;
        int invertPitch = (Boolean)settings.m_231820_().m_231551_() != false ? -1 : 1;
        int invertRoll = 1;
        if (ClientConfig.controls.invert_pitch) {
            invertPitch *= -1;
        }
        if (settings.m_92176_() == CameraType.THIRD_PERSON_FRONT && ClientConfig.controls.invert_front_third_person) {
            invertPitch *= -1;
            invertRoll *= -1;
        }
        float tiltPitch = data.getTiltPitch();
        float tiltRoll = data.getTiltRoll();
        float tiltYaw = data.getTiltYaw();
        VectorBase base = data.getRotationBase();
        float underwaterSens = Mth.m_144920_((float)8.0f, (float)0.0f, (float)((float)player.m_20184_().m_82553_() / 0.8f));
        float pitchDelta = (float)(-scaledY) * 0.02f * ClientConfig.controls.pitch_sens * (float)invertPitch * underwaterSens;
        float rollDelta = (float)scaledX * 0.012f * ClientConfig.controls.roll_sens * (float)invertRoll * underwaterSens;
        tiltRoll = (float)((double)tiltRoll + scaledX * (double)0.012f * (double)ClientConfig.controls.roll_sens * (double)invertRoll);
        tiltPitch = (float)((double)tiltPitch + scaledY * (double)0.02f * (double)ClientConfig.controls.pitch_sens * (double)invertPitch);
        tiltRoll = Mth.m_14036_((float)tiltRoll, (float)(-Config.aerobatic.tilt.range_roll), (float)Config.aerobatic.tilt.range_roll);
        tiltPitch = Mth.m_14036_((float)tiltPitch, (float)(-Config.aerobatic.tilt.range_pitch), (float)Config.aerobatic.tilt.range_pitch);
        base.look.rotateAlongOrtVecDegrees(base.roll, pitchDelta);
        base.normal.rotateAlongOrtVecDegrees(base.roll, pitchDelta);
        base.roll.rotateAlongOrtVecDegrees(base.look, rollDelta);
        base.normal.rotateAlongOrtVecDegrees(base.look, rollDelta);
        float yawDelta = -0.5f * (float)Mth.m_14205_((double)tiltYaw) + 1.5f * (float)Mth.m_14205_((double)player.f_20900_);
        if (player.f_20900_ == 0.0f) {
            yawDelta = (float)Mth.m_14205_((double)yawDelta) * Mth.m_14036_((float)(2.0f * Math.abs(yawDelta)), (float)0.0f, (float)Math.abs(tiltYaw));
        }
        float underwaterYawSens = 1.6f;
        tiltYaw = Mth.m_14036_((float)(tiltYaw + yawDelta * 0.1f * ClientConfig.controls.yaw_sens * 1.6f), (float)(-Config.aerobatic.tilt.range_yaw * 1.6f), (float)(Config.aerobatic.tilt.range_yaw * 1.6f));
        data.setTiltPitch(tiltPitch);
        data.setTiltRoll(tiltRoll);
        data.setTiltYaw(tiltYaw);
    }

    @SubscribeEvent
    public static void onBowCharge(ArrowNockEvent event) {
        if (!ClientConfig.lookaround.aim_with_bow) {
            return;
        }
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(event.getEntity());
        if (!data.isLookingAround() && !data.isLookAroundPersistent()) {
            data.setAimingBow(true);
        }
    }

    @SubscribeEvent
    public static void onBowShoot(ArrowLooseEvent event) {
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(event.getEntity());
        if (data.isAimingBow()) {
            scheduledAimCancel = 2;
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        if (!ClientConfig.lookaround.aim_with_bow) {
            data.setAimingBow(false);
            return;
        }
        if (data.isAimingBow() && !(player.m_21205_().m_41720_() instanceof BowItem) && !(player.m_21206_().m_41720_() instanceof BowItem)) {
            data.setAimingBow(false);
        } else if (scheduledAimCancel > 0 && scheduledAimCancel-- == 1) {
            data.setAimingBow(false);
        }
    }
}

