/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.render.AerobaticOverlays;
import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.common.flight.mode.FlightModeTags;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import endorh.aerobaticelytra.network.AerobaticPackets;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra")
public class KeyHandler {
    public static KeyMapping FLIGHT_MODE;
    public static KeyMapping LOOK_AROUND;
    public static final String AEROBATIC_ELYTRA_CATEGORY = "key.aerobaticelytra.category";
    private static long lastLookAroundPress;

    private static KeyMapping reg(RegisterKeyMappingsEvent e, String translation, IKeyConflictContext context, int keyCode, String category) {
        KeyMapping binding = new KeyMapping(translation, context, InputConstants.Type.KEYSYM, keyCode, category);
        e.register(binding);
        return binding;
    }

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        IFlightData fd = FlightDataCapability.getFlightDataOrDefault((Player)player);
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
        boolean lookDown = LOOK_AROUND.m_90857_();
        if (FLIGHT_MODE.m_90859_()) {
            fd.nextFlightMode();
            IFlightMode mode = fd.getFlightMode();
            new AerobaticPackets.DFlightModePacket(mode).send();
            AerobaticOverlays.showModeToastIfRelevant((Player)player, mode);
        } else if (lookDown && !data.isLookingAround()) {
            long time = System.currentTimeMillis();
            if (time - lastLookAroundPress < 200L) {
                lastLookAroundPress = 0L;
                boolean persistent = data.isLookAroundPersistent();
                data.setLookAroundPersistent(!persistent);
                if (persistent) {
                    lookDown = false;
                }
            } else {
                lastLookAroundPress = time;
            }
        }
        data.setLookingAround(lookDown);
    }

    @SubscribeEvent
    public static void onMovementInputUpdateEvent(MovementInputUpdateEvent event) {
        boolean sprinting;
        Player player = event.getEntity();
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        Input movementInput = event.getInput();
        IFlightMode mode = FlightDataCapability.getFlightDataOrDefault(player).getFlightMode();
        if (mode.is(FlightModeTags.AEROBATIC) && player.m_21255_() && data.updateJumping(movementInput.f_108572_)) {
            new AerobaticPackets.DJumpingPacket(data).send();
        }
        boolean bl = sprinting = mode.is(FlightModeTags.AEROBATIC) && player.m_21255_() && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
        if (sprinting) {
            player.m_6858_(false);
        }
        if (data.updateSprinting(sprinting)) {
            new AerobaticPackets.DSprintingPacket(data).send();
        }
    }

    static {
        lastLookAroundPress = 0L;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="aerobaticelytra", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registrar {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent e) {
            FLIGHT_MODE = KeyHandler.reg(e, "key.aerobaticelytra.flight_mode", (IKeyConflictContext)KeyConflictContext.IN_GAME, 67, KeyHandler.AEROBATIC_ELYTRA_CATEGORY);
            LOOK_AROUND = KeyHandler.reg(e, "key.aerobaticelytra.look_around", (IKeyConflictContext)KeyConflictContext.IN_GAME, 342, KeyHandler.AEROBATIC_ELYTRA_CATEGORY);
            AerobaticElytra.logRegistered("Key Mappings");
        }
    }
}

