/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.config;

import endorh.lazulib.text.TextUtil;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class ClientConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static SimpleConfig CONFIG;

    public static void register() {
        CONFIG = ((SimpleConfigBuilder)((SimpleConfigBuilder)((SimpleConfigBuilder)((SimpleConfigBuilder)ConfigBuilderFactoryProxy.config((String)"aerobaticelytra", (SimpleConfig.Type)SimpleConfig.Type.CLIENT, ClientConfig.class).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"controls", (boolean)true).add("pitch_sens", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)1.0f).min(0.0f))).add("roll_sens", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)1.0f).min(0.0f))).add("yaw_sens", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)1.0f).min(0.0f))).add("invert_pitch", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)false))).add("invert_front_third_person", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)false)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"lookaround").add("sensitivity", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)1.0f).min(0.0f))).add("max_pitch", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)70.0f))).add("max_yaw", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)70.0f))).add("aim_with_bow", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)true))).add("reset_on_land", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)true)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"style").n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"visual").add("fov_effect_strength", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((float)1.0f).min(0.0f))).add("flight_crosshair", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)true))).add("flight_bar", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.option((Enum)FlightBarDisplay.OVER_XP))).add("mode_toast_length_seconds", ConfigBuilderFactoryProxy.number((double)2.0).min(0.0).field("mode_toast_length_ms", s -> (long)(s * 1000.0), Long.class))).add("mode_toast_x_percentage", (ConfigEntryBuilder)((FloatEntryBuilder)ConfigBuilderFactoryProxy.number((float)50.0f, (float)100.0f).slider()).fieldScale("mode_toast_x_fraction", 0.01f))).add("mode_toast_y_percentage", (ConfigEntryBuilder)((FloatEntryBuilder)ConfigBuilderFactoryProxy.number((float)70.0f, (float)100.0f).slider()).fieldScale("mode_toast_y_fraction", 0.01f))).add("max_rendered_banner_layers", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number((int)16).max(16)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"visibility").add("fuel_display", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.option((Enum)FuelDisplay.ROCKETS))).add("fuel_visibility", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.option((Enum)Visibility.ALWAYS))).add("disable_wing_glint", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)false))).add("enchantment_glint_visibility", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.option((Enum)Visibility.ALT_UP)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"dark_theme").text("desc", new Object[]{TextUtil.makeLink((String)"Default Dark Theme", (String)"https://www.curseforge.com/minecraft/texture-packs/default-dark-mode"), TextUtil.makeLink((String)"Dark Mod GUIs", (String)"https://www.curseforge.com/minecraft/texture-packs/dark-mod-guis")})).caption("enabled", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.enable((boolean)false)).add("auto_detect", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.yesNo((boolean)true))).add("auto_detect_pattern", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.pattern((String)"dark.*(gui|theme)").flags(2))))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group((String)"sound").caption("master", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f)).add("wind", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f))).add("rotating_wind", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f))).add("whistle", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f))).add("boost", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f))).add("brake", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.volume((float)1.0f)))).withBackground("textures/block/birch_planks.png").buildAndRegister();
    }

    public static void autoEnableDarkTheme() {
        boolean dark = Minecraft.m_91087_().m_91099_().m_10524_().stream().anyMatch(p -> style.dark_theme.auto_detect_pattern.asPredicate().test(p.m_10446_()));
        if (dark && !style.dark_theme.enabled) {
            CONFIG.set("style.dark_theme.enabled", (Object)true);
            style.dark_theme.enabled = true;
            LOGGER.info("Dark theme resource pack detected, enabling Aerobatic Elytra dark theme automatically");
        } else if (!dark && style.dark_theme.enabled) {
            CONFIG.set("style.dark_theme.enabled", (Object)false);
            style.dark_theme.enabled = false;
            LOGGER.info("No dark theme resource pack detected, disabling Aerobatic Elytra dark theme automatically");
        }
    }

    public static enum FlightBarDisplay {
        HIDE,
        OVER_XP,
        REPLACE_XP;

    }

    public static enum FuelDisplay {
        ROCKETS,
        DURABILITY_BAR,
        DURABILITY_BAR_IF_LOWER;

    }

    public static enum Visibility {
        ALWAYS(() -> true),
        NEVER(() -> false),
        SHIFT_DOWN(Screen::m_96638_),
        SHIFT_UP(Screen::m_96638_, true),
        CONTROL_DOWN(Screen::m_96637_),
        CONTROL_UP(Screen::m_96637_, true),
        ALT_DOWN(Screen::m_96639_),
        ALT_UP(Screen::m_96639_, true);

        private final Supplier<Boolean> check;
        private final boolean invert;

        private Visibility(Supplier<Boolean> checkIn) {
            this(checkIn, false);
        }

        private Visibility(Supplier<Boolean> checkIn, boolean invertIn) {
            this.check = checkIn;
            this.invert = invertIn;
        }

        public boolean test() {
            return this.invert != this.check.get();
        }
    }

    public static class style {

        @Bind
        public static class dark_theme {
            @Bind
            public static boolean enabled;
            @Bind
            public static boolean auto_detect;
            @Bind
            public static Pattern auto_detect_pattern;

            static void bake() {
                if (auto_detect) {
                    ClientConfig.autoEnableDarkTheme();
                }
            }
        }

        @Bind
        public static class visibility {
            @Bind
            public static Visibility fuel_visibility;
            @Bind
            public static FuelDisplay fuel_display;
            @Bind
            public static boolean disable_wing_glint;
            @Bind
            public static Visibility enchantment_glint_visibility;
        }

        @Bind
        public static class visual {
            @Bind
            public static float fov_effect_strength;
            @Bind
            public static boolean flight_crosshair;
            @Bind
            public static FlightBarDisplay flight_bar;
            @Bind
            public static long mode_toast_length_ms;
            @Bind
            public static float mode_toast_x_fraction;
            @Bind
            public static float mode_toast_y_fraction;
            @Bind
            public static int max_rendered_banner_layers;
        }
    }

    @Bind
    public static class sound {
        @Bind
        public static float master;
        @Bind
        public static float wind;
        @Bind
        public static float rotating_wind;
        @Bind
        public static float whistle;
        @Bind
        public static float boost;
        @Bind
        public static float brake;

        static void bake() {
            wind *= master;
            rotating_wind *= master;
            whistle *= master;
            boost *= master;
            brake *= master;
        }
    }

    @Bind
    public static class lookaround {
        @Bind
        public static float sensitivity;
        @Bind
        public static float max_pitch;
        @Bind
        public static float max_yaw;
        @Bind
        public static boolean aim_with_bow;
        @Bind
        public static boolean reset_on_land;
    }

    @Bind
    public static class controls {
        @Bind
        public static float pitch_sens;
        @Bind
        public static float roll_sens;
        @Bind
        public static float yaw_sens;
        @Bind
        public static boolean invert_pitch;
        @Bind
        public static boolean invert_front_third_person;
    }
}

