/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.client.block;

import endorh.aerobaticelytra.common.block.BrokenLeavesBlock;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrokenLeavesBlockModel
extends BakedModelWrapper<BakedModel> {
    public static ModelProperty<Optional<BlockState>> COPIED_LEAVES_BLOCK = new ModelProperty();

    public BrokenLeavesBlockModel(BakedModel model) {
        super(model);
    }

    private static ModelData getEmptyModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(COPIED_LEAVES_BLOCK, Optional.empty());
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        return this.getActualBakedModelFromIModelData(data).getQuads(state, side, rand, data, renderType);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        Optional<BlockState> bestAdjacentBlock = BrokenLeavesBlock.getStoredBlockState(level, pos);
        return BrokenLeavesBlockModel.getEmptyModelData().derive().with(COPIED_LEAVES_BLOCK, bestAdjacentBlock).build();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getActualBakedModelFromIModelData(data).getParticleIcon(data);
    }

    private BakedModel getActualBakedModelFromIModelData(@NotNull ModelData data) {
        BakedModel ret = this.originalModel;
        if (!data.has(COPIED_LEAVES_BLOCK)) {
            return ret;
        }
        Optional copiedBlock = (Optional)data.get(COPIED_LEAVES_BLOCK);
        assert (copiedBlock != null);
        if (copiedBlock.isEmpty()) {
            return ret;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        ret = dispatcher.m_110910_((BlockState)copiedBlock.get());
        return ret;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return super.getRenderTypes(state, rand, data);
    }
}

