/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vicmatskiv.pointblank.InvalidExtensionComponentException;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.entity.EntityBuilderProvider;
import com.vicmatskiv.pointblank.item.AmmoItem;
import com.vicmatskiv.pointblank.item.AttachmentItem;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.MiscItem;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.world.item.Item;

public abstract class ItemBuilder<T extends ItemBuilder<T>>
implements Nameable {
    public static ItemBuilder<?> fromZipEntry(ZipFile zipFile, ZipEntry entry) throws InvalidExtensionComponentException {
        ItemBuilder<?> itemBuilder;
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        try {
            itemBuilder = ItemBuilder.fromReader(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidExtensionComponentException("Zip file: " + zipFile + ", zip entry: " + entry, e);
            }
        }
        reader.close();
        return itemBuilder;
    }

    public static ItemBuilder<?> fromPath(Path path) throws InvalidExtensionComponentException {
        ItemBuilder<?> itemBuilder;
        block8: {
            BufferedReader br = Files.newBufferedReader(path);
            try {
                itemBuilder = ItemBuilder.fromReader(br);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidExtensionComponentException("Component path: " + path, e);
                }
            }
            br.close();
        }
        return itemBuilder;
    }

    public static ItemBuilder<?> fromReader(Reader reader) {
        try {
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String itemTypeStr = obj.has("type") ? obj.getAsJsonPrimitive("type").getAsString() : ItemType.GUN.toString();
            ItemType itemType = ItemType.valueOf(itemTypeStr.toUpperCase(Locale.ROOT));
            if (itemType == ItemType.GUN) {
                return new GunItem.Builder().withJsonObject(obj);
            }
            if (itemType == ItemType.AMMO) {
                return new AmmoItem.Builder().withJsonObject(obj);
            }
            if (itemType == ItemType.THROWABLE) {
                return new ThrowableItem.Builder().withJsonObject(obj);
            }
            if (itemType == ItemType.MISC) {
                return new MiscItem.MiscItemBuilder().withJsonObject(obj);
            }
            if (itemType == ItemType.ATTACHMENT) {
                return new AttachmentItem.Builder().withJsonObject(obj);
            }
            throw new IllegalArgumentException("Invalid item type: " + itemType);
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing JSON: " + e.getMessage(), e);
        }
    }

    public abstract T withJsonObject(JsonObject var1);

    public EntityBuilderProvider getEntityBuilderProvider() {
        return null;
    }

    public abstract Item build();

    public static enum ItemType {
        GUN,
        AMMO,
        MISC,
        ATTACHMENT,
        THROWABLE;

    }
}

