/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.loading.FileLoader;
import mod.azure.azurelib.loading.json.FormatVersion;
import mod.azure.azurelib.loading.json.raw.Model;
import mod.azure.azurelib.loading.object.BakedAnimations;
import mod.azure.azurelib.loading.object.BakedModelFactory;
import mod.azure.azurelib.loading.object.GeometryTree;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public final class AzureLibCache {
    private static final Set<String> EXCLUDED_NAMESPACES = ObjectOpenHashSet.of((Object)"moreplayermodels", (Object)"customnpcs", (Object)"gunsrpg");
    private static Map<ResourceLocation, BakedAnimations> ANIMATIONS = Collections.emptyMap();
    private static Map<ResourceLocation, BakedGeoModel> MODELS = Collections.emptyMap();

    public static Map<ResourceLocation, BakedAnimations> getBakedAnimations() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("AzureLib was never initialized! Please read the documentation!");
        }
        return ANIMATIONS;
    }

    public static Map<ResourceLocation, BakedGeoModel> getBakedModels() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("AzureLib was never initialized! Please read the documentation!");
        }
        return MODELS;
    }

    public static void registerReloadListener() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ResourceManager resourceManager = mc.m_91098_();
        if (!(resourceManager instanceof ReloadableResourceManager)) {
            throw new AzureLibException("AzureLib was initialized too early!");
        }
        ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
        resourceManager2.m_7217_(AzureLibCache::reload);
    }

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AzureLibCache.loadAnimations(backgroundExecutor, resourceManager, ((Map)animations)::put);
        completableFutureArray[1] = AzureLibCache.loadModels(backgroundExecutor, resourceManager, ((Map)models)::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> AzureLibCache.lambda$reload$0((Map)animations, (Map)models, arg_0), gameExecutor);
    }

    private static CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, ResourceManager resourceManager, BiConsumer<ResourceLocation, BakedAnimations> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "animations", resource -> FileLoader.loadAnimationsFile(resource, resourceManager), elementConsumer);
    }

    private static CompletableFuture<Void> loadModels(Executor backgroundExecutor, ResourceManager resourceManager, BiConsumer<ResourceLocation, BakedGeoModel> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            if (model.formatVersion() != FormatVersion.V_1_12_0) {
                throw new AzureLibException((ResourceLocation)resource, "Unsupported geometry json version. Supported versions: 1.12.0");
            }
            return BakedModelFactory.getForNamespace(resource.m_135827_()).constructGeoModel(GeometryTree.fromModel(model));
        }, elementConsumer);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, ResourceManager resourceManager, String type, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.m_214159_(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (ResourceLocation resource : resources.keySet()) {
                tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((ResourceLocation)entry.getKey()).m_135827_().toLowerCase(Locale.ROOT))) continue;
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    private static /* synthetic */ void lambda$reload$0(Map animations, Map models, Void empty) {
        ANIMATIONS = animations;
        MODELS = models;
    }
}

