/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.recipe;

import endorh.lazulib.common.ObfuscationReflectionUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="lazulib")
public class RecipeManagerHelper {
    protected static final Set<CachedRecipeProvider<?>> PROVIDERS = Collections.newSetFromMap(new WeakHashMap());
    protected static final CachedRecipeProvider<Collection<Recipe<?>>> recipeListProvider = new CachedRecipeProvider<Collection<Recipe<?>>>(){

        @Override
        protected Collection<Recipe<?>> onReload(RecipeManager manager) {
            return manager.m_44051_();
        }
    };
    protected static final ObfuscationReflectionUtil.SoftField<RecipeManager, Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>>> RecipeManager$recipes = ObfuscationReflectionUtil.getSoftField(RecipeManager.class, "recipes", "recipes");
    protected static WeakReference<Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>>> lastRecipes = new WeakReference<Object>(null);
    protected static WeakReference<RecipeManager> lastRecipeManager = new WeakReference<Object>(null);

    @NotNull
    public static RecipeManager getRecipeManager() {
        RecipeManager manager = (RecipeManager)DistExecutor.unsafeRunForDist(() -> () -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            return level != null ? level.m_7465_() : null;
        }, () -> () -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            return server.m_129894_();
        });
        if (manager == null) {
            throw new IllegalStateException("Could not get recipe manager");
        }
        if (manager != lastRecipeManager.get()) {
            lastRecipeManager = new WeakReference<RecipeManager>(manager);
        }
        return manager;
    }

    protected static boolean checkCache() {
        Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> map = RecipeManager$recipes.get(RecipeManagerHelper.getRecipeManager());
        if (map != lastRecipes.get()) {
            lastRecipes = new WeakReference(map);
            PROVIDERS.forEach(CachedRecipeProvider::invalidate);
            return false;
        }
        return true;
    }

    public static Collection<Recipe<?>> getRecipes() {
        return recipeListProvider.get();
    }

    public static <T> CachedRecipeProvider<List<T>> recipeProviderForType(final Class<T> type) {
        return new CachedRecipeProvider<List<T>>(){

            @Override
            protected List<T> onReload(RecipeManager manager) {
                return manager.m_44051_().stream().filter(type::isInstance).map(r -> r).collect(Collectors.toList());
            }
        };
    }

    @SubscribeEvent
    protected static void onRecipesUpdated(RecipesUpdatedEvent event) {
        PROVIDERS.forEach(CachedRecipeProvider::invalidate);
    }

    protected static void registerCachedRecipeProvider(CachedRecipeProvider<?> provider) {
        PROVIDERS.add(provider);
    }

    public static abstract class CachedRecipeProvider<T> {
        protected T cachedData;
        @ApiStatus.Internal
        protected boolean invalidated = true;

        protected CachedRecipeProvider() {
            RecipeManagerHelper.registerCachedRecipeProvider(this);
        }

        @ApiStatus.Internal
        protected final void invalidate() {
            this.invalidated = true;
            this.onInvalidate();
        }

        public final boolean isInvalidated() {
            if (!RecipeManagerHelper.checkCache()) {
                return true;
            }
            return this.invalidated;
        }

        protected void onInvalidate() {
        }

        protected abstract T onReload(RecipeManager var1);

        public final void reload() {
            this.invalidated = false;
            this.cachedData = this.onReload(RecipeManagerHelper.getRecipeManager());
        }

        public final T get() {
            if (this.isInvalidated()) {
                this.reload();
            }
            return this.cachedData;
        }
    }
}

