/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.nbt;

import Shadow.shadowed.com.florianingerl.util.regex.Matcher;
import Shadow.shadowed.com.florianingerl.util.regex.PatternSyntaxException;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.RgxGen;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.config.RgxGenOption;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.parsing.dflt.RgxGenParseException;
import com.google.common.collect.ImmutableList;
import endorh.lazulib.nbt.NBTPath;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class NBTPredicate
implements Predicate<ItemStack> {
    public static Style defaultStyle = new Style();
    protected static final String nest = NBTPredicate.nest("");

    public static Optional<NBTPredicate> parse(String str) {
        return NBTCompoundPredicate.parse(str);
    }

    protected static String nest(String exclude) {
        return "(?<nest>(?:[^()\\[\\]{}\"'" + exclude + "]++|[\\[({](?'nest')[\\])}]|\"(?:[^\"\\\\]++|\\\\.)*+\"|'(?:[^'\\\\]++|\\\\.)*+')*+)";
    }

    protected static Optional<NBTPredicate> parseNode(String str) {
        return Optional.ofNullable(NBTCompoundPredicate.parse(str).orElseGet(() -> NBTNumericPredicate.parse(str).orElseGet(() -> NBTStringPredicate.parse(str).orElseGet(() -> NBTListPredicate.parse(str).orElse(null)))));
    }

    public Optional<Tag> generateValid() {
        return Optional.empty();
    }

    @Override
    public abstract boolean test(@Nullable Tag var1);

    public abstract boolean isUnique();

    @Override
    public boolean test(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return this.test((Tag)(tag != null ? tag : new CompoundTag()));
    }

    @Override
    public boolean test(Entity entity) {
        return this.test((Tag)entity.getPersistentData());
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.toString());
    }

    public static NBTPredicate read(FriendlyByteBuf buf) {
        return NBTCompoundPredicate.parse(buf.m_130277_()).orElse(null);
    }

    public abstract String toString();

    public abstract MutableComponent getDisplay(Style var1);

    public MutableComponent getDisplay() {
        return this.getDisplay(defaultStyle);
    }

    public static class NBTCompoundPredicate
    extends NBTPredicate {
        protected final List<Pair<NBTPath, NBTPredicate>> tagMap;
        protected final List<Pair<NBTPath, NBTPredicate>> excludeTagMap;
        protected static final Shadow.shadowed.com.florianingerl.util.regex.Pattern pattern = Shadow.shadowed.com.florianingerl.util.regex.Pattern.compile("^\\{(?<p>" + nest + ")\\}$");
        protected static final Shadow.shadowed.com.florianingerl.util.regex.Pattern elemPattern = Shadow.shadowed.com.florianingerl.util.regex.Pattern.compile("\\s*+(?<pre>!?)(?<path>(?:(?:\\w++|\"(?:[^\"\\\\]++|\\\\.)*+\")\\s*+(?:\\[\\s*+[+-]?\\d++\\s*+\\]\\s*+)*+)(?:\\.(?:(?:\\w++|\"(?:[^\"\\\\]++|\\\\.)*+\")(?:\\[[+-]?\\d++\\])*+))*+)\\s*+:?+\\s*+(?(DEFINE)" + nest + ")(?<value>(?:[^()\\[\\]{}\"',]++|[\\[({](?'nest')[\\])}]|\"(?:\\\\.|[^\"]++)*+\"|'(?:\\\\.|[^']++)*+')++)");

        protected NBTCompoundPredicate(List<Pair<NBTPath, NBTPredicate>> tagMap, List<Pair<NBTPath, NBTPredicate>> excludeTagMap) {
            this.tagMap = tagMap;
            this.excludeTagMap = excludeTagMap;
        }

        public static Optional<NBTPredicate> parse(String str) {
            Matcher m = pattern.matcher(str.trim());
            if (m.matches()) {
                String p = m.group("p");
                Matcher e = elemPattern.matcher(p);
                ArrayList<Pair<NBTPath, NBTPredicate>> tagMap = new ArrayList<Pair<NBTPath, NBTPredicate>>();
                ArrayList<Pair<NBTPath, NBTPredicate>> excludeTagMap = new ArrayList<Pair<NBTPath, NBTPredicate>>();
                while (e.find()) {
                    String pre = e.group("pre");
                    try {
                        NBTPath path = new NBTPath(e.group("path"));
                        String v = e.group("value");
                        Optional<NBTPredicate> opt = NBTPredicate.parseNode(v);
                        if (opt.isEmpty()) {
                            return Optional.empty();
                        }
                        NBTPredicate value = opt.get();
                        if (pre.equals("!")) {
                            excludeTagMap.add((Pair<NBTPath, NBTPredicate>)Pair.of((Object)path, (Object)value));
                            continue;
                        }
                        tagMap.add((Pair<NBTPath, NBTPredicate>)Pair.of((Object)path, (Object)value));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new NBTPredicateParseException(str, "Invalid NBT path: \"" + e.group("path") + "\"", ex);
                    }
                }
                return Optional.of(new NBTCompoundPredicate(tagMap, excludeTagMap));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(@Nullable Tag nbt) {
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if (!(nbt instanceof CompoundTag)) {
                return false;
            }
            CompoundTag com = (CompoundTag)nbt;
            for (Map.Entry entry : this.tagMap) {
                if (((NBTPredicate)entry.getValue()).test(((NBTPath)entry.getKey()).apply((Tag)com))) continue;
                return false;
            }
            for (Map.Entry entry : this.excludeTagMap) {
                if (!((NBTPredicate)entry.getValue()).test(((NBTPath)entry.getKey()).apply((Tag)com))) continue;
                return false;
            }
            return true;
        }

        @Override
        public Optional<Tag> generateValid() {
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry entry : this.tagMap) {
                Optional<Tag> opt = ((NBTPredicate)entry.getValue()).generateValid();
                if (opt.isEmpty()) {
                    return Optional.empty();
                }
                if (((NBTPath)entry.getKey()).makePath((Tag)nbt, opt.get())) continue;
                return Optional.empty();
            }
            for (Map.Entry entry : this.excludeTagMap) {
                if (!((NBTPredicate)entry.getValue()).test(((NBTPath)entry.getKey()).apply((Tag)nbt))) continue;
                return Optional.empty();
            }
            return Optional.of(nbt);
        }

        @Override
        public boolean isUnique() {
            return false;
        }

        @Override
        public String toString() {
            String sep = this.tagMap.isEmpty() || this.excludeTagMap.isEmpty() ? "" : ", ";
            return "{" + this.tagMap.stream().map(p -> ((NBTPath)p.getKey()).toString() + ": " + ((NBTPredicate)p.getValue()).toString()).collect(Collectors.joining(", ")) + sep + this.excludeTagMap.stream().map(p -> "!" + ((NBTPath)p.getKey()).toString() + ": " + ((NBTPredicate)p.getValue()).toString()).collect(Collectors.joining(", ")) + "}";
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            Pair<NBTPath, NBTPredicate> e;
            int i;
            MutableComponent tc = TextUtil.stc("{").m_130940_(style.operatorStyle);
            int s = this.tagMap.size() - 1;
            for (i = 0; i < s; ++i) {
                e = this.tagMap.get(i);
                tc = tc.m_7220_((Component)((NBTPath)e.getKey()).getDisplay(style.pathStyle)).m_7220_((Component)TextUtil.stc(": ").m_130940_(style.operatorStyle)).m_7220_((Component)((NBTPredicate)e.getValue()).getDisplay(style)).m_7220_((Component)TextUtil.stc(", ").m_130940_(style.operatorStyle));
            }
            if (!this.tagMap.isEmpty()) {
                Pair<NBTPath, NBTPredicate> last = this.tagMap.get(this.tagMap.size() - 1);
                tc = tc.m_7220_((Component)((NBTPath)last.getKey()).getDisplay(style.pathStyle)).m_7220_((Component)TextUtil.stc(": ").m_130940_(style.operatorStyle)).m_7220_((Component)((NBTPredicate)last.getValue()).getDisplay(style));
                if (!this.excludeTagMap.isEmpty()) {
                    tc = tc.m_7220_((Component)TextUtil.stc(", ").m_130940_(style.operatorStyle));
                }
            }
            s = this.excludeTagMap.size() - 1;
            for (i = 0; i < s; ++i) {
                e = this.excludeTagMap.get(i);
                tc = tc.m_7220_((Component)TextUtil.stc("!").m_130940_(style.operatorStyle)).m_7220_((Component)((NBTPath)e.getKey()).getDisplay(style.pathStyle)).m_7220_((Component)TextUtil.stc(": ").m_130940_(style.operatorStyle)).m_7220_((Component)((NBTPredicate)e.getValue()).getDisplay(style)).m_7220_((Component)TextUtil.stc(", ").m_130940_(style.operatorStyle));
            }
            if (!this.excludeTagMap.isEmpty()) {
                Pair<NBTPath, NBTPredicate> last = this.excludeTagMap.get(this.excludeTagMap.size() - 1);
                tc = tc.m_7220_((Component)((NBTPath)last.getKey()).getDisplay(style.pathStyle)).m_7220_((Component)TextUtil.stc(": ").m_130940_(style.operatorStyle)).m_7220_((Component)((NBTPredicate)last.getValue()).getDisplay(style));
            }
            return tc.m_7220_((Component)TextUtil.stc("}").m_130940_(style.operatorStyle));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NBTCompoundPredicate that = (NBTCompoundPredicate)o;
            return Objects.equals(this.tagMap, that.tagMap) && Objects.equals(this.excludeTagMap, that.excludeTagMap);
        }

        public int hashCode() {
            return Objects.hash(this.tagMap, this.excludeTagMap);
        }
    }

    public static class Style {
        public ChatFormatting operatorStyle = ChatFormatting.GOLD;
        public ChatFormatting numberStyle = ChatFormatting.DARK_AQUA;
        public ChatFormatting stringStyle = ChatFormatting.DARK_GREEN;
        public ChatFormatting quoteStyle = ChatFormatting.GOLD;
        public NBTPath.Style pathStyle = new NBTPath.Style();
    }

    public static class NBTNumericPredicate
    extends NBTPredicate {
        public final double min;
        public final double max;
        public final boolean includeMin;
        public final boolean includeMax;
        public final String type;
        protected final Function<Double, NumericTag> converter;
        protected Optional<NumericTag> valid = null;
        protected static final Pattern pattern = Pattern.compile("(?:(?<pre>[\\[(])\\s*+(?<min>[+-]?+(?:\\d++\\.)?+\\d++)?\\s*+~\\s*+(?<max>[+-]?+(?:\\d++\\.)?+\\d++)?+\\s*+(?<pos>[])])|(?<com>[><]=?+)?+\\s*+(?<value>[+-]?+(?:\\d++\\.)?+\\d++))(?<type>[BSILFD])?+", 2);
        protected static final Map<String, Function<Double, NumericTag>> typeMap = (Map)Util.m_137469_(new HashMap(), m -> {
            m.put("B", d -> ByteTag.m_128266_((byte)d.byteValue()));
            m.put("S", d -> ShortTag.m_129258_((short)d.shortValue()));
            m.put("I", d -> IntTag.m_128679_((int)d.intValue()));
            m.put("L", d -> LongTag.m_128882_((long)d.longValue()));
            m.put("F", d -> FloatTag.m_128566_((float)d.floatValue()));
            m.put("D", DoubleTag::m_128500_);
        });
        protected static final List<Double> stepAttempts = ImmutableList.of((Object)0.5, (Object)1.0, (Object)2.0, (Object)5.0, (Object)10.0, (Object)0.2, (Object)0.1, (Object)0.01);

        protected NBTNumericPredicate(double min, double max, boolean includeMin, boolean includeMax, @Nullable String type) {
            if (type != null && !typeMap.containsKey(type = type.toUpperCase())) {
                throw new IllegalArgumentException("Unknown numeric NBT type: \"" + type + "\"");
            }
            this.min = min;
            this.max = max;
            this.includeMin = includeMin;
            this.includeMax = includeMax;
            this.type = type;
            this.converter = type != null ? typeMap.get(type) : null;
        }

        public static Optional<NBTPredicate> parse(String str) {
            java.util.regex.Matcher m = pattern.matcher(str.trim());
            if (m.matches()) {
                String v = m.group("value");
                String t = m.group("type");
                if (t != null && !typeMap.containsKey(t.toUpperCase())) {
                    throw new NBTPredicateParseException(str, "Unknown numeric NBT type: \"" + t + "\"");
                }
                if (v != null) {
                    double d = Double.parseDouble(v);
                    String com = m.group("com");
                    if (com != null) {
                        switch (com) {
                            case "<": {
                                return Optional.of(new NBTNumericPredicate(Double.NEGATIVE_INFINITY, d, true, false, t));
                            }
                            case ">": {
                                return Optional.of(new NBTNumericPredicate(d, Double.POSITIVE_INFINITY, false, true, t));
                            }
                            case "<=": {
                                return Optional.of(new NBTNumericPredicate(Double.NEGATIVE_INFINITY, d, true, true, t));
                            }
                            case ">=": {
                                return Optional.of(new NBTNumericPredicate(d, Double.POSITIVE_INFINITY, true, true, t));
                            }
                        }
                    }
                    return Optional.of(new NBTNumericPredicate(d, d, true, true, t));
                }
                String min_s = m.group("min");
                String max_s = m.group("max");
                double min = min_s != null ? Double.parseDouble(min_s) : Double.NEGATIVE_INFINITY;
                double max = max_s != null ? Double.parseDouble(max_s) : Double.POSITIVE_INFINITY;
                boolean includeMin = m.group("pre").equals("[");
                boolean includeMax = m.group("pos").equals("]");
                return Optional.of(new NBTNumericPredicate(min, max, includeMin, includeMax, t));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(@Nullable Tag nbt) {
            if (nbt == null) {
                nbt = DoubleTag.f_128493_;
            }
            if (!(nbt instanceof NumericTag)) {
                return false;
            }
            double value = ((NumericTag)nbt).m_7061_();
            return (this.includeMin ? this.min <= value : this.min < value) && (this.includeMax ? value <= this.max : value < this.max);
        }

        @Override
        public Optional<Tag> generateValid() {
            if (this.valid == null) {
                this.valid = this.genValid();
            }
            return this.valid;
        }

        protected Optional<NumericTag> genValid() {
            if (this.min == this.max) {
                NumericTag nbt;
                if (this.includeMin && this.includeMax && this.test((Tag)(nbt = this.wrap(this.min)))) {
                    return Optional.of(nbt);
                }
                return Optional.empty();
            }
            if (this.min >= 0.0) {
                NumericTag nbt;
                if (this.includeMin) {
                    return Optional.of(this.wrap(this.min));
                }
                for (double step : stepAttempts) {
                    if (!(this.min + step < this.max) || !this.test((Tag)(nbt = this.wrap(this.min + step)))) continue;
                    return Optional.of(nbt);
                }
                nbt = this.wrap((this.min + this.max) / 2.0);
                if (this.test((Tag)nbt)) {
                    return Optional.of(nbt);
                }
                if (this.includeMax && this.test((Tag)(nbt = this.wrap(this.max)))) {
                    return Optional.of(nbt);
                }
                return Optional.empty();
            }
            if (this.max <= 0.0) {
                NumericTag nbt;
                if (this.includeMax) {
                    return Optional.of(this.wrap(this.max));
                }
                for (double step : stepAttempts) {
                    if (!(this.max - step > this.min) || !this.test((Tag)(nbt = this.wrap(this.max - step)))) continue;
                    return Optional.of(nbt);
                }
                nbt = this.wrap((this.min + this.max) / 2.0);
                if (this.test((Tag)nbt)) {
                    return Optional.of(nbt);
                }
                if (this.includeMin && this.test((Tag)(nbt = this.wrap(this.min)))) {
                    return Optional.of(nbt);
                }
                return Optional.empty();
            }
            return Optional.of(this.wrap(0.0));
        }

        protected NumericTag wrap(double value) {
            if (this.converter != null) {
                return this.converter.apply(value);
            }
            if ((double)Math.round(value) == value) {
                if (-2.147483648E9 <= value && value <= 2.147483647E9) {
                    return IntTag.m_128679_((int)((int)value));
                }
                return LongTag.m_128882_((long)((long)value));
            }
            return DoubleTag.m_128500_((double)value);
        }

        @Override
        public boolean isUnique() {
            return this.min == this.max;
        }

        @Override
        public String toString() {
            String t;
            String string = t = this.type != null ? this.type : "";
            if (this.min == this.max && this.includeMin && this.includeMax) {
                return this.min + t;
            }
            if (this.min == Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY && this.includeMin) {
                return (this.includeMax ? "<=" : "<") + " " + this.max + t;
            }
            if (this.max == Double.POSITIVE_INFINITY && this.min != Double.NEGATIVE_INFINITY && this.includeMax) {
                return (this.includeMin ? ">=" : ">") + " " + this.min + t;
            }
            return (this.includeMin ? "[" : "(") + this.min + "~" + this.max + (this.includeMax ? "]" : ")") + t;
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            MutableComponent type;
            MutableComponent mutableComponent = type = this.type != null ? TextUtil.stc(this.type).m_130940_(style.operatorStyle) : TextUtil.stc("");
            if (this.min == this.max && this.includeMin && this.includeMax) {
                return TextUtil.stc(this.min).m_130940_(style.numberStyle).m_7220_((Component)type);
            }
            if (this.min == Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY && this.includeMin) {
                return TextUtil.stc(this.includeMax ? "<= " : "< ").m_130940_(style.operatorStyle).m_7220_((Component)TextUtil.stc(this.max).m_130940_(style.numberStyle)).m_7220_((Component)type);
            }
            if (this.max == Double.POSITIVE_INFINITY && this.min != Double.NEGATIVE_INFINITY && this.includeMax) {
                return TextUtil.stc(this.includeMin ? ">= " : "> ").m_130940_(style.operatorStyle).m_7220_((Component)TextUtil.stc(this.min).m_130940_(style.numberStyle)).m_7220_((Component)type);
            }
            return TextUtil.stc(this.includeMin ? "[" : "(").m_130940_(style.operatorStyle).m_7220_((Component)TextUtil.stc(this.min).m_130940_(style.numberStyle)).m_7220_((Component)TextUtil.stc("~").m_130940_(style.operatorStyle)).m_7220_((Component)TextUtil.stc(this.max).m_130940_(style.numberStyle)).m_7220_((Component)TextUtil.stc(this.includeMax ? "]" : ")").m_130940_(style.operatorStyle)).m_7220_((Component)type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NBTNumericPredicate that = (NBTNumericPredicate)o;
            return Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.includeMin == that.includeMin && this.includeMax == that.includeMax && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max, this.includeMin, this.includeMax, this.type);
        }
    }

    public static class NBTStringPredicate
    extends NBTPredicate {
        public final String value;
        public final Pattern pattern;
        private static final Pattern parsePattern = Pattern.compile("(?<pre>~)?\\s*\"(?<value>(?:\\\\.|[^\"\\\\]++)*+)\"");
        protected static final RgxGenProperties rgxGenProperties = new RgxGenProperties();

        public NBTStringPredicate(String value) {
            this.value = value;
            this.pattern = null;
        }

        public NBTStringPredicate(Pattern pattern) {
            this.value = null;
            this.pattern = pattern;
        }

        public static Optional<NBTPredicate> parse(String str) {
            java.util.regex.Matcher m = parsePattern.matcher(str.trim());
            if (m.matches()) {
                String pre = m.group("pre");
                String value = StringEscapeUtils.unescapeJava((String)m.group("value"));
                if (pre != null) {
                    try {
                        return Optional.of(new NBTStringPredicate(Pattern.compile(value)));
                    }
                    catch (PatternSyntaxException e) {
                        throw new NBTPredicateParseException(str, "Error parsing regex", e);
                    }
                }
                return Optional.of(new NBTStringPredicate(value));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(@Nullable Tag nbt) {
            if (nbt == null) {
                nbt = StringTag.m_129297_((String)"");
            }
            if (!(nbt instanceof StringTag)) {
                return false;
            }
            if (this.value != null) {
                return this.value.equals(nbt.m_7916_());
            }
            if (this.pattern != null) {
                return this.pattern.matcher(nbt.m_7916_()).matches();
            }
            return true;
        }

        @Override
        public Optional<Tag> generateValid() {
            if (this.value != null) {
                return Optional.of(StringTag.m_129297_((String)this.value));
            }
            if (this.pattern != null) {
                try {
                    RgxGen rgxGen = new RgxGen(this.pattern.pattern());
                    rgxGen.setProperties(rgxGenProperties);
                    return Optional.of(StringTag.m_129297_((String)rgxGen.generate()));
                }
                catch (RgxGenParseException e) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }

        @Override
        public boolean isUnique() {
            return this.value != null;
        }

        @Override
        public String toString() {
            if (this.value != null) {
                return "\"" + StringEscapeUtils.escapeJava((String)this.value) + "\"";
            }
            if (this.pattern != null) {
                return "~\"" + StringEscapeUtils.escapeJava((String)this.pattern.pattern()) + "\"";
            }
            return "";
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            if (this.value != null) {
                return TextUtil.stc("\"").m_7220_((Component)TextUtil.stc(StringEscapeUtils.escapeJava((String)this.value)).m_130940_(style.stringStyle)).m_130946_("\"").m_130940_(style.quoteStyle);
            }
            if (this.pattern != null) {
                return TextUtil.stc("~\"").m_7220_((Component)TextUtil.stc(StringEscapeUtils.escapeJava((String)this.pattern.pattern())).m_130940_(style.stringStyle)).m_130946_("\"").m_130940_(style.quoteStyle);
            }
            return TextUtil.stc("");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NBTStringPredicate that = (NBTStringPredicate)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.pattern);
        }

        static {
            RgxGenOption.INFINITE_PATTERN_REPETITION.setInProperties(rgxGenProperties, 16);
        }
    }

    public static class NBTListPredicate
    extends NBTPredicate {
        public List<NBTPredicate> list;
        public ComparisonMode mode;
        protected static final Shadow.shadowed.com.florianingerl.util.regex.Pattern pattern = Shadow.shadowed.com.florianingerl.util.regex.Pattern.compile("^(?<m>[=~<>]?|<<|>>|><)\\[(?<p>" + nest + ")]$");
        protected static final Shadow.shadowed.com.florianingerl.util.regex.Pattern elemPattern = Shadow.shadowed.com.florianingerl.util.regex.Pattern.compile("(?(DEFINE)" + nest + ")(?<p>(?:[^()\\[\\]{}\"',]++|[\\[({](?'nest')[\\])}]|\"(?:\\\\.|[^\"]++)*+\"|'(?:\\\\.|[^']++)*+')++)");

        protected NBTListPredicate(List<NBTPredicate> list, ComparisonMode mode) {
            this.list = list;
            this.mode = mode;
        }

        public static Optional<NBTPredicate> parse(String str) {
            Matcher m = pattern.matcher(str.trim());
            if (m.matches()) {
                String p = m.group("p");
                String mode_s = m.group("m");
                ComparisonMode mode = ComparisonMode.fromSymbol(mode_s);
                if (mode == null) {
                    throw new NBTPredicateParseException(str, "Unknown list comparison mode: \"" + mode_s + "\"");
                }
                Matcher e = elemPattern.matcher(p);
                ArrayList<NBTPredicate> list = new ArrayList<NBTPredicate>();
                Class<?> cls = null;
                String numeric_type = null;
                while (e.find()) {
                    String el = e.group("p");
                    Optional<NBTPredicate> opt = NBTPredicate.parseNode(el);
                    if (opt.isEmpty()) {
                        return Optional.empty();
                    }
                    NBTPredicate pr = opt.get();
                    if (cls == null) {
                        cls = pr.getClass();
                    } else if (cls != pr.getClass()) {
                        throw new NBTPredicateParseException(str, "Different NBT types in array");
                    }
                    if (pr instanceof NBTNumericPredicate) {
                        String t = ((NBTNumericPredicate)pr).type;
                        if (numeric_type == null) {
                            numeric_type = t;
                        } else if (!numeric_type.equals(t)) {
                            throw new NBTPredicateParseException(str, "Different NBT types in array");
                        }
                    }
                    list.add(pr);
                }
                return Optional.of(new NBTListPredicate(list, mode));
            }
            return Optional.empty();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean test(@Nullable Tag nbt) {
            Object value;
            if (nbt == null) {
                nbt = new ListTag();
            }
            if (nbt instanceof LongArrayTag) {
                value = ((LongArrayTag)nbt).m_128851_();
                nbt = new ListTag();
                for (long v2 : value) {
                    ((ListTag)nbt).add((Object)LongTag.m_128882_((long)v2));
                }
            } else if (nbt instanceof IntArrayTag) {
                value = ((IntArrayTag)nbt).m_128648_();
                nbt = new ListTag();
                for (long v3 : value) {
                    ((ListTag)nbt).add((Object)IntTag.m_128679_((int)v3));
                }
            } else if (nbt instanceof ByteArrayTag) {
                value = ((ByteArrayTag)nbt).m_128227_();
                nbt = new ListTag();
                for (long v4 : value) {
                    ((ListTag)nbt).add((Object)ByteTag.m_128266_((byte)v4));
                }
            }
            if (!(nbt instanceof ListTag)) {
                return false;
            }
            value = (ListTag)nbt.m_6426_();
            switch (this.mode) {
                case EXACT_MATCH: {
                    if (value.size() != this.list.size()) {
                        return false;
                    }
                    boolean bl = false;
                    while (true) {
                        void var3_8;
                        if (var3_8 >= value.size()) {
                            return true;
                        }
                        if (!this.list.get((int)var3_8).test(value.get((int)var3_8))) {
                            return false;
                        }
                        ++var3_8;
                    }
                }
                case CONTAIN_ANY: {
                    if (this.list.isEmpty()) {
                        return value.isEmpty();
                    }
                    Iterator iterator = value.iterator();
                    block13: while (true) {
                        NBTPredicate nbtPredicate;
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        Tag tag = (Tag)iterator.next();
                        Iterator<NBTPredicate> iterator2 = this.list.iterator();
                        do {
                            if (!iterator2.hasNext()) continue block13;
                        } while (!(nbtPredicate = iterator2.next()).test(tag));
                        break;
                    }
                    return true;
                }
                case CONTAIN_ALL: {
                    return this.checkMatch((List)this.list, (List)value, (BiPredicate)NBTPredicate::test, (BiPredicate)(p, v) -> p.isUnique());
                }
                case SUBSET: {
                    return this.checkMatch((List)value, (List)this.list, (BiPredicate)(v, p) -> p.test((Tag)v), (BiPredicate)(v, p) -> p.isUnique());
                }
                case STARTS_WITH: {
                    if (value.size() < this.list.size()) {
                        return false;
                    }
                    boolean bl = false;
                    int n = this.list.size();
                    while (true) {
                        void var3_11;
                        if (var3_11 >= n) {
                            return true;
                        }
                        if (!this.list.get((int)var3_11).test(value.get((int)var3_11))) {
                            return false;
                        }
                        ++var3_11;
                    }
                }
                case ENDS_WITH: {
                    if (value.size() < this.list.size()) {
                        return false;
                    }
                    boolean bl = false;
                    int n = this.list.size();
                    int valueSize = value.size();
                    while (true) {
                        void var3_13;
                        if (var3_13 >= n) {
                            return true;
                        }
                        if (!this.list.get((int)var3_13).test(value.get(valueSize - n + var3_13))) {
                            return false;
                        }
                        ++var3_13;
                    }
                }
                case CONTAINS_SEQUENCE: {
                    if (value.size() < this.list.size()) {
                        return false;
                    }
                    boolean bl = false;
                    int n = value.size() - this.list.size();
                    void var3_15;
                    block17: while (var3_15 <= n) {
                        int j = 0;
                        int listSize = this.list.size();
                        while (true) {
                            if (j >= listSize) {
                                return true;
                            }
                            if (!this.list.get(j).test(value.get((int)(var3_15 + j)))) {
                                ++var3_15;
                                continue block17;
                            }
                            ++j;
                        }
                        break;
                    }
                    return false;
                }
            }
            throw new IllegalStateException("Comparison mode cannot be null");
        }

        @Override
        public Optional<Tag> generateValid() {
            ArrayList<Tag> res = new ArrayList<Tag>();
            switch (this.mode) {
                case EXACT_MATCH: 
                case CONTAIN_ALL: 
                case STARTS_WITH: 
                case ENDS_WITH: 
                case CONTAINS_SEQUENCE: {
                    for (NBTPredicate p : this.list) {
                        Optional<Tag> opt = p.generateValid();
                        if (opt.isEmpty()) {
                            return Optional.empty();
                        }
                        res.add(opt.get());
                    }
                    break;
                }
                case CONTAIN_ANY: {
                    if (!this.list.isEmpty()) {
                        for (NBTPredicate p : this.list) {
                            Optional<Tag> opt = p.generateValid();
                            if (!opt.isPresent()) continue;
                            res.add(opt.get());
                            break;
                        }
                        if (res.isEmpty()) {
                            return Optional.empty();
                        }
                    }
                }
                case SUBSET: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Comparison mode cannot be null");
                }
            }
            ListTag nbt = new ListTag();
            try {
                nbt.addAll(res);
            }
            catch (UnsupportedOperationException e) {
                return Optional.empty();
            }
            return Optional.of(nbt);
        }

        protected <A, B> boolean checkMatch(List<A> aList, List<B> bList, BiPredicate<A, B> matcher, BiPredicate<A, B> unique) {
            if (aList.isEmpty()) {
                return true;
            }
            for (A a : aList) {
                for (B b : bList) {
                    if (!matcher.test(a, b)) continue;
                    if (aList.size() == 1) {
                        return true;
                    }
                    ArrayList<A> al = new ArrayList<A>(aList);
                    al.remove(a);
                    ArrayList<B> bl = new ArrayList<B>(bList);
                    bl.remove(b);
                    if (this.checkMatch(al, bl, matcher, unique)) {
                        return true;
                    }
                    if (!unique.test(a, b)) continue;
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean isUnique() {
            return this.mode == ComparisonMode.EXACT_MATCH && this.list.stream().allMatch(NBTPredicate::isUnique);
        }

        @Override
        public String toString() {
            return "[" + this.list.stream().map(NBTPredicate::toString).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            MutableComponent tc = TextUtil.stc(this.mode.alias + "[").m_130940_(style.operatorStyle);
            int listSize = this.list.size() - 1;
            for (int i = 0; i < listSize; ++i) {
                NBTPredicate pr = this.list.get(i);
                tc = tc.m_7220_((Component)pr.getDisplay(style)).m_7220_((Component)TextUtil.stc(", ").m_130940_(style.operatorStyle));
            }
            return tc.m_7220_((Component)this.list.get(this.list.size() - 1).getDisplay(style)).m_7220_((Component)TextUtil.stc("]").m_130940_(style.operatorStyle));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NBTListPredicate that = (NBTListPredicate)o;
            return this.list.equals(that.list) && this.mode == that.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.list, this.mode});
        }

        public static enum ComparisonMode {
            EXACT_MATCH("", "="),
            CONTAIN_ANY("~"),
            CONTAIN_ALL(">"),
            SUBSET("<"),
            STARTS_WITH("<<"),
            ENDS_WITH(">>"),
            CONTAINS_SEQUENCE("><");

            private final String alias;
            private final String secondAlias;

            private ComparisonMode(String alias) {
                this(alias, null);
            }

            private ComparisonMode(String alias, String secondAlias) {
                this.alias = alias;
                this.secondAlias = secondAlias;
            }

            @Nullable
            public static ComparisonMode fromSymbol(String symbol) {
                return Arrays.stream(ComparisonMode.values()).filter(v -> v.alias.equals(symbol) || v.secondAlias != null && v.secondAlias.equals(symbol)).findFirst().orElse(null);
            }
        }
    }

    public static class NBTPredicateParseException
    extends RuntimeException {
        public final String parsedString;

        public NBTPredicateParseException(String str, String msg, Exception cause) {
            super(msg + ":\n\t" + str, cause);
            this.parsedString = str;
        }

        public NBTPredicateParseException(String str, String msg) {
            super(msg + ":\n\t" + str);
            this.parsedString = str;
        }
    }
}

