/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.nbt;

import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTPath
implements Comparable<NBTPath>,
Iterable<Node> {
    protected final List<Node> list;
    public static Style defaultStyle = new Style();
    protected static final Pattern nodePattern = Pattern.compile("(?<name>\\w++|\"(?:[^\"\\\\]++|\\\\.)*+\")\\s*+(?<arr>(?:\\[\\s*+[+-]?\\d++\\s*+]\\s*+)*+)");
    protected static final Pattern lenientNodePattern = Pattern.compile("(?<name>\"(?:[^\"\\\\]++|\\\\.)*+\"|[^\".][^.]*+)\\s*+(?<arr>(?:\\[\\s*+[+-]?\\d++\\s*+]\\s*+)*+)");
    protected static final Pattern pattern = Pattern.compile("(?:" + nodePattern.pattern() + "(?:\\.|$))*+(?<!\\.)");
    protected static final Pattern lenientPattern = Pattern.compile("(?:" + lenientNodePattern.pattern() + "(?:\\.|$))*+(?<!\\.)");

    public static Iterable<Map.Entry<NBTPath, Tag>> traverse(CompoundTag nbt) {
        return () -> new CompoundNBTIterator(nbt, new NBTPath(new ArrayList<Node>()));
    }

    public NBTPath(String path) {
        path = path.trim();
        if (!lenientPattern.matcher(path).matches()) {
            throw new IllegalArgumentException("Invalid NBT path: \"" + path + "\"");
        }
        Matcher m = lenientNodePattern.matcher(path);
        ArrayList<Node> list = new ArrayList<Node>();
        while (m.find()) {
            String[] split;
            String name = m.group("name");
            if (name.startsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            list.add(new TagNode(name));
            String arr = m.group("arr").trim();
            if (arr.isEmpty()) continue;
            for (String s : split = arr.substring(1, arr.length() - 1).trim().split("\\s*+]\\s*+\\[\\s*+")) {
                list.add(new ListNode(Integer.parseInt(s)));
            }
        }
        this.list = list;
    }

    public boolean makePath(Tag root) {
        return this.makePath(root, null);
    }

    public boolean makePath(Tag root, @Nullable Tag value) {
        Tag copy;
        Tag child = copy = root.m_6426_();
        Node nextNode = null;
        int s = this.list.size() - 1;
        for (int i = 0; i < s; ++i) {
            Node node = this.list.get(i);
            nextNode = this.list.get(i + 1);
            if (child instanceof CompoundTag && node instanceof TagNode) {
                String key = ((TagNode)node).name;
                if (!((CompoundTag)child).m_128441_(key)) {
                    ((CompoundTag)child).m_128365_(key, nextNode.buildParent());
                }
            } else if (child instanceof ListTag && node instanceof ListNode) {
                int index = ((ListNode)node).index;
                int len = ((ListTag)child).size();
                if (index > len || index < -len) {
                    return false;
                }
                if (index == len) {
                    try {
                        ((ListTag)child).add((Object)nextNode.buildParent());
                    }
                    catch (UnsupportedOperationException ignored) {
                        return false;
                    }
                }
            } else {
                return false;
            }
            child = node.apply(child);
            if (child != null) continue;
            return false;
        }
        if (nextNode instanceof TagNode && !(child instanceof CompoundTag) || nextNode instanceof ListNode && (!(child instanceof ListTag) || ((ListTag)child).size() > Math.abs(((ListNode)nextNode).index))) {
            return false;
        }
        if (nextNode == null) {
            nextNode = this.list.get(this.list.size() - 1);
        }
        if (value != null) {
            if (nextNode.exists(child)) {
                if (!nextNode.apply(child).equals(value)) {
                    return false;
                }
            } else if (nextNode instanceof TagNode) {
                ((CompoundTag)child).m_128365_(((TagNode)nextNode).name, value);
            } else if (nextNode instanceof ListNode) {
                int index = ((ListNode)nextNode).index;
                int len = ((ListTag)child).size();
                if (index == len) {
                    try {
                        ((ListTag)child).add((Object)value);
                    }
                    catch (UnsupportedOperationException ignored) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        Node first = this.list.get(0);
        if (root instanceof CompoundTag && first instanceof TagNode) {
            String key = ((TagNode)first).name;
            ((CompoundTag)root).m_128365_(key, ((CompoundTag)copy).m_128423_(key));
        } else if (root instanceof ListTag && first instanceof ListNode) {
            int index = ((ListNode)first).index;
            int len = ((ListTag)root).size();
            if (index < 0) {
                index = len + index;
            }
            if (index == len) {
                ((ListTag)root).add((Object)((ListTag)copy).get(index));
            } else {
                ((ListTag)root).set(index, ((ListTag)copy).get(index));
            }
        }
        return true;
    }

    public boolean exists(Tag root) {
        Tag child = root;
        for (Node node : this.list) {
            if (!node.exists(child)) {
                return false;
            }
            if ((child = node.apply(child)) != null) continue;
            return false;
        }
        return true;
    }

    public NBTPath(List<Node> list) {
        this.list = new ArrayList<Node>(list);
    }

    public NBTPath(NBTPath other) {
        this(other.list);
    }

    public boolean contains(String other) {
        return this.contains(new NBTPath(other));
    }

    public boolean contains(NBTPath other) {
        int s = this.list.size();
        if (other.list.size() < s) {
            return false;
        }
        for (int i = 0; i < s; ++i) {
            if (this.list.get(i).equals(other.list.get(i))) continue;
            return false;
        }
        return true;
    }

    public NBTPath relativize(String other) {
        return this.relativize(new NBTPath(other));
    }

    public NBTPath relativize(NBTPath other) {
        int s = this.list.size();
        if (other.list.size() < s) {
            throw new IllegalArgumentException("Cannot relativize a shorter path");
        }
        if (!this.contains(other)) {
            throw new IllegalArgumentException("Relativized path is not a child path");
        }
        return new NBTPath(other.list.subList(this.list.size(), other.list.size()));
    }

    public NBTPath resolve(String other) {
        return this.resolve(new NBTPath(other));
    }

    public NBTPath resolve(NBTPath other) {
        ArrayList<Node> result = new ArrayList<Node>(this.list);
        result.addAll(other.list);
        return new NBTPath(result);
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.list);
    }

    public boolean isRoot() {
        return this.list.isEmpty();
    }

    @Nullable
    public NBTPath parent() {
        return this.list.isEmpty() ? null : new NBTPath((List)Util.m_137469_(new ArrayList<Node>(this.list), l -> l.remove(l.size() - 1)));
    }

    @Nullable
    public Tag apply(Tag nbt) {
        if (nbt == null) {
            return null;
        }
        Tag child = nbt;
        for (Node node : this.list) {
            child = node.apply(child);
            if (child != null) continue;
            return null;
        }
        return child;
    }

    public boolean delete(Tag nbt) {
        if (nbt == null) {
            return false;
        }
        if (this.list.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete a root path");
        }
        Tag child = nbt;
        int last = this.list.size() - 1;
        for (Node node : this.list.subList(0, last)) {
            child = node.apply(child);
            if (child != null) continue;
            return false;
        }
        return this.list.get(last).delete(child);
    }

    @Deprecated
    public NBTPath copy() {
        return new NBTPath(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTPath nbtPath = (NBTPath)o;
        return this.list.equals(nbtPath.list);
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }

    public String toString() {
        Node last = null;
        StringBuilder str = new StringBuilder();
        for (Node node : this.list) {
            if (node instanceof TagNode && last != null) {
                str.append(".");
            }
            str.append(node.toString());
            last = node;
        }
        return str.toString();
    }

    public MutableComponent getDisplay(Style style) {
        Node last = null;
        MutableComponent tc = TextUtil.stc("");
        for (Node node : this.list) {
            if (node instanceof TagNode && last != null) {
                tc = tc.m_7220_((Component)TextUtil.stc(".").m_130940_(style.dotStyle));
            }
            tc = tc.m_7220_((Component)node.getDisplay(style));
            last = node;
        }
        return tc;
    }

    public MutableComponent getDisplay() {
        return this.getDisplay(defaultStyle);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public int compareTo(@NotNull NBTPath o) {
        int size = Math.min(this.size(), o.size());
        for (int i = 0; i < size; ++i) {
            int c = this.list.get(i).compareTo(o.list.get(i));
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(this.size(), o.size());
    }

    @Override
    @NotNull
    public Iterator<Node> iterator() {
        return new NBTNodeIterator(this);
    }

    public static class TagNode
    extends Node {
        public final String name;
        protected final Pattern simple = Pattern.compile("^\\w*+$");

        public TagNode(String name) {
            this.name = Objects.requireNonNull(name);
        }

        @Override
        @Nullable
        public Tag apply(Tag nbt) {
            return nbt instanceof CompoundTag ? ((CompoundTag)nbt).m_128423_(this.name) : null;
        }

        @Override
        public boolean exists(Tag nbt) {
            return nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128441_(this.name);
        }

        @Override
        public Tag buildParent() {
            return new CompoundTag();
        }

        @Override
        public boolean delete(Tag nbt) {
            if (nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128441_(this.name)) {
                ((CompoundTag)nbt).m_128473_(this.name);
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagNode tagNode = (TagNode)o;
            return this.name.equals(tagNode.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.simple.matcher(this.name).matches() ? this.name : "\"" + StringEscapeUtils.escapeJava((String)this.name) + "\"";
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            return this.simple.matcher(this.name).matches() ? TextUtil.stc(this.name).m_130940_(style.nameStyle) : TextUtil.stc("\"").m_7220_((Component)TextUtil.stc(StringEscapeUtils.escapeJava((String)this.name)).m_130940_(style.nameStyle)).m_130946_("\"").m_130940_(style.quoteStyle);
        }

        @Override
        public int compareTo(@NotNull Node o) {
            if (o instanceof ListNode) {
                return 1;
            }
            if (o instanceof TagNode) {
                return this.name.compareTo(((TagNode)o).name);
            }
            return -1;
        }
    }

    public static class ListNode
    extends Node {
        public final int index;

        public ListNode(int index) {
            this.index = index;
        }

        @Override
        @Nullable
        public Tag apply(Tag nbt) {
            return nbt instanceof CollectionTag ? this.apply((CollectionTag)nbt) : null;
        }

        @Override
        public Tag buildParent() {
            return new ListTag();
        }

        @Override
        public boolean exists(Tag nbt) {
            if (!(nbt instanceof CollectionTag)) {
                return false;
            }
            int s = ((CollectionTag)nbt).size();
            return this.index < s && this.index >= -s;
        }

        @Nullable
        protected Tag apply(CollectionTag<?> list) {
            if (this.index < 0) {
                int i = list.size() + this.index;
                if (i < 0) {
                    return null;
                }
                return (Tag)list.get(i);
            }
            if (this.index >= list.size()) {
                return null;
            }
            return (Tag)list.get(this.index);
        }

        @Override
        public boolean delete(Tag nbt) {
            if (nbt instanceof CollectionTag) {
                int i;
                int s = ((CollectionTag)nbt).size();
                int n = i = this.index < 0 ? s + this.index : this.index;
                if (i < s) {
                    ((CollectionTag)nbt).remove(i);
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListNode listNode = (ListNode)o;
            return this.index == listNode.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return "[" + this.index + "]";
        }

        @Override
        public MutableComponent getDisplay(Style style) {
            return TextUtil.stc("[").m_7220_((Component)TextUtil.stc(String.format("%d", this.index)).m_130940_(style.indexStyle)).m_130946_("]").m_130940_(style.bracketStyle);
        }

        @Override
        public int compareTo(@NotNull Node o) {
            if (o instanceof TagNode) {
                return -1;
            }
            if (o instanceof ListNode) {
                return Integer.compare(this.index, ((ListNode)o).index);
            }
            return -1;
        }
    }

    public static abstract class Node
    implements Comparable<Node> {
        @Nullable
        public abstract Tag apply(Tag var1);

        public abstract boolean exists(Tag var1);

        public abstract Tag buildParent();

        public abstract boolean delete(Tag var1);

        public abstract MutableComponent getDisplay(Style var1);

        public MutableComponent getDisplay() {
            return this.getDisplay(defaultStyle);
        }
    }

    public static class Style {
        public ChatFormatting nameStyle = ChatFormatting.DARK_PURPLE;
        public ChatFormatting quoteStyle = ChatFormatting.GOLD;
        public ChatFormatting dotStyle = ChatFormatting.GOLD;
        public ChatFormatting indexStyle = ChatFormatting.DARK_AQUA;
        public ChatFormatting bracketStyle = ChatFormatting.GOLD;
    }

    @ApiStatus.Internal
    public static class NBTNodeIterator
    implements Iterator<Node> {
        protected Node[] nodes;
        protected int cursor = 0;

        public NBTNodeIterator(NBTPath path) {
            this.nodes = path.list.toArray(new Node[0]);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.nodes.length;
        }

        @Override
        public Node next() {
            return this.nodes[this.cursor++];
        }
    }

    protected static class CompoundNBTIterator
    implements Iterator<Map.Entry<NBTPath, Tag>> {
        protected final CompoundTag root;
        protected final NBTPath path;
        protected final Iterator<String> key;
        protected CompoundNBTIterator nest = null;
        protected Map.Entry<NBTPath, Tag> last = null;

        protected CompoundNBTIterator(CompoundTag root, NBTPath path) {
            this.root = root;
            this.key = root.m_128431_().iterator();
            this.path = path;
        }

        @Override
        public boolean hasNext() {
            return this.last != null || this.next(false) != null;
        }

        @Override
        public Map.Entry<NBTPath, Tag> next() {
            return this.next(true);
        }

        public Map.Entry<NBTPath, Tag> next(boolean use) {
            if (this.last != null) {
                Map.Entry<NBTPath, Tag> r = this.last;
                this.last = null;
                return r;
            }
            while (this.key.hasNext() || this.nest != null) {
                Map.Entry<NBTPath, Tag> nestNext;
                if (this.nest == null) {
                    String k = this.key.next();
                    Tag elem = this.root.m_128423_(k);
                    if (elem instanceof CompoundTag) {
                        this.nest = new CompoundNBTIterator((CompoundTag)elem, this.path.resolve(k));
                    } else {
                        Pair r = Pair.of((Object)this.path.resolve(k), (Object)elem);
                        if (!use) {
                            this.last = r;
                        }
                        return r;
                    }
                }
                if ((nestNext = this.nest.next(use)) != null) {
                    return nestNext;
                }
                this.nest = null;
            }
            return null;
        }
    }
}

