/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.nbt;

import endorh.lazulib.nbt.NBTPath;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTCompareHelper {
    public static boolean compareExcept(CompoundTag a, CompoundTag b, String ... excludedPaths) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        CompoundTag aCopy = a.m_6426_();
        CompoundTag bCopy = b.m_6426_();
        for (String excludedPath : excludedPaths) {
            NBTPath p = new NBTPath(excludedPath);
            if (p.isRoot()) {
                return true;
            }
            p.delete((Tag)aCopy);
            p.delete((Tag)bCopy);
        }
        return aCopy.equals((Object)bCopy);
    }

    public static boolean compareOn(CompoundTag a, CompoundTag b, String ... comparedPaths) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return Arrays.stream(comparedPaths).map(NBTPath::new).allMatch(p -> Objects.equals(p.apply((Tag)a), p.apply((Tag)b)));
    }
}

