/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.mixins;

import endorh.lazulib.common.LogUtil;
import endorh.lazulib.events.DisableElytraCheckEvent;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerMixin {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger();
    @Shadow(aliases={"player"})
    public ServerPlayer f_9743_;
    @Shadow(aliases={"firstGoodX"})
    private double f_9753_;
    @Shadow(aliases={"firstGoodY"})
    private double f_9754_;
    @Shadow(aliases={"firstGoodZ"})
    private double f_9755_;
    @Shadow(aliases={"receivedMovePacketCount"})
    private int f_9740_;
    @Shadow(aliases={"knownMovePacketCount"})
    private int f_9741_;

    @Redirect(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z", ordinal=0))
    public boolean _lazulib_shouldDisableElytraCheck(GameRules rules, GameRules.Key<GameRules.BooleanValue> key, ServerboundMovePlayerPacket packet) {
        if (key != GameRules.f_46148_) {
            LogUtil.warnOnce(LOGGER, "Mixin ServerGamePacketListenerImpl$shouldDisableElytraCheck missed its target. Conditional elytra check disabling may be impossible for mods relying on this mixin.\nYou may report this bug in the \"LazuLib\" mod issue tracker");
            return rules.m_46207_(key);
        }
        if (rules.m_46207_(key)) {
            return true;
        }
        if (!this.f_9743_.m_21255_()) {
            return false;
        }
        double pX = packet.m_134129_(this.f_9743_.m_20185_());
        double pY = packet.m_134140_(this.f_9743_.m_20186_());
        double pZ = packet.m_134146_(this.f_9743_.m_20189_());
        double dX = pX - this.f_9753_;
        double dY = pY - this.f_9754_;
        double dZ = pZ - this.f_9755_;
        double playerMotion2 = this.f_9743_.m_20184_().m_82556_();
        double playerDelta2 = dX * dX + dY * dY + dZ * dZ;
        double excess = playerDelta2 - playerMotion2;
        int stackedPackets = this.f_9740_ - this.f_9741_;
        DisableElytraCheckEvent event = new DisableElytraCheckEvent(this.f_9743_, packet, excess, stackedPackets);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getDisable();
    }
}

