/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.math;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import endorh.lazulib.math.Vec3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3f;

public class Vec3d {
    public double x;
    public double y;
    public double z;
    public static final Codec<Vec3d> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(d -> d.x), (App)Codec.DOUBLE.fieldOf("y").forGetter(d -> d.y), (App)Codec.DOUBLE.fieldOf("z").forGetter(d -> d.z)).apply((Applicative)instance, Vec3d::new));
    public static final double TO_RAD = Math.PI / 180;
    public static final double TO_DEGREES = 57.29577951308232;
    public static final double PI = Math.PI;
    public static final double PI_HALF = 1.5707963267948966;
    private static final Random random = new Random();
    public static final Supplier<Vec3d> ZERO = () -> new Vec3d(0.0, 0.0, 0.0);
    public static final Supplier<Vec3d> XP = () -> new Vec3d(1.0, 0.0, 0.0);
    public static final Supplier<Vec3d> YP = () -> new Vec3d(0.0, 1.0, 0.0);
    public static final Supplier<Vec3d> ZP = () -> new Vec3d(0.0, 0.0, 1.0);
    public static final Supplier<Vec3d> XN = () -> new Vec3d(-1.0, 0.0, 0.0);
    public static final Supplier<Vec3d> YN = () -> new Vec3d(0.0, -1.0, 0.0);
    public static final Supplier<Vec3d> ZN = () -> new Vec3d(0.0, 0.0, -1.0);
    public static String defaultFormat = "%+6.3f";

    private Vec3d() {
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(Vec3d vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vec3d(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vec3d(Vec3i vec) {
        this.x = vec.m_123341_();
        this.y = vec.m_123342_();
        this.z = vec.m_123343_();
    }

    public Vec3d(Vec3i vec, boolean center) {
        if (center) {
            this.x = (float)vec.m_123341_() + 0.5f;
            this.y = (float)vec.m_123342_() + 0.5f;
            this.z = (float)vec.m_123343_() + 0.5f;
        } else {
            this.x = vec.m_123341_();
            this.y = vec.m_123342_();
            this.z = vec.m_123343_();
        }
    }

    public Vec3d(Vector3f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public Vec3d(Vec3 vec) {
        this.x = vec.f_82479_;
        this.y = vec.f_82480_;
        this.z = vec.f_82481_;
    }

    public Vec3d(double yaw, double pitch) {
        this(yaw, pitch, true);
    }

    public Vec3d(double yaw, double pitch, boolean degrees) {
        if (degrees) {
            pitch *= Math.PI / 180;
            yaw *= Math.PI / 180;
        }
        double yawCos = Math.cos(yaw);
        double yawSin = Math.sin(yaw);
        double pitCos = Math.cos(pitch);
        double pitSin = Math.sin(pitch);
        this.x = -yawSin * pitCos;
        this.y = -pitSin;
        this.z = yawCos * pitCos;
    }

    public Vec3d(double[] array) {
        try {
            this.x = array[0];
            this.y = array[1];
            this.z = array[2];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unable to read Vec3d from array, too few elements");
        }
    }

    public Vec3d(List<Double> list) {
        try {
            this.x = list.get(0);
            this.y = list.get(1);
            this.z = list.get(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unable to read Vec3d from list, too few elements");
        }
    }

    public static Vec3d random() {
        return new Vec3d(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public static Vec3d random(double range) {
        Vec3d res = Vec3d.random();
        res.mul(2.0 * range);
        res.add(-range);
        return res;
    }

    public static Vec3d random(double min, double max) {
        Vec3d res = Vec3d.random();
        res.mul(max - min);
        res.add(min);
        return res;
    }

    public static Vec3d randomUnitary() {
        double u = random.nextDouble() * 2.0 * Math.PI;
        double v = -1.0 + random.nextDouble() * 2.0;
        double h = Math.sqrt(1.0 - v * v);
        return new Vec3d(Math.cos(u) * h, Math.sin(u) * h, v);
    }

    public static Vec3d randomSpherical() {
        double u = random.nextDouble() * 2.0 * Math.PI;
        double v = -1.0 + random.nextDouble() * 2.0;
        double r = Math.sqrt(random.nextDouble());
        double h = Math.sqrt(1.0 - v * v);
        return new Vec3d(Math.cos(u) * h * r, Math.sin(u) * h * r, v * r);
    }

    public void add(Vec3d vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void add(Vec3f vec) {
        this.x += (double)vec.x;
        this.y += (double)vec.y;
        this.z += (double)vec.z;
    }

    public void add(Vec3d vec, double scale) {
        this.x += vec.x * scale;
        this.y += vec.y * scale;
        this.z += vec.z * scale;
    }

    public void add(Vec3f vec, double scale) {
        this.x += (double)vec.x * scale;
        this.y += (double)vec.y * scale;
        this.z += (double)vec.z * scale;
    }

    public void add(double a) {
        this.x += a;
        this.y += a;
        this.z += a;
    }

    public void add(double ax, double ay, double az) {
        this.x += ax;
        this.y += ay;
        this.z += az;
    }

    public void mul(double mx, double my, double mz) {
        this.x *= mx;
        this.y *= my;
        this.z *= mz;
    }

    public void mul(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public void sub(Vec3d vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void sub(Vec3f vec) {
        this.x -= (double)vec.x;
        this.y -= (double)vec.y;
        this.z -= (double)vec.z;
    }

    public void sub(Vec3d vec, double scale) {
        this.x -= vec.x * scale;
        this.y -= vec.y * scale;
        this.z -= vec.z * scale;
    }

    public void sub(Vec3f vec, double scale) {
        this.x -= (double)vec.x * scale;
        this.y -= (double)vec.y * scale;
        this.z -= (double)vec.z * scale;
    }

    public void clamp(double range) {
        this.clamp(-range, range);
    }

    public void clamp(double mn, double mx) {
        this.x = Math.max(mn, Math.min(mx, this.x));
        this.y = Math.max(mn, Math.min(mx, this.y));
        this.z = Math.max(mn, Math.min(mx, this.z));
    }

    public double dot(Vec3d vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public double dot(Vec3f vec) {
        return this.x * (double)vec.x + this.y * (double)vec.y + this.z * (double)vec.z;
    }

    public void cross(Vec3d vec) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = y * vec.z - z * vec.y;
        this.y = z * vec.x - x * vec.z;
        this.z = x * vec.y - y * vec.x;
    }

    public void cross(Vec3f vec) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = y * (double)vec.z - z * (double)vec.y;
        this.y = z * (double)vec.x - x * (double)vec.z;
        this.z = x * (double)vec.y - y * (double)vec.x;
    }

    public void reverseCross(Vec3d vec) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = vec.y * z - vec.z * y;
        this.y = vec.z * x - vec.x * z;
        this.z = vec.x * y - vec.y * x;
    }

    public void reverseCross(Vec3f vec) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = (double)vec.y * z - (double)vec.z * y;
        this.y = (double)vec.z * x - (double)vec.x * z;
        this.z = (double)vec.x * y - (double)vec.y * x;
    }

    public double normSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double hNormSquared() {
        return this.x * this.x + this.z * this.z;
    }

    public double hNorm() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double distance(Vec3d other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public double distanceSquared(Vec3d other) {
        double x_d = this.x - other.x;
        double y_d = this.y - other.y;
        double z_d = this.z - other.z;
        return x_d * x_d + y_d * y_d + z_d * z_d;
    }

    public void unitary() {
        double i = 1.0 / this.norm();
        this.x *= i;
        this.y *= i;
        this.z *= i;
    }

    public boolean isZero() {
        return this.normSquared() < 1.0E-24;
    }

    public boolean isZero(double epsilon) {
        return this.normSquared() < epsilon * epsilon;
    }

    public Vec3f toVector3() {
        return new Vec3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vec3 toVector3d() {
        return new Vec3(this.x, this.y, this.z);
    }

    public Vec3i toVector3i() {
        return new Vec3i((int)Math.round(this.x), (int)Math.round(this.y), (int)Math.round(this.z));
    }

    public int pack() {
        return (Math.round((float)this.x * 255.0f) & 0xFF) << 16 | (Math.round((float)this.y * 255.0f) & 0xFF) << 8 | Math.round((float)this.z * 255.0f) & 0xFF;
    }

    public static Vec3d unpack(int packed) {
        return new Vec3d((double)((float)(packed >> 16 & 0xFF) / 255.0f), (double)((float)(packed >> 8 & 0xFF) / 255.0f), (float)(packed & 0xFF) / 255.0f);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static Vec3d read(FriendlyByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static Vec3d readCommand(StringReader reader) throws CommandSyntaxException {
        double x = reader.readDouble();
        reader.expect(' ');
        double y = reader.readDouble();
        reader.expect(' ');
        double z = reader.readDouble();
        return new Vec3d(x, y, z);
    }

    public String writeCommand() {
        return String.format("%.3f %.3f %.3f", this.x, this.y, this.z);
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        nbt.m_128347_("z", this.z);
        return nbt;
    }

    public static Vec3d fromNBT(CompoundTag nbt) {
        return new Vec3d(nbt.m_128459_("x"), nbt.m_128459_("y"), nbt.m_128459_("z"));
    }

    public void readNBT(CompoundTag nbt) {
        this.x = nbt.m_128459_("x");
        this.y = nbt.m_128459_("y");
        this.z = nbt.m_128459_("z");
    }

    public void lerp(Vec3d vec, double t) {
        double r = 1.0 - t;
        this.x = this.x * r + vec.x * t;
        this.y = this.y * r + vec.y * t;
        this.z = this.z * r + vec.z * t;
    }

    public static Vec3d average(Collection<Vec3d> vectors) {
        Vec3d res = ZERO.get();
        int n = 0;
        for (Vec3d vec : vectors) {
            res.add(vec);
            ++n;
        }
        res.mul(1.0f / (float)n);
        return res;
    }

    public double[] asArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public List<Double> asList() {
        ArrayList<Double> l = new ArrayList<Double>();
        l.add(this.x);
        l.add(this.y);
        l.add(this.z);
        return l;
    }

    public double getPitch() {
        return -Math.asin(this.y) * 57.29577951308232;
    }

    public double getYaw() {
        return -Math.atan2(this.x, this.z) * 57.29577951308232;
    }

    public Vec3d copy() {
        return new Vec3d(this);
    }

    public void transform(Quaterniond quaternion) {
        Quaterniond q = new Quaterniond((Quaterniondc)quaternion);
        q.mul((Quaterniondc)new Quaterniond((double)((float)this.x), (double)((float)this.y), (double)((float)this.z), 0.0));
        Quaterniond qc = new Quaterniond((Quaterniondc)quaternion);
        qc.conjugate();
        q.mul((Quaterniondc)qc);
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public Quaterniond rotation(double angle) {
        double s = Math.sin(angle * 0.5);
        return new Quaterniond((double)((float)(this.x * s)), (double)((float)(this.y * s)), (double)((float)(this.z * s)), (double)((float)Math.cos(angle * 0.5)));
    }

    public Quaterniond rotationDegrees(double degrees) {
        return this.rotation(degrees * (Math.PI / 180));
    }

    public void rotateAlongVec(Vec3d axis, double angle) {
        this.transform(axis.rotation(angle));
    }

    public void rotateAlongVecDegrees(Vec3d axis, double degrees) {
        this.transform(axis.rotationDegrees(degrees));
    }

    public void rotateAlongOrtVec(Vec3d axis, double angle) {
        Vec3d cross = axis.copy();
        cross.cross(this);
        cross.mul(Math.sin(angle));
        this.mul(Math.cos(angle));
        this.add(cross);
    }

    public void rotateAlongOrtVecDegrees(Vec3d axis, double degrees) {
        this.rotateAlongOrtVec(axis, degrees * (Math.PI / 180));
    }

    public double angle(Vec3d vec) {
        return Math.acos(Mth.m_14008_((double)this.dot(vec), (double)-1.0, (double)1.0)) / (this.norm() * vec.norm());
    }

    public double angleDegrees(Vec3d vec) {
        return this.angle(vec) * 57.29577951308232;
    }

    public double angleUnitary(Vec3d vec) {
        return Math.acos(Mth.m_14008_((double)this.dot(vec), (double)-1.0, (double)1.0));
    }

    public double angleUnitaryDegrees(Vec3d vec) {
        return this.angleUnitary(vec) * 57.29577951308232;
    }

    public double angleUnitary(Vec3d vec, Vec3d axis) {
        double angle = Math.acos(Mth.m_14008_((double)this.dot(vec), (double)-1.0, (double)1.0));
        Vec3d compare = axis.copy();
        compare.cross(this);
        return vec.dot(compare) > 0.0 ? angle : Math.PI * 2 - angle;
    }

    public double angleUnitaryDegrees(Vec3d vec, Vec3d axis) {
        return this.angleUnitary(vec, axis) * 57.29577951308232;
    }

    public void mirror(Vec3d axis) {
        double d = this.dot(axis) * 2.0;
        this.x = d * axis.x - this.x;
        this.y = d * axis.y - this.y;
        this.z = d * axis.z - this.z;
    }

    public void reflect(Vec3d axis) {
        double d = this.dot(axis) * 2.0;
        this.x -= d * axis.x;
        this.y -= d * axis.y;
        this.z -= d * axis.z;
    }

    public Vec3d orthogonal() {
        return new Vec3d(this.y - this.z, this.z - this.x, this.x - this.y);
    }

    public Vec3d orthogonalUnitary() {
        if (this.isZero()) {
            return XP.get();
        }
        Vec3d v = new Vec3d(this.y - this.z, this.z - this.x, this.x - this.y);
        v.unitary();
        return v;
    }

    public Vec3d[] orthogonalPair() {
        Vec3d u = new Vec3d(this.y - this.z, this.z - this.x, this.x - this.y);
        Vec3d v = u.copy();
        v.cross(this);
        return new Vec3d[]{u, v};
    }

    public Vec3d[] orthogonalUnitaryPair() {
        Vec3d[] ret = this.orthogonalPair();
        ret[0].unitary();
        ret[1].unitary();
        return ret;
    }

    public void set(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public void set(Vec3i vec) {
        this.x = vec.m_123341_();
        this.y = vec.m_123342_();
        this.z = vec.m_123343_();
    }

    public void set(Vector3f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public void set(Vec3 vec) {
        this.x = vec.f_82479_;
        this.y = vec.f_82480_;
        this.z = vec.f_82481_;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vec3d vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public void set(double yaw, double pitch) {
        this.set(yaw, pitch, true);
    }

    public void set(double yaw, double pitch, boolean degrees) {
        if (degrees) {
            pitch *= Math.PI / 180;
            yaw *= Math.PI / 180;
        }
        double yawCos = Math.cos(yaw);
        double yawSin = Math.sin(yaw);
        double pitCos = Math.cos(pitch);
        double pitSin = Math.sin(pitch);
        this.x = -yawSin * pitCos;
        this.y = -pitSin;
        this.z = yawCos * pitCos;
    }

    public void setRandom() {
        this.x = random.nextDouble();
        this.y = random.nextDouble();
        this.z = random.nextDouble();
    }

    public void setRandom(double range) {
        this.setRandom();
        this.mul(2.0 * range);
        this.add(-range);
    }

    public void setRandom(double min, double max) {
        this.setRandom();
        this.mul(max - min);
        this.add(min);
    }

    public void setRandomUnitary() {
        double u = random.nextDouble() * 2.0 * Math.PI;
        double v = -1.0 + random.nextDouble() * 2.0;
        double h = Math.sqrt(1.0 - v * v);
        this.x = Math.cos(u) * h;
        this.y = Math.sin(u) * h;
        this.z = v;
    }

    public void setRandomSpherical() {
        double u = random.nextDouble() * 2.0 * Math.PI;
        double v = -1.0 + random.nextDouble() * 2.0;
        double r = Math.pow(random.nextDouble(), 0.5);
        double h = Math.sqrt(1.0 - v * v);
        this.x = Math.cos(u) * h * r;
        this.y = Math.sin(u) * h * r;
        this.z = v * r;
    }

    public void setOrthogonal(Vec3d other) {
        this.sub(other, this.dot(other));
    }

    public void setOrthogonalUnitary(Vec3d other) {
        if (other.isZero() && this.isZero()) {
            this.x = 1.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.sub(other, this.dot(other));
            if (this.isZero()) {
                this.x = other.y - other.z;
                this.y = other.z - other.x;
                this.z = other.x - other.y;
            }
            this.unitary();
        }
    }

    public void setOrthogonal(Vec3d u, Vec3d v) {
        u.set(this.y - this.z, this.z - this.x, this.x - this.y);
        v.set(u);
        v.cross(this);
    }

    public void setOrthogonalUnitary(Vec3d u, Vec3d v) {
        u.set(this.y - this.z, this.z - this.x, this.x - this.y);
        u.unitary();
        v.set(u);
        v.cross(this);
        v.unitary();
    }

    public static Vec3d forAxis(Direction.Axis axis) {
        if (axis == null) {
            return ZERO.get();
        }
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> XP.get();
            case Direction.Axis.Y -> YP.get();
            case Direction.Axis.Z -> ZP.get();
        };
    }

    public static Vec3d forDirection(Direction direction) {
        if (direction == null) {
            return ZERO.get();
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> YP.get();
            case Direction.DOWN -> YN.get();
            case Direction.EAST -> XP.get();
            case Direction.WEST -> XN.get();
            case Direction.SOUTH -> ZP.get();
            case Direction.NORTH -> ZN.get();
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Vec3d v = (Vec3d)obj;
            if (Double.compare(v.x, this.x) != 0) {
                return false;
            }
            if (Double.compare(v.y, this.y) != 0) {
                return false;
            }
            return Double.compare(v.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Double.hashCode(this.x);
        i = 31 * i + Double.hashCode(this.y);
        return 31 * i + Double.hashCode(this.z);
    }

    public DoubleStream stream() {
        return DoubleStream.of(this.x, this.y, this.z);
    }

    public String toString() {
        return this.toString(defaultFormat);
    }

    public String toString(String fmt) {
        return "[" + String.format(fmt, this.x) + ", " + String.format(fmt, this.y) + ", " + String.format(fmt, this.z) + "]";
    }
}

